/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.solr;

import java.util.Collections;
import java.util.Map;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.solr.SOLRTrackingComponentImpl;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SOLRTrackingComponentUnitTest {
    private static final QName FIRST_PROPERTY = QName.createQName((String)"the://first/property");
    private static final QName SECOND_PROPERTY = QName.createQName((String)"the://second/property");
    private static final long NODE_ID = 123L;
    @InjectMocks
    private SOLRTrackingComponentImpl solrTrackingComponent;
    @Mock
    private NodeDAO nodeDAO;
    @Mock
    private DictionaryService dictionaryService;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testGetProperties_indexedPropertiesPassedThrough() {
        Map<QName, Integer> propertiesFromDB = Map.of(FIRST_PROPERTY, "value1", SECOND_PROPERTY, 2);
        Mockito.when((Object)this.nodeDAO.getNodeProperties(Long.valueOf(123L))).thenReturn(propertiesFromDB);
        PropertyDefinition firstDefinition = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
        Mockito.when((Object)firstDefinition.isIndexed()).thenReturn((Object)true);
        Mockito.when((Object)this.dictionaryService.getProperty(FIRST_PROPERTY)).thenReturn((Object)firstDefinition);
        PropertyDefinition secondDefinition = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
        Mockito.when((Object)secondDefinition.isIndexed()).thenReturn((Object)true);
        Mockito.when((Object)this.dictionaryService.getProperty(SECOND_PROPERTY)).thenReturn((Object)secondDefinition);
        Map properties = this.solrTrackingComponent.getProperties(Long.valueOf(123L));
        Assert.assertEquals((String)"Expected both properties to be returned.", propertiesFromDB, (Object)properties);
    }

    @Test
    public void testGetProperties_propertyWithoutModelIsNotIndexed() {
        Map<QName, String> propertiesFromDB = Map.of(FIRST_PROPERTY, "value1");
        Mockito.when((Object)this.nodeDAO.getNodeProperties(Long.valueOf(123L))).thenReturn(propertiesFromDB);
        Mockito.when((Object)this.dictionaryService.getProperty(FIRST_PROPERTY)).thenReturn(null);
        Map properties = this.solrTrackingComponent.getProperties(Long.valueOf(123L));
        Assert.assertEquals((String)"Expected residual property to be skipped.", Collections.emptyMap(), (Object)properties);
    }

    @Test
    public void testGetProperties_propertySkippedIfIndexFalseSet() {
        Map<QName, String> propertiesFromDB = Map.of(FIRST_PROPERTY, "value1");
        Mockito.when((Object)this.nodeDAO.getNodeProperties(Long.valueOf(123L))).thenReturn(propertiesFromDB);
        PropertyDefinition firstDefinition = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
        Mockito.when((Object)firstDefinition.isIndexed()).thenReturn((Object)false);
        Mockito.when((Object)this.dictionaryService.getProperty(FIRST_PROPERTY)).thenReturn((Object)firstDefinition);
        Map properties = this.solrTrackingComponent.getProperties(Long.valueOf(123L));
        Assert.assertEquals((String)"Unexpected property when index enabled set to false.", Collections.emptyMap(), (Object)properties);
    }
}

