/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.OptionalPatchApplicationCheckBootstrapBean;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.StoreEntity;
import org.alfresco.repo.domain.permissions.AclCrudDAO;
import org.alfresco.repo.domain.permissions.Authority;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.search.SimpleResultSetMetaData;
import org.alfresco.repo.search.impl.lucene.PagingLuceneResultSet;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.repo.search.impl.querymodel.QueryEngine;
import org.alfresco.repo.search.impl.querymodel.QueryEngineResults;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.QueryModelFactory;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQuery;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryModelFactory;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBResultSet;
import org.alfresco.repo.search.impl.querymodel.impl.db.NodePermissionAssessor;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.impl.acegi.FilteringResultSet;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.executor.result.DefaultResultContext;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.mybatis.spring.SqlSessionTemplate;

@NotThreadSafe
public class DBQueryEngine
implements QueryEngine {
    protected static final Log logger = LogFactory.getLog(DBQueryEngine.class);
    protected static final String SELECT_BY_DYNAMIC_QUERY = "alfresco.metadata.query.select_byDynamicQuery";
    private static final int DEFAULT_MIN_PAGING_BATCH_SIZE = 2500;
    private static final int DEFAULT_MAX_PAGING_BATCH_SIZE = 10000;
    protected SqlSessionTemplate template;
    protected QNameDAO qnameDAO;
    private NodeDAO nodeDAO;
    protected DictionaryService dictionaryService;
    protected NamespaceService namespaceService;
    protected NodeService nodeService;
    private TenantService tenantService;
    private OptionalPatchApplicationCheckBootstrapBean metadataIndexCheck2;
    protected PermissionService permissionService;
    private int maxPermissionChecks;
    private long maxPermissionCheckTimeMillis;
    private boolean maxPermissionCheckEnabled;
    private boolean usePagingQuery = false;
    private int minPagingBatchSize = 2500;
    private int maxPagingBatchSize = 10000;
    protected EntityLookupCache<Long, Node, NodeRef> nodesCache;
    private List<Pair<Long, StoreRef>> stores;
    AclCrudDAO aclCrudDAO;

    public void setAclCrudDAO(AclCrudDAO aclCrudDAO) {
        this.aclCrudDAO = aclCrudDAO;
    }

    public void setMaxPermissionChecks(int maxPermissionChecks) {
        this.maxPermissionChecks = maxPermissionChecks;
    }

    public void setMaxPermissionCheckTimeMillis(long maxPermissionCheckTimeMillis) {
        this.maxPermissionCheckTimeMillis = maxPermissionCheckTimeMillis;
    }

    public void setMaxPermissionCheckEnabled(boolean maxPermissionCheckEnabled) {
        this.maxPermissionCheckEnabled = maxPermissionCheckEnabled;
    }

    public void setTemplate(SqlSessionTemplate template) {
        this.template = template;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public boolean isUsePagingQuery() {
        return this.usePagingQuery;
    }

    public void setUsePagingQuery(boolean usePagingQuery) {
        this.usePagingQuery = usePagingQuery;
    }

    public int getMinPagingBatchSize() {
        return this.minPagingBatchSize;
    }

    public void setMinPagingBatchSize(int minPagingBatchSize) {
        this.minPagingBatchSize = minPagingBatchSize;
    }

    public int getMaxPagingBatchSize() {
        return this.maxPagingBatchSize;
    }

    public void setMaxPagingBatchSize(int maxPagingBatchSize) {
        this.maxPagingBatchSize = maxPagingBatchSize;
    }

    public void setMetadataIndexCheck2(OptionalPatchApplicationCheckBootstrapBean metadataIndexCheck2) {
        this.metadataIndexCheck2 = metadataIndexCheck2;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public QueryEngineResults executeQuery(Query query, QueryOptions options, FunctionEvaluationContext functionContext) {
        long start = 0L;
        if (logger.isDebugEnabled()) {
            start = System.currentTimeMillis();
            logger.debug((Object)"Query request received");
        }
        Set selectorGroup = null;
        if (query.getSource() != null) {
            List selectorGroups = query.getSource().getSelectorGroups(functionContext);
            if (selectorGroups.size() == 0) {
                throw new QueryModelException("No selectors");
            }
            if (selectorGroups.size() > 1) {
                throw new QueryModelException("Advanced join is not supported");
            }
            selectorGroup = (Set)selectorGroups.get(0);
        }
        DBQuery dbQuery = (DBQuery)query;
        if (options.getStores().size() > 1) {
            throw new QueryModelException("Multi-store queries are not supported");
        }
        StoreRef storeRef = (StoreRef)options.getStores().get(0);
        storeRef = storeRef != null ? this.tenantService.getName(storeRef) : null;
        Pair<Long, StoreRef> store = this.nodeDAO.getStore(storeRef);
        if (store == null) {
            throw new QueryModelException("Unknown store: " + storeRef);
        }
        dbQuery.setStoreId((Long)store.getFirst());
        Pair<Long, QName> sysDeletedType = this.qnameDAO.getQName(ContentModel.TYPE_DELETED);
        if (sysDeletedType == null) {
            dbQuery.setSysDeletedType(-1L);
        } else {
            dbQuery.setSysDeletedType((Long)sysDeletedType.getFirst());
        }
        Long sinceTxId = options.getSinceTxId();
        if (sinceTxId == null) {
            sinceTxId = -1L;
        }
        dbQuery.setSinceTxId(sinceTxId);
        logger.debug((Object)"- query is being prepared");
        dbQuery.prepare(this.namespaceService, this.dictionaryService, this.qnameDAO, this.nodeDAO, this.tenantService, selectorGroup, null, functionContext, this.metadataIndexCheck2.getPatchApplied());
        ResultSet resultSet = this.selectNodesWithPermissions(options, dbQuery);
        if (logger.isDebugEnabled()) {
            long ms = System.currentTimeMillis() - start;
            logger.debug((Object)("Selected " + resultSet.length() + " nodes with permission resolution in " + ms + " ms"));
        }
        return this.asQueryEngineResults(resultSet);
    }

    protected String pickQueryTemplate(QueryOptions options, DBQuery dbQuery) {
        logger.debug((Object)"- using standard table for the query");
        return SELECT_BY_DYNAMIC_QUERY;
    }

    private ResultSet selectNodesWithPermissions(QueryOptions options, DBQuery dbQuery) {
        Authority authority = this.aclCrudDAO.getAuthority(AuthenticationUtil.getRunAsUser());
        NodePermissionAssessor permissionAssessor = this.createAssessor(authority);
        int maxPermsChecks = options.getMaxPermissionChecks() < 0 ? this.maxPermissionChecks : options.getMaxPermissionChecks();
        long maxPermCheckTimeMillis = options.getMaxPermissionCheckTimeMillis() < 0L ? this.maxPermissionCheckTimeMillis : options.getMaxPermissionCheckTimeMillis();
        permissionAssessor.setMaxPermissionChecks(maxPermsChecks);
        permissionAssessor.setMaxPermissionCheckTimeMillis(maxPermCheckTimeMillis);
        FilteringResultSet resultSet = this.acceleratedNodeSelection(options, dbQuery, permissionAssessor);
        PagingLuceneResultSet plrs = new PagingLuceneResultSet(resultSet, options.getAsSearchParmeters(), this.nodeService);
        plrs.setTrimmedResultSet(true);
        return plrs;
    }

    protected NodePermissionAssessor createAssessor(Authority authority) {
        return new NodePermissionAssessor(this.nodeService, this.permissionService, authority, this.nodesCache);
    }

    FilteringResultSet acceleratedNodeSelection(final QueryOptions options, DBQuery dbQuery, final NodePermissionAssessor permissionAssessor) {
        this.stores = this.nodeDAO.getStores();
        final ArrayList<Node> nodes = new ArrayList<Node>();
        final int requiredNodes = this.computeRequiredNodesCount(options);
        logger.debug((Object)"- query sent to the database");
        this.performTmdqSelect(this.pickQueryTemplate(options, dbQuery), dbQuery, requiredNodes, new ResultHandler<Node>(){

            public void handleResult(ResultContext<? extends Node> context) {
                if (!DBQueryEngine.this.maxPermissionCheckEnabled && nodes.size() >= requiredNodes) {
                    context.stop();
                    return;
                }
                Node node = (Node)context.getResultObject();
                DBQueryEngine.this.addStoreInfo(node);
                boolean shouldCache = this.shouldCache(options, nodes, requiredNodes);
                if (shouldCache) {
                    logger.debug((Object)("- selected node " + nodes.size() + ": " + node.getUuid() + " " + node.getId()));
                    DBQueryEngine.this.nodesCache.setValue(node.getId(), node);
                } else {
                    logger.debug((Object)("- skipped node " + nodes.size() + ": " + node.getUuid() + " " + node.getId()));
                }
                if (permissionAssessor.isIncluded(node)) {
                    if (nodes.size() > requiredNodes) {
                        nodes.add(node);
                    } else {
                        nodes.add(shouldCache ? node : null);
                    }
                }
                if (permissionAssessor.shouldQuitChecks()) {
                    context.stop();
                    return;
                }
            }

            private boolean shouldCache(QueryOptions options2, List<Node> nodes2, int requiredNodes2) {
                if (nodes2.size() > requiredNodes2) {
                    return false;
                }
                return nodes2.size() >= options2.getSkipCount();
            }
        });
        int numberFound = nodes.size();
        nodes.removeAll(Collections.singleton(null));
        DBResultSet rs = this.createResultSet(options, nodes, numberFound);
        FilteringResultSet frs = new FilteringResultSet(rs, this.formInclusionMask(nodes));
        frs.setResultSetMetaData(new SimpleResultSetMetaData(LimitBy.UNLIMITED, PermissionEvaluationMode.EAGER, rs.getResultSetMetaData().getSearchParameters()));
        logger.debug((Object)("- query is completed, " + nodes.size() + " nodes loaded"));
        return frs;
    }

    private void performTmdqSelect(String statement, DBQuery dbQuery, int requiredNodes, ResultHandler<Node> handler) {
        if (this.usePagingQuery) {
            this.performTmdqSelectPaging(statement, dbQuery, requiredNodes, handler);
        } else {
            this.performTmdqSelectStreaming(statement, dbQuery, handler);
        }
    }

    private void performTmdqSelectStreaming(String statement, DBQuery dbQuery, ResultHandler<Node> handler) {
        this.template.select(statement, (Object)dbQuery, handler);
    }

    private void performTmdqSelectPaging(String statement, DBQuery dbQuery, int requiredNodes, ResultHandler<Node> handler) {
        int batchStart = 0;
        int batchSize = requiredNodes * 2;
        batchSize = Math.min(Math.max(batchSize, this.minPagingBatchSize), this.maxPagingBatchSize);
        DefaultResultContext resultCtx = new DefaultResultContext();
        while (!resultCtx.isStopped()) {
            dbQuery.setOffset(batchStart);
            dbQuery.setLimit(batchSize);
            List batch = this.template.selectList(statement, (Object)dbQuery);
            for (Node node : batch) {
                resultCtx.nextResultObject((Object)node);
                handler.handleResult((ResultContext)resultCtx);
                if (resultCtx.isStopped()) break;
            }
            if (batch.size() < batchSize) {
                resultCtx.stop();
                continue;
            }
            batchStart += batchSize;
        }
    }

    private DBResultSet createResultSet(QueryOptions options, List<Node> nodes, int numberFound) {
        DBResultSet dbResultSet = new DBResultSet(options.getAsSearchParmeters(), nodes, this.nodeDAO, this.nodeService, this.tenantService, Integer.MAX_VALUE);
        dbResultSet.setNumberFound(numberFound);
        return dbResultSet;
    }

    private int computeRequiredNodesCount(QueryOptions options) {
        int maxItems = options.getMaxItems();
        if (maxItems == -1 || maxItems == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return maxItems + options.getSkipCount() + 1;
    }

    private BitSet formInclusionMask(List<Node> nodes) {
        BitSet inclusionMask = new BitSet(nodes.size());
        int i = 0;
        while (i < nodes.size()) {
            inclusionMask.set(i, true);
            ++i;
        }
        return inclusionMask;
    }

    private QueryEngineResults asQueryEngineResults(ResultSet paged) {
        HashSet<String> key = new HashSet<String>();
        key.add("");
        HashMap<HashSet<String>, ResultSet> answer = new HashMap<HashSet<String>, ResultSet>();
        answer.put(key, paged);
        return new QueryEngineResults(answer);
    }

    public QueryModelFactory getQueryModelFactory() {
        return new DBQueryModelFactory();
    }

    public void setNodesCache(SimpleCache<Serializable, Serializable> cache) {
        this.nodesCache = new EntityLookupCache<Long, Node, NodeRef>(cache, "N.N", new ReadonlyLocalCallbackDAO());
    }

    void setNodesCache(EntityLookupCache<Long, Node, NodeRef> nodesCache) {
        this.nodesCache = nodesCache;
    }

    private void addStoreInfo(Node node) {
        StoreEntity storeEntity = node.getStore();
        logger.debug((Object)("Adding store info for store id " + storeEntity.getId()));
        for (Pair<Long, StoreRef> storeRefPair : this.stores) {
            if (!Objects.equals(storeEntity.getId(), storeRefPair.getFirst())) continue;
            StoreRef storeRef = (StoreRef)storeRefPair.getSecond();
            storeEntity.setIdentifier(storeRef.getIdentifier());
            storeEntity.setProtocol(storeRef.getProtocol());
            logger.debug((Object)("Added store info" + storeEntity.toString()));
            break;
        }
    }

    private class ReadonlyLocalCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, Node, NodeRef> {
        private ReadonlyLocalCallbackDAO() {
        }

        @Override
        public Pair<Long, Node> createValue(Node value) {
            throw new UnsupportedOperationException("Node creation is done externally: " + value);
        }

        @Override
        public Pair<Long, Node> findByKey(Long nodeId) {
            return null;
        }

        @Override
        public NodeRef getValueKey(Node value) {
            return value.getNodeRef();
        }
    }
}

