/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.event.v1.model.ContentInfo;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.EventData;
import org.alfresco.repo.event.v1.model.EventType;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event.v1.model.Resource;
import org.alfresco.repo.event.v1.model.UserInfo;
import org.alfresco.repo.event2.EventConsolidator;
import org.alfresco.repo.event2.EventInfo;
import org.alfresco.repo.event2.EventSupportedPolicies;
import org.alfresco.repo.event2.NodeResourceHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.collections.CollectionUtils;

public class NodeEventConsolidator
extends EventConsolidator<NodeRef, NodeResource>
implements EventSupportedPolicies {
    private final List<QName> aspectsAdded = new ArrayList<QName>();
    private final List<QName> aspectsRemoved = new ArrayList<QName>();
    private NodeResource.Builder resourceBuilder;
    private Map<QName, Serializable> propertiesBefore;
    private Map<QName, Serializable> propertiesAfter;
    private QName nodeType;
    private QName nodeTypeBefore;
    private List<String> primaryHierarchyBefore;
    private List<String> secondaryParentsBefore;
    private boolean resourceBeforeAllFieldsNull = true;

    public NodeEventConsolidator(NodeResourceHelper nodeResourceHelper) {
        super(null, nodeResourceHelper);
    }

    @Override
    public RepoEvent<DataAttributes<NodeResource>> getRepoEvent(EventInfo eventInfo) {
        this.resource = this.buildNodeResource();
        return super.getRepoEvent(eventInfo);
    }

    @Override
    protected DataAttributes<NodeResource> buildEventData(EventInfo eventInfo, NodeResource resource, EventType eventType) {
        EventData.Builder eventDataBuilder = EventData.builder().setEventGroupId(eventInfo.getTxnId()).setResource((Resource)resource);
        if (eventType == EventType.NODE_UPDATED) {
            eventDataBuilder.setResourceBefore((Resource)this.buildNodeResourceBeforeDelta(resource));
        }
        return eventDataBuilder.build();
    }

    protected void createBuilderIfAbsent(NodeRef nodeRef, boolean forceUpdate) {
        if (this.resourceBuilder == null || forceUpdate) {
            this.resourceBuilder = this.helper.createNodeResourceBuilder(nodeRef);
            this.entityReference = nodeRef;
            this.nodeType = this.helper.getNodeType(nodeRef);
        }
    }

    protected void createBuilderIfAbsent(NodeRef nodeRef) {
        this.createBuilderIfAbsent(nodeRef, false);
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        this.eventTypes.add(EventType.NODE_CREATED);
        NodeRef nodeRef = childAssocRef.getChildRef();
        this.createBuilderIfAbsent(nodeRef);
        this.propertiesBefore = null;
        this.setBeforeProperties(Collections.emptyMap());
        this.setAfterProperties(this.helper.getProperties(nodeRef));
    }

    @Override
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        this.eventTypes.add(EventType.NODE_UPDATED);
        this.createBuilderIfAbsent(newChildAssocRef.getChildRef());
        if (newChildAssocRef.isPrimary()) {
            this.setBeforePrimaryHierarchy(this.helper.getPrimaryHierarchy(oldChildAssocRef.getParentRef(), true));
        } else {
            List<String> secondaryParents = this.helper.getSecondaryParents(newChildAssocRef.getChildRef());
            if (newChildAssocRef.getParentRef() != null) {
                secondaryParents.remove(newChildAssocRef.getParentRef().getId());
            } else if (oldChildAssocRef.getParentRef() != null && !secondaryParents.contains(oldChildAssocRef.getParentRef().getId())) {
                secondaryParents.add(oldChildAssocRef.getParentRef().getId());
            }
            this.setSecondaryParentsBefore(secondaryParents);
        }
    }

    @Override
    public void onSetNodeType(NodeRef nodeRef, QName before, QName after) {
        this.eventTypes.add(EventType.NODE_UPDATED);
        this.nodeTypeBefore = before;
        this.createBuilderIfAbsent(nodeRef);
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        this.eventTypes.add(EventType.NODE_UPDATED);
        if (before.isEmpty() && this.propertiesAfter != null) {
            before = this.propertiesAfter;
        }
        this.createBuilderIfAbsent(nodeRef);
        this.setBeforeProperties(before);
        this.setAfterProperties(after);
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        this.eventTypes.add(EventType.NODE_DELETED);
        this.createBuilderIfAbsent(nodeRef);
    }

    @Override
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        this.eventTypes.add(EventType.NODE_UPDATED);
        this.addAspect(aspectTypeQName);
        this.createBuilderIfAbsent(nodeRef);
    }

    void addAspect(QName aspectTypeQName) {
        if (this.aspectsRemoved.contains(aspectTypeQName)) {
            this.aspectsRemoved.remove(aspectTypeQName);
        } else {
            this.aspectsAdded.add(aspectTypeQName);
        }
    }

    @Override
    public void onRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        this.eventTypes.add(EventType.NODE_UPDATED);
        this.removeAspect(aspectTypeQName);
        this.createBuilderIfAbsent(nodeRef);
    }

    void removeAspect(QName aspectTypeQName) {
        if (this.aspectsAdded.contains(aspectTypeQName)) {
            this.aspectsAdded.remove(aspectTypeQName);
        } else {
            this.aspectsRemoved.add(aspectTypeQName);
        }
    }

    private void setAfterProperties(Map<QName, Serializable> after) {
        this.propertiesAfter = after;
    }

    private void setBeforeProperties(Map<QName, Serializable> before) {
        if (this.propertiesBefore == null) {
            this.propertiesBefore = before;
        }
    }

    private void setBeforePrimaryHierarchy(List<String> before) {
        if (this.primaryHierarchyBefore == null) {
            this.primaryHierarchyBefore = before;
        }
    }

    private void setSecondaryParentsBefore(List<String> secondaryParents) {
        if (this.secondaryParentsBefore == null) {
            this.secondaryParentsBefore = secondaryParents;
        }
    }

    List<String> getSecondaryParentsBefore() {
        return this.secondaryParentsBefore;
    }

    private NodeResource buildNodeResource() {
        if (this.resourceBuilder == null) {
            return null;
        }
        if (this.eventTypes.getLast() != EventType.NODE_DELETED && this.helper.nodeExists((NodeRef)this.entityReference)) {
            this.createBuilderIfAbsent((NodeRef)this.entityReference, true);
        }
        return this.resourceBuilder.build();
    }

    protected NodeResource buildNodeResourceBeforeDelta(NodeResource after) {
        Set<String> aspectsBefore;
        if (after == null) {
            return null;
        }
        NodeResource.Builder builder = NodeResource.builder();
        ZonedDateTime modifiedAt = null;
        Map<QName, Serializable> changedPropsBefore = this.getBeforeMapChanges(this.propertiesBefore, this.propertiesAfter);
        if (!changedPropsBefore.isEmpty()) {
            UserInfo modifier;
            ContentInfo contentInfo;
            String name;
            Map<String, Map<String, String>> localizedProps;
            Map<String, Serializable> mappedProps = this.helper.mapToNodeProperties(changedPropsBefore);
            if (!mappedProps.isEmpty()) {
                builder.setProperties(mappedProps);
                this.resourceBeforeAllFieldsNull = false;
            }
            if (!(localizedProps = this.helper.getLocalizedPropertiesBefore(changedPropsBefore, after)).isEmpty()) {
                builder.setLocalizedProperties(localizedProps);
                this.resourceBeforeAllFieldsNull = false;
            }
            if ((name = (String)((Object)changedPropsBefore.get(ContentModel.PROP_NAME))) != null) {
                builder.setName(name);
                this.resourceBeforeAllFieldsNull = false;
            }
            if ((contentInfo = this.helper.getContentInfo(changedPropsBefore)) != null) {
                builder.setContent(contentInfo);
                this.resourceBeforeAllFieldsNull = false;
            }
            if ((modifier = this.helper.getUserInfo((String)((Object)changedPropsBefore.get(ContentModel.PROP_MODIFIER)))) != null) {
                builder.setModifiedByUser(modifier);
                this.resourceBeforeAllFieldsNull = false;
            }
            modifiedAt = this.helper.getZonedDateTime((Date)changedPropsBefore.get(ContentModel.PROP_MODIFIED));
        }
        if (this.propertiesBefore != null && !this.propertiesBefore.containsKey(ContentModel.PROP_CONTENT) && this.propertiesAfter != null && this.propertiesAfter.containsKey(ContentModel.PROP_CONTENT)) {
            builder.setContent(new ContentInfo());
            this.resourceBeforeAllFieldsNull = false;
        }
        if (!(aspectsBefore = this.getMappedAspectsBefore(after.getAspectNames())).isEmpty()) {
            builder.setAspectNames(aspectsBefore);
            this.resourceBeforeAllFieldsNull = false;
        }
        if (this.primaryHierarchyBefore != null && !this.primaryHierarchyBefore.isEmpty()) {
            builder.setPrimaryHierarchy(this.primaryHierarchyBefore);
            this.resourceBeforeAllFieldsNull = false;
        }
        if (this.secondaryParentsBefore != null) {
            builder.setSecondaryParents(this.secondaryParentsBefore);
            this.resourceBeforeAllFieldsNull = false;
        }
        if (this.nodeTypeBefore != null) {
            builder.setNodeType(this.helper.getQNamePrefixString(this.nodeTypeBefore));
            this.resourceBeforeAllFieldsNull = false;
        }
        if (modifiedAt != null && !this.resourceBeforeAllFieldsNull) {
            builder.setModifiedAt(modifiedAt);
        }
        return builder.build();
    }

    Set<String> getMappedAspectsBefore(Set<String> currentAspects) {
        if (currentAspects == null) {
            currentAspects = Collections.emptySet();
        }
        if (this.hasChangedAspect()) {
            Set<String> removed = this.helper.mapToNodeAspects(this.aspectsRemoved);
            Set<String> added = this.helper.mapToNodeAspects(this.aspectsAdded);
            HashSet<String> before = new HashSet<String>();
            if (!removed.isEmpty() || !added.isEmpty()) {
                before = new HashSet<String>(currentAspects);
                if (!removed.isEmpty()) {
                    before.addAll(removed);
                }
                if (!added.isEmpty()) {
                    before.removeAll(added);
                }
            }
            return before;
        }
        return Collections.emptySet();
    }

    private boolean hasChangedAspect() {
        return (!this.aspectsRemoved.isEmpty() || !this.aspectsAdded.isEmpty()) && !CollectionUtils.isEqualCollection(this.aspectsAdded, this.aspectsRemoved);
    }

    private <K, V> Map<K, V> getBeforeMapChanges(Map<K, V> before, Map<K, V> after) {
        if (before == null) {
            return Collections.emptyMap();
        }
        if (after == null) {
            after = Collections.emptyMap();
        }
        HashMap beforeDelta = new HashMap(before);
        HashMap<K, V> afterDelta = new HashMap<K, V>(after);
        beforeDelta.entrySet().removeAll(after.entrySet());
        Set<K> beforeKeys = before.keySet();
        Set newKeys = afterDelta.keySet();
        newKeys.removeAll(beforeKeys);
        for (Object key : newKeys) {
            beforeDelta.put(key, null);
        }
        return beforeDelta;
    }

    @Override
    protected EventType getDerivedEvent() {
        if (this.isTemporaryEntity()) {
            return EventType.NODE_DELETED;
        }
        if (this.eventTypes.contains(EventType.NODE_CREATED)) {
            return EventType.NODE_CREATED;
        }
        if (this.eventTypes.getLast() == EventType.NODE_DELETED) {
            return EventType.NODE_DELETED;
        }
        return (EventType)this.eventTypes.getFirst();
    }

    @Override
    public boolean isTemporaryEntity() {
        return this.eventTypes.contains(EventType.NODE_CREATED) && this.eventTypes.getLast() == EventType.NODE_DELETED;
    }

    @Override
    public QName getEntityType() {
        return this.nodeType;
    }

    public List<QName> getAspectsAdded() {
        return this.aspectsAdded;
    }

    public List<QName> getAspectsRemoved() {
        return this.aspectsRemoved;
    }

    public boolean isResourceBeforeAllFieldsNull() {
        return this.resourceBeforeAllFieldsNull;
    }

    public boolean isEventTypeEqualTo(EventType eventType) {
        return this.getDerivedEvent().getType().equals(eventType.getType());
    }

    protected void setResourceBeforeAllFieldsNull(boolean resourceBeforeAllFieldsNull) {
        this.resourceBeforeAllFieldsNull = resourceBeforeAllFieldsNull;
    }
}

