/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class AuthorityTypeBehaviour
implements NodeServicePolicies.OnUpdatePropertiesPolicy,
InitializingBean {
    private static Log logger = LogFactory.getLog(AuthorityTypeBehaviour.class);
    private static final String USERNAME_FIELD = "userName";
    private static final String INVALID_USERNAME_VALUE = "";
    private PolicyComponent policyComponent;
    private AuthorityService authorityService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), ContentModel.TYPE_AUTHORITY, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (this.modifyingOwnAccount(before, after)) {
            return;
        }
        if (!AuthenticationUtil.isRunAsUserTheSystemUser() && !this.authorityService.hasAdminAuthority()) {
            throw new AccessDeniedException("Only users with ROLE_ADMINISTRATOR are allowed to manage users.");
        }
    }

    private boolean modifyingOwnAccount(Map<QName, Serializable> before, Map<QName, Serializable> after) {
        String beforeUsername = this.findUsernameInProperties(before, USERNAME_FIELD, INVALID_USERNAME_VALUE);
        String afterUsername = this.findUsernameInProperties(after, USERNAME_FIELD, INVALID_USERNAME_VALUE);
        if (afterUsername.equals(beforeUsername)) {
            String authenticatedUser = AuthenticationUtil.getFullyAuthenticatedUser();
            return beforeUsername.equals(authenticatedUser);
        }
        return false;
    }

    private String findUsernameInProperties(Map<QName, Serializable> map, String usernameField, String invalidValue) {
        Optional<QName> first = map.keySet().stream().filter(q -> q.getLocalName().equals(usernameField)).findFirst();
        if (first.isPresent()) {
            return map.get(first.get()).toString();
        }
        return invalidValue;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"authorityService", (Object)this.authorityService);
    }
}

