/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl;

import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.permissions.AccessControlListDAO;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={LuceneTests.class})
public abstract class AbstractReadPermissionTest
extends TestCase {
    protected static ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
    protected static final String ROLE_AUTHENTICATED = "ROLE_AUTHENTICATED";
    protected NodeService nodeService;
    protected DictionaryService dictionaryService;
    protected PermissionServiceSPI permissionService;
    protected MutableAuthenticationService authenticationService;
    protected MutableAuthenticationDao authenticationDAO;
    protected NodeRef rootNodeRef;
    protected NamespacePrefixResolver namespacePrefixResolver;
    protected ServiceRegistry serviceRegistry;
    protected NodeRef systemNodeRef;
    protected AuthenticationComponent authenticationComponent;
    protected ModelDAO permissionModelDAO;
    protected PersonService personService;
    protected AuthorityService authorityService;
    protected AuthorityDAO authorityDAO;
    protected NodeDAO nodeDAO;
    protected AclDAO aclDaoComponent;
    protected RetryingTransactionHelper retryingTransactionHelper;
    protected TransactionService transactionService;
    protected AccessControlListDAO accessControlListDao;
    protected FileFolderService fileFolderService;
    protected OwnableService ownableService;
    protected UserTransaction testTX;
    protected IndexerAndSearcher fIndexerAndSearcher;
    protected boolean logToFile = false;
    protected String[] webAuthorities = new String[]{"Web1", "Web2", "Web3", "Web4", "Web5"};
    protected String[] authorities = new String[]{"Dynamic", "1000", "1001", "Y", "Z", "X", "10_1", "100", "10", "1", "01", "001", "0001"};
    final int WEB_COUNT = 100;
    protected int COUNT = 10;
    protected Counter c01 = new Counter();
    protected Counter c001 = new Counter();
    protected Counter c0001 = new Counter();

    private Map<QName, Serializable> createPersonProperties(String userName) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        return properties;
    }

    protected void createAuthentication(String name) {
        if (this.authenticationDAO.userExists(name)) {
            this.authenticationService.deleteAuthentication(name);
        }
        this.authenticationService.createAuthentication(name, name.toCharArray());
        if (this.personService.personExists(name)) {
            this.personService.deletePerson(name);
        }
        this.personService.createPerson(this.createPersonProperties(name));
    }

    protected void createGroup(String name) {
        this.authorityService.createAuthority(AuthorityType.GROUP, name);
    }

    protected void runAs(String userName) {
        this.authenticationService.authenticate(userName, userName.toCharArray());
        AbstractReadPermissionTest.assertNotNull((Object)this.authenticationService.getCurrentUserName());
    }

    protected NodeRef[] build1000Nodes(String authority, int returnNodes, boolean inherit) {
        return this.build1000Nodes(authority, "Read", returnNodes, inherit);
    }

    protected NodeRef[] buildOwnedNodes(final String authority, final int returnNodes) {
        this.runAs("admin");
        final NodeRef[] nodes = new NodeRef[returnNodes];
        RetryingTransactionHelper.RetryingTransactionCallback<Void> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                int i = 0;
                int k = returnNodes > 0 ? 1000 / returnNodes : 0;
                String namePrefix = "simple" + System.currentTimeMillis();
                NodeRef folder = AbstractReadPermissionTest.this.fileFolderService.create(AbstractReadPermissionTest.this.rootNodeRef, namePrefix, ContentModel.TYPE_FOLDER).getNodeRef();
                NodeRef folder_1000 = AbstractReadPermissionTest.this.fileFolderService.create(folder, String.valueOf(namePrefix) + "-1000-", ContentModel.TYPE_FOLDER).getNodeRef();
                AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(folder_1000, false);
                AbstractReadPermissionTest.this.permissionService.setPermission(folder_1000, authority, "Read", true);
                int j = 0;
                while (j < 1000) {
                    NodeRef file = AbstractReadPermissionTest.this.fileFolderService.create(folder_1000, String.valueOf(namePrefix) + "-1000-" + j, ContentModel.TYPE_CONTENT).getNodeRef();
                    AbstractReadPermissionTest.this.ownableService.setOwner(file, authority);
                    if (returnNodes > 0 && j % k == 0) {
                        nodes[i++] = file;
                    }
                    ++j;
                }
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)cb, false, false);
        return nodes;
    }

    protected void buildNodes(final String user, final String permission, final int n, final boolean inherit) {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                String namePrefix = "simple" + System.currentTimeMillis();
                NodeRef folder = AbstractReadPermissionTest.this.fileFolderService.create(AbstractReadPermissionTest.this.rootNodeRef, namePrefix, ContentModel.TYPE_FOLDER).getNodeRef();
                NodeRef folder_n = AbstractReadPermissionTest.this.fileFolderService.create(folder, String.valueOf(namePrefix) + "-n", ContentModel.TYPE_FOLDER).getNodeRef();
                AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(folder_n, false);
                AbstractReadPermissionTest.this.permissionService.setPermission(folder_n, user, "Read", true);
                int j = 0;
                while (j < n) {
                    NodeRef file = AbstractReadPermissionTest.this.fileFolderService.create(folder_n, String.valueOf(namePrefix) + "-n-" + j, ContentModel.TYPE_CONTENT).getNodeRef();
                    if (!inherit) {
                        AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(file, false);
                        if (permission != null) {
                            AbstractReadPermissionTest.this.permissionService.setPermission(file, user, permission, true);
                        }
                    }
                    ++j;
                }
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)cb, false, false);
    }

    protected NodeRef[] build1000Nodes(final String authority, final String permission, final int returnNodes, final boolean inherit) {
        this.runAs("admin");
        final NodeRef[] nodes = new NodeRef[returnNodes];
        RetryingTransactionHelper.RetryingTransactionCallback<Void> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                int i = 0;
                int k = returnNodes > 0 ? 1000 / returnNodes : 0;
                String namePrefix = "simple" + System.currentTimeMillis();
                NodeRef folder = AbstractReadPermissionTest.this.fileFolderService.create(AbstractReadPermissionTest.this.rootNodeRef, namePrefix, ContentModel.TYPE_FOLDER).getNodeRef();
                NodeRef folder_1000 = AbstractReadPermissionTest.this.fileFolderService.create(folder, String.valueOf(namePrefix) + "-1000-", ContentModel.TYPE_FOLDER).getNodeRef();
                AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(folder_1000, false);
                AbstractReadPermissionTest.this.permissionService.setPermission(folder_1000, authority, permission, true);
                int j = 0;
                while (j < 1000) {
                    NodeRef file = AbstractReadPermissionTest.this.fileFolderService.create(folder_1000, String.valueOf(namePrefix) + "-1000-" + j, ContentModel.TYPE_CONTENT).getNodeRef();
                    if (!inherit) {
                        AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(file, false);
                        AbstractReadPermissionTest.this.permissionService.setPermission(file, authority, permission, true);
                    }
                    if (returnNodes > 0 && j % k == 0) {
                        nodes[i++] = file;
                    }
                    ++j;
                }
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)cb, false, false);
        return nodes;
    }

    protected NodeRef[] build1000Nodes(String authority, String permission, boolean inherit) {
        return this.build1000Nodes(authority, permission, 0, inherit);
    }

    protected void build1000NodesReadDenied(final String authority) {
        this.runAs("admin");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                String name = "simple" + System.currentTimeMillis();
                NodeRef folder = AbstractReadPermissionTest.this.fileFolderService.create(AbstractReadPermissionTest.this.rootNodeRef, name, ContentModel.TYPE_FOLDER).getNodeRef();
                NodeRef folder_1001 = AbstractReadPermissionTest.this.fileFolderService.create(folder, String.valueOf(name) + "-1001", ContentModel.TYPE_FOLDER).getNodeRef();
                AbstractReadPermissionTest.this.permissionService.setPermission(folder_1001, authority, "Read", true);
                AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(folder_1001, false);
                int j = 0;
                while (j < 1000) {
                    NodeRef file = AbstractReadPermissionTest.this.fileFolderService.create(folder_1001, String.valueOf(name) + "-1001-" + j, ContentModel.TYPE_CONTENT).getNodeRef();
                    AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(file, false);
                    AbstractReadPermissionTest.this.permissionService.setPermission(file, authority, "Read", false);
                    ++j;
                }
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)cb, false, false);
    }

    protected void buildNodes() {
        final Random random = new Random(42L);
        this.runAs("admin");
        this.permissionService.setPermission(this.rootNodeRef, "GROUP_EVERYONE", "Read", true);
        int ii = 0;
        while (ii < this.COUNT) {
            final String namePrefix = "name" + System.currentTimeMillis() + "-";
            final int i = ii++;
            System.out.println("Loop " + i);
            RetryingTransactionHelper.RetryingTransactionCallback<Void> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    NodeRef folder = AbstractReadPermissionTest.this.fileFolderService.create(AbstractReadPermissionTest.this.rootNodeRef, String.valueOf(namePrefix) + i, ContentModel.TYPE_FOLDER).getNodeRef();
                    NodeRef folder_1000 = AbstractReadPermissionTest.this.fileFolderService.create(folder, String.valueOf(namePrefix) + "1000-" + i, ContentModel.TYPE_FOLDER).getNodeRef();
                    AbstractReadPermissionTest.this.permissionService.setPermission(folder_1000, "1000", "Read", true);
                    AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(folder_1000, false);
                    int j = 0;
                    while (j < 1000) {
                        AbstractReadPermissionTest.this.fileFolderService.create(folder_1000, String.valueOf(namePrefix) + "1000-" + i + "-" + j, ContentModel.TYPE_CONTENT).getNodeRef();
                        ++j;
                    }
                    NodeRef folder_100 = AbstractReadPermissionTest.this.fileFolderService.create(folder, String.valueOf(namePrefix) + "100-" + i, ContentModel.TYPE_FOLDER).getNodeRef();
                    AbstractReadPermissionTest.this.permissionService.setPermission(folder_100, "100", "Read", true);
                    AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(folder_100, false);
                    int j2 = 0;
                    while (j2 < 100) {
                        AbstractReadPermissionTest.this.fileFolderService.create(folder_100, String.valueOf(namePrefix) + "100-" + i + "-" + j2, ContentModel.TYPE_CONTENT).getNodeRef();
                        ++j2;
                    }
                    NodeRef folder_10 = AbstractReadPermissionTest.this.fileFolderService.create(folder, String.valueOf(namePrefix) + "10-" + i, ContentModel.TYPE_FOLDER).getNodeRef();
                    AbstractReadPermissionTest.this.permissionService.setPermission(folder_10, "10", "Read", true);
                    AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(folder_10, false);
                    int j3 = 0;
                    while (j3 < 10) {
                        AbstractReadPermissionTest.this.fileFolderService.create(folder_10, String.valueOf(namePrefix) + "10-" + i + "-" + j3, ContentModel.TYPE_CONTENT).getNodeRef();
                        ++j3;
                    }
                    NodeRef folder_10_1 = AbstractReadPermissionTest.this.fileFolderService.create(folder, String.valueOf(namePrefix) + "10_1-" + i, ContentModel.TYPE_FOLDER).getNodeRef();
                    AbstractReadPermissionTest.this.permissionService.setPermission(folder_10_1, "GROUP_X", "Read", true);
                    AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(folder_10_1, false);
                    int j4 = 0;
                    while (j4 < 10) {
                        AbstractReadPermissionTest.this.fileFolderService.create(folder_10_1, "namePrefix + 10_1-" + i + "-" + j4, ContentModel.TYPE_CONTENT).getNodeRef();
                        ++j4;
                    }
                    NodeRef folder_1 = AbstractReadPermissionTest.this.fileFolderService.create(folder, String.valueOf(namePrefix) + "1" + i, ContentModel.TYPE_FOLDER).getNodeRef();
                    AbstractReadPermissionTest.this.permissionService.setPermission(folder_1, "1", "Read", true);
                    AbstractReadPermissionTest.this.permissionService.setInheritParentPermissions(folder_1, false);
                    AbstractReadPermissionTest.this.fileFolderService.create(folder_1, String.valueOf(namePrefix) + "1-1-1", ContentModel.TYPE_CONTENT).getNodeRef();
                    double rn = random.nextDouble();
                    if (rn < 0.1) {
                        AbstractReadPermissionTest.this.fileFolderService.create(folder, String.valueOf(namePrefix) + "0.1", ContentModel.TYPE_CONTENT).getNodeRef();
                        AbstractReadPermissionTest.this.c01.increment();
                    }
                    if (rn < 0.01) {
                        AbstractReadPermissionTest.this.fileFolderService.create(folder, String.valueOf(namePrefix) + "0.01", ContentModel.TYPE_CONTENT).getNodeRef();
                        AbstractReadPermissionTest.this.c001.increment();
                    }
                    if (rn < 0.001) {
                        AbstractReadPermissionTest.this.fileFolderService.create(folder, String.valueOf(namePrefix) + "0.001", ContentModel.TYPE_CONTENT).getNodeRef();
                        AbstractReadPermissionTest.this.c0001.increment();
                    }
                    return null;
                }
            };
            this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)cb, false, false);
        }
    }

    protected void deleteAuthentication(String name) {
        if (this.authenticationDAO.userExists(name)) {
            this.authenticationService.deleteAuthentication(name);
        }
        if (this.personService.personExists(name)) {
            this.personService.deletePerson(name);
        }
    }

    public void setUp() throws Exception {
        String authority;
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new AlfrescoRuntimeException("A previous tests did not clean up transaction: " + AlfrescoTransactionSupport.getTransactionId());
        }
        this.nodeService = (NodeService)applicationContext.getBean("nodeService");
        this.dictionaryService = (DictionaryService)applicationContext.getBean(ServiceRegistry.DICTIONARY_SERVICE.getLocalName());
        this.permissionService = (PermissionServiceSPI)applicationContext.getBean("permissionService");
        this.namespacePrefixResolver = (NamespacePrefixResolver)applicationContext.getBean(ServiceRegistry.NAMESPACE_SERVICE.getLocalName());
        this.authenticationService = (MutableAuthenticationService)applicationContext.getBean("authenticationService");
        this.authenticationComponent = (AuthenticationComponent)applicationContext.getBean("authenticationComponent");
        this.serviceRegistry = (ServiceRegistry)applicationContext.getBean("ServiceRegistry");
        this.permissionModelDAO = (ModelDAO)applicationContext.getBean("permissionsModelDAO");
        this.personService = (PersonService)applicationContext.getBean("personService");
        this.authorityService = (AuthorityService)applicationContext.getBean("authorityService");
        this.authorityDAO = (AuthorityDAO)applicationContext.getBean("authorityDAO");
        this.accessControlListDao = (AccessControlListDAO)applicationContext.getBean("admNodeACLDAO");
        this.fileFolderService = (FileFolderService)applicationContext.getBean("fileFolderService");
        this.authenticationComponent.setCurrentUser(this.authenticationComponent.getSystemUserName());
        this.authenticationDAO = (MutableAuthenticationDao)applicationContext.getBean("authenticationDao");
        this.nodeDAO = (NodeDAO)applicationContext.getBean("nodeDAO");
        this.aclDaoComponent = (AclDAO)applicationContext.getBean("aclDAO");
        this.retryingTransactionHelper = (RetryingTransactionHelper)applicationContext.getBean("retryingTransactionHelper");
        this.transactionService = (TransactionService)applicationContext.getBean("transactionComponent");
        this.ownableService = (OwnableService)applicationContext.getBean("ownableService");
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.nanoTime());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        if (this.authenticationDAO.userExists("andy")) {
            this.authenticationService.deleteAuthentication("andy");
        }
        this.authenticationService.createAuthentication("andy", "andy".toCharArray());
        if (this.authenticationDAO.userExists("lemur")) {
            this.authenticationService.deleteAuthentication("lemur");
        }
        this.authenticationService.createAuthentication("lemur", "lemur".toCharArray());
        if (this.authenticationDAO.userExists(AuthenticationUtil.getAdminUserName())) {
            this.authenticationService.deleteAuthentication(AuthenticationUtil.getAdminUserName());
        }
        this.authenticationService.createAuthentication(AuthenticationUtil.getAdminUserName(), "admin".toCharArray());
        this.fIndexerAndSearcher = (IndexerAndSearcher)applicationContext.getBean("indexerAndSearcherFactory");
        String[] stringArray = this.authorities;
        int n = this.authorities.length;
        int n2 = 0;
        while (n2 < n) {
            authority = stringArray[n2];
            this.createAuthentication(authority);
            ++n2;
        }
        stringArray = this.webAuthorities;
        n = this.webAuthorities.length;
        n2 = 0;
        while (n2 < n) {
            authority = stringArray[n2];
            this.createAuthentication(authority);
            ++n2;
        }
        this.createGroup("X");
        this.authorityService.addAuthority(this.authorityService.getName(AuthorityType.GROUP, "X"), "10_1");
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    protected void tearDown() throws Exception {
        try {
            this.testTX.rollback();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    protected class Counter {
        int i = 0;

        protected Counter() {
        }

        void increment() {
            ++this.i;
        }

        int count() {
            return this.i;
        }
    }
}

