/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

public final class OperationStats {
    private final double totalTime;
    private final long count;

    public OperationStats(double totalTime, long count) {
        this.totalTime = totalTime;
        this.count = count;
    }

    public OperationStats(OperationStats source, double totalTime, long count) {
        this.totalTime = Double.compare(source.totalTime, Double.NaN) == 0 ? totalTime : source.totalTime + totalTime;
        this.count = source.count + count;
    }

    public double meanTime() {
        return this.totalTime / (double)this.count;
    }

    public double getTotalTime() {
        return this.totalTime;
    }

    public long getCount() {
        return this.count;
    }
}

