/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remotecredentials;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.node.encryption.MetadataEncryptor;
import org.alfresco.repo.remotecredentials.PasswordCredentialsInfoImpl;
import org.alfresco.repo.remotecredentials.RemoteCredentialsInfoFactory;
import org.alfresco.repo.remotecredentials.RemoteCredentialsModel;
import org.alfresco.service.cmr.remotecredentials.BaseCredentialsInfo;
import org.alfresco.service.cmr.remotecredentials.PasswordCredentialsInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class PasswordCredentialsFactory
implements RemoteCredentialsInfoFactory {
    private MetadataEncryptor metadataEncryptor;

    public void setMetadataEncryptor(MetadataEncryptor metadataEncryptor) {
        this.metadataEncryptor = metadataEncryptor;
    }

    @Override
    public PasswordCredentialsInfo createCredentials(QName type, NodeRef nodeRef, String remoteSystemName, NodeRef remoteSystemContainerNodeRef, Map<QName, Serializable> properties) {
        String password = (String)((Object)this.metadataEncryptor.decrypt(RemoteCredentialsModel.PROP_REMOTE_PASSWORD, properties.get(RemoteCredentialsModel.PROP_REMOTE_PASSWORD)));
        PasswordCredentialsInfoImpl credentials = new PasswordCredentialsInfoImpl(nodeRef, remoteSystemName, remoteSystemContainerNodeRef);
        RemoteCredentialsInfoFactory.FactoryHelper.setCoreCredentials(credentials, properties);
        credentials.setRemotePassword(password);
        return credentials;
    }

    @Override
    public Map<QName, Serializable> serializeCredentials(BaseCredentialsInfo info) {
        if (!(info instanceof PasswordCredentialsInfo)) {
            throw new IllegalStateException("Incorrect registration, info must be a PasswordCredentialsInfo");
        }
        PasswordCredentialsInfo credentials = (PasswordCredentialsInfo)info;
        Serializable passwordEncrypted = this.metadataEncryptor.encrypt(RemoteCredentialsModel.PROP_REMOTE_PASSWORD, (Serializable)((Object)credentials.getRemotePassword()));
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(RemoteCredentialsModel.PROP_REMOTE_PASSWORD, passwordEncrypted);
        return properties;
    }
}

