/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.test.junitrules.AbstractRule;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.springframework.context.ApplicationContext;

public class AlfrescoTenant
extends AbstractRule {
    public static final String ADMIN_PASSWORD = "password";
    private final String tenantName;

    public AlfrescoTenant(ApplicationContext appContext) {
        this(appContext, GUID.generate());
    }

    public AlfrescoTenant(ApplicationContextInit appContextRule) {
        this(appContextRule, GUID.generate());
    }

    public AlfrescoTenant(ApplicationContext appContext, String tenantName) {
        super(appContext);
        this.tenantName = tenantName.toLowerCase();
    }

    public AlfrescoTenant(ApplicationContextInit appContextRule, String tenantName) {
        super(appContextRule);
        this.tenantName = tenantName.toLowerCase();
    }

    protected void before() throws Throwable {
        ApplicationContext appCtx = this.getApplicationContext();
        RetryingTransactionHelper transactionHelper = (RetryingTransactionHelper)appCtx.getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        final TenantAdminService tenantAdminService = (TenantAdminService)appCtx.getBean("tenantAdminService", TenantAdminService.class);
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                tenantAdminService.createTenant(AlfrescoTenant.this.tenantName, AlfrescoTenant.ADMIN_PASSWORD.toCharArray());
                return null;
            }
        });
    }

    protected void after() {
        ApplicationContext appCtx = this.getApplicationContext();
        RetryingTransactionHelper transactionHelper = (RetryingTransactionHelper)appCtx.getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        final TenantAdminService tenantAdminService = (TenantAdminService)appCtx.getBean("tenantAdminService", TenantAdminService.class);
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                tenantAdminService.deleteTenant(AlfrescoTenant.this.tenantName);
                return null;
            }
        });
    }

    public String getTenantDomain() {
        return this.tenantName;
    }

    public <T> T runAsSystem(TenantUtil.TenantRunAsWork<T> runAsWork) {
        return (T)TenantUtil.runAsSystemTenant(runAsWork, (String)this.tenantName);
    }
}

