/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.alfresco.util.schemacomp.DbObjectXMLTransformer;
import org.alfresco.util.schemacomp.model.Schema;
import org.xml.sax.SAXException;

public class SchemaToXML {
    private TransformerHandler xmlOut;
    private Schema schema;

    public SchemaToXML(Schema schema, StreamResult streamResult) {
        SAXTransformerFactory stf = (SAXTransformerFactory)TransformerFactory.newInstance();
        try {
            this.xmlOut = stf.newTransformerHandler();
        }
        catch (TransformerConfigurationException error) {
            throw new RuntimeException("Unable to create TransformerHandler.", error);
        }
        Transformer t = this.xmlOut.getTransformer();
        try {
            t.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        t.setOutputProperty("indent", "yes");
        t.setOutputProperty("encoding", "UTF-8");
        this.xmlOut.setResult(streamResult);
        this.schema = schema;
    }

    public void execute() {
        try {
            this.attemptTransformation();
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to complete transformation.", e);
        }
    }

    private void attemptTransformation() throws SAXException {
        this.xmlOut.startDocument();
        DbObjectXMLTransformer dboTransformer = new DbObjectXMLTransformer(this.xmlOut);
        dboTransformer.output(this.schema);
        this.xmlOut.endDocument();
    }
}

