/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.alfresco.repo.forms.processor.node.TransientValueGetter;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.QName;

public class ContentModelItemData<ItemType>
implements TransientValueGetter {
    private final ItemType item;
    private final Map<QName, PropertyDefinition> propDefs;
    private final Map<QName, AssociationDefinition> assocDefs;
    private final Map<QName, Serializable> propValues;
    private final Map<QName, Serializable> assocValues;
    private final Map<String, Object> transientValues;

    public ContentModelItemData(ItemType item, Map<QName, PropertyDefinition> propDefs, Map<QName, AssociationDefinition> assocDefs, Map<QName, Serializable> propValues, Map<QName, Serializable> assocValues, Map<String, Object> transientValues) {
        this.item = item;
        this.propDefs = propDefs;
        this.assocDefs = assocDefs;
        this.propValues = propValues;
        this.assocValues = assocValues;
        this.transientValues = transientValues;
    }

    public ItemType getItem() {
        return this.item;
    }

    public Serializable getPropertyValue(QName key) {
        return this.getValue(key, this.propValues);
    }

    public Serializable getAssociationValue(QName key) {
        return this.getValue(key, this.assocValues);
    }

    @Override
    public Object getTransientValue(String fieldName) {
        Object value = null;
        if (this.transientValues != null) {
            value = this.transientValues.get(fieldName);
        }
        return value;
    }

    private Serializable getValue(QName key, Map<QName, Serializable> values) {
        Serializable value = null;
        if (values != null) {
            value = values.get(key);
        }
        return value;
    }

    public PropertyDefinition getPropertyDefinition(QName propName) {
        PropertyDefinition propDef = null;
        if (this.propDefs != null) {
            propDef = this.propDefs.get(propName);
        }
        return propDef;
    }

    public AssociationDefinition getAssociationDefinition(QName assocName) {
        AssociationDefinition assocDef = null;
        if (this.assocDefs != null) {
            assocDef = this.assocDefs.get(assocName);
        }
        return assocDef;
    }

    public Collection<QName> getAllAssociationDefinitionNames() {
        if (this.assocDefs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.assocDefs.keySet());
    }

    public Collection<QName> getAllPropertyDefinitionNames() {
        if (this.propDefs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.propDefs.keySet());
    }

    public Collection<String> getAllTransientFieldNames() {
        if (this.transientValues == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.transientValues.keySet());
    }
}

