/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti.script;

import java.util.Map;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.Expression;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivitiScriptBase {
    protected static final String PERSON_BINDING_NAME = "person";
    protected static final String USERHOME_BINDING_NAME = "userhome";
    protected static final String EXECUTION_BINDING_NAME = "execution";
    protected Expression script;
    protected Expression runAs;
    protected Expression scriptProcessor;
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivitiScriptBase.class);

    protected Object executeScript(String theScript, Map<String, Object> model, String scriptProcessorName, String runAsUser) {
        String user = AuthenticationUtil.getFullyAuthenticatedUser();
        Object scriptResult = null;
        if (runAsUser == null && user != null) {
            scriptResult = this.executeScript(theScript, model, scriptProcessorName);
        } else {
            if (runAsUser != null) {
                this.validateRunAsUser(runAsUser);
            } else {
                runAsUser = AuthenticationUtil.getSystemUserName();
            }
            this.executeScriptAsUser(theScript, model, scriptProcessorName, runAsUser);
        }
        return scriptResult;
    }

    protected Object executeScriptAsUser(final String theScript, final Map<String, Object> model, final String scriptProcessorName, String runAsUser) {
        return AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                return ActivitiScriptBase.this.executeScript(theScript, model, scriptProcessorName);
            }
        }, (String)runAsUser);
    }

    protected Object executeScript(String theScript, Map<String, Object> model, String scriptProcessorName) {
        Object scriptResult = null;
        boolean secure = this.isSecure(model);
        scriptResult = scriptProcessorName != null ? this.getServiceRegistry().getScriptService().executeScriptString(scriptProcessorName, theScript, model, secure) : this.getServiceRegistry().getScriptService().executeScriptString(theScript, model, secure);
        return scriptResult;
    }

    protected String getStringValue(Expression expression, VariableScope scope) {
        if (expression != null) {
            return (String)expression.getValue(scope);
        }
        return null;
    }

    protected ServiceRegistry getServiceRegistry() {
        ProcessEngineConfigurationImpl config = Context.getProcessEngineConfiguration();
        if (config != null) {
            ServiceRegistry registry = (ServiceRegistry)config.getBeans().get("services");
            if (registry == null) {
                throw new RuntimeException("Service-registry not present in ProcessEngineConfiguration beans, expected ServiceRegistry with keyservices");
            }
            return registry;
        }
        throw new IllegalStateException("No ProcessEngineCOnfiguration found in active context");
    }

    private boolean isSecure(Map<String, Object> model) {
        String category = this.getDeploymentCategory(model);
        return category != null && ("http://alfresco.org/workflows/internal".equals(category) || "http://alfresco.org/workflows/fullAccess".equals(category));
    }

    private String getDeploymentCategory(Map<String, Object> model) {
        String category = this.getDeploymentCategoryFromContext();
        if (category == null) {
            String deploymentId = null;
            String processDefinitionId = null;
            if (model != null && model.containsKey(EXECUTION_BINDING_NAME) && model.get(EXECUTION_BINDING_NAME) instanceof ExecutionEntity) {
                ExecutionEntity executionEntity = (ExecutionEntity)model.get(EXECUTION_BINDING_NAME);
                deploymentId = executionEntity.getDeploymentId();
                processDefinitionId = executionEntity.getProcessDefinitionId();
            }
            category = this.getDeploymentCategoryFromQuery(deploymentId, processDefinitionId);
        }
        return category;
    }

    private String getDeploymentCategoryFromContext() {
        String category;
        block5: {
            category = null;
            try {
                if (Context.isExecutionContextActive()) {
                    category = Context.getExecutionContext().getDeployment().getCategory();
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("No execution context available");
                }
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug("Could not obtain deployment category from execution context: {}", (Object)e.getMessage());
            }
        }
        return category;
    }

    private String getDeploymentCategoryFromQuery(String deploymentId, String processDefinitionId) {
        String category;
        block4: {
            category = null;
            try {
                DeploymentEntity deployment;
                ProcessDefinition processDefnition;
                RepositoryService repositoryService = Context.getProcessEngineConfiguration().getRepositoryService();
                if (deploymentId == null && processDefinitionId != null && (processDefnition = repositoryService.getProcessDefinition(processDefinitionId)) != null) {
                    deploymentId = processDefnition.getDeploymentId();
                }
                if (deploymentId != null && (deployment = (DeploymentEntity)repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult()) != null) {
                    category = deployment.getCategory();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block4;
                LOGGER.debug("Could not obtain deployment category through a query: {}", (Object)e.getMessage());
            }
        }
        return category;
    }

    private void validateRunAsUser(final String runAsUser) {
        Boolean runAsExists = (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                return ActivitiScriptBase.this.getServiceRegistry().getPersonService().personExists(runAsUser);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (!runAsExists.booleanValue()) {
            throw new WorkflowException("runas user '" + runAsUser + "' does not exist.");
        }
    }

    protected ActivitiScriptNode getPersonNode(String runAsUser) {
        ServiceRegistry services;
        PersonService personService;
        String userName = null;
        userName = runAsUser != null ? runAsUser : AuthenticationUtil.getFullyAuthenticatedUser();
        if (userName != null && !"System".equals(userName) && (personService = (services = this.getServiceRegistry()).getPersonService()).personExists(userName)) {
            NodeRef person = personService.getPerson(userName);
            return new ActivitiScriptNode(person, services);
        }
        return null;
    }

    public void setScript(Expression script) {
        this.script = script;
    }

    public void setRunAs(Expression runAs) {
        this.runAs = runAs;
    }

    public void setScriptProcessor(Expression scriptProcessor) {
        this.scriptProcessor = scriptProcessor;
    }
}

