/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.RepositoryState;
import org.alfresco.repo.search.QueryParserException;
import org.alfresco.repo.search.impl.solr.SolrJsonProcessor;
import org.alfresco.repo.search.impl.solr.SolrSQLHttpClient;
import org.alfresco.repo.search.impl.solr.SolrStoreMappingWrapper;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.util.Pair;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

public class SolrSQLHttpClientTest {
    private static final String LANGUAGE = "LANGUAGE";
    private static final StoreRef STORE_REF = new StoreRef("STORE://REF/");
    @Spy
    @InjectMocks
    private SolrSQLHttpClient solrSQLHttpClient;
    @Mock
    private ResultSet mockResultSet;
    @Mock
    private RepositoryState mockRepositoryState;
    @Mock
    private SearchParameters mockSearchParameters;
    @Mock
    private SolrStoreMappingWrapper mockSolrStoreMappingWrapper;
    @Mock
    private HttpClient mockHttpClient;
    @Mock
    private HostConfiguration mockHostConfiguration;
    @Mock
    private PermissionService mockPermissionService;
    @Mock
    private TenantService mockTenantService;
    @Captor
    private ArgumentCaptor<JSONObject> bodyCaptor;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        ((SolrSQLHttpClient)Mockito.doReturn((Object)this.mockResultSet).when((Object)this.solrSQLHttpClient)).postSolrQuery((HttpClient)ArgumentMatchers.any(HttpClient.class), ArgumentMatchers.anyString(), (JSONObject)this.bodyCaptor.capture(), (SolrJsonProcessor)ArgumentMatchers.any(SolrJsonProcessor.class));
        Mockito.when((Object)this.mockSearchParameters.getStores()).thenReturn(new ArrayList(InvokerHelper.asList((Object)STORE_REF)));
        HashMap<StoreRef, SolrStoreMappingWrapper> mappingLookup = new HashMap<StoreRef, SolrStoreMappingWrapper>();
        mappingLookup.put(STORE_REF, this.mockSolrStoreMappingWrapper);
        this.solrSQLHttpClient.setMappingLookup(mappingLookup);
        Mockito.when((Object)this.mockHttpClient.getHostConfiguration()).thenReturn((Object)this.mockHostConfiguration);
        Mockito.when((Object)this.mockHostConfiguration.getHostURL()).thenReturn((Object)"hostURL");
        Pair httpClientAndBaseUrl = new Pair((Object)this.mockHttpClient, (Object)"baseURL");
        Mockito.when((Object)this.mockSolrStoreMappingWrapper.getHttpClientAndBaseUrl()).thenReturn((Object)httpClientAndBaseUrl);
        Mockito.when((Object)this.mockPermissionService.getAuthorisations()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.mockTenantService.getCurrentUserDomain()).thenReturn((Object)"currentUserDomain");
        Mockito.when((Object)this.mockSearchParameters.getQuery()).thenReturn((Object)"statement");
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void testExecuteQuery_bootstrapping() {
        Mockito.when((Object)this.mockRepositoryState.isBootstrapping()).thenReturn((Object)true);
        this.solrSQLHttpClient.executeQuery(this.mockSearchParameters, LANGUAGE);
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void testExecuteQuery_queryMissing() {
        Mockito.when((Object)this.mockSearchParameters.getQuery()).thenReturn(null);
        this.solrSQLHttpClient.executeQuery(this.mockSearchParameters, LANGUAGE);
    }

    @Test
    public void testExecuteQuery_minimalQuery() {
        ResultSet resultSet = this.solrSQLHttpClient.executeQuery(this.mockSearchParameters, LANGUAGE);
        Assert.assertEquals((String)"Expected result to come back from HTTP call.", (Object)this.mockResultSet, (Object)resultSet);
    }

    @Test
    public void testExecuteQuery_connectException() throws Exception {
        ((SolrSQLHttpClient)Mockito.doThrow((Throwable[])new Throwable[]{new ConnectException()}).when((Object)this.solrSQLHttpClient)).postSolrQuery((HttpClient)ArgumentMatchers.any(HttpClient.class), ArgumentMatchers.anyString(), (JSONObject)ArgumentMatchers.any(JSONObject.class), (SolrJsonProcessor)ArgumentMatchers.any(SolrJsonProcessor.class));
        try {
            this.solrSQLHttpClient.executeQuery(this.mockSearchParameters, LANGUAGE);
            Assert.fail((String)"Expected exception to be thrown due to failed connection.");
        }
        catch (QueryParserException e) {
            Assert.assertTrue((String)"Expected message to mention InsightEngine.", (boolean)e.getMessage().contains("InsightEngine"));
        }
    }

    @Test
    public void testExecuteQuery_filterQueries() throws JSONException {
        Mockito.when((Object)this.mockSearchParameters.getFilterQueries()).thenReturn(Arrays.asList("FQ1", "FQ2"));
        ResultSet resultSet = this.solrSQLHttpClient.executeQuery(this.mockSearchParameters, LANGUAGE);
        Assert.assertEquals((String)"Expected result to come back from HTTP call.", (Object)this.mockResultSet, (Object)resultSet);
        List<String> actual = this.stringJsonArrayToList(((JSONObject)this.bodyCaptor.getValue()).getJSONArray("filterQueries"));
        Assert.assertEquals((String)"Unexpected filter queries in HTTP request.", actual, Arrays.asList("FQ1", "FQ2"));
    }

    private List<String> stringJsonArrayToList(JSONArray jsonArray) throws JSONException {
        ArrayList<String> stringList = new ArrayList<String>();
        int i = 0;
        while (i < jsonArray.length()) {
            stringList.add(jsonArray.getString(i));
            ++i;
        }
        return stringList;
    }
}

