/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import junit.framework.TestCase;
import org.alfresco.repo.virtual.ref.HashStore;
import org.alfresco.repo.virtual.ref.StoredPathHasher;
import org.alfresco.util.Pair;
import org.apache.commons.codec.binary.Base64;
import org.junit.Test;

public class StoredPathHasherTest
extends TestCase {
    private HashStore hashStore;

    public void setUp() {
        this.hashStore = new HashStore();
        this.hashStore.put("/com/alfresco", "1");
    }

    @Test
    public void testHash() throws Exception {
        this.hashStore.put("/org/alfresco", "2");
        StoredPathHasher hasher = new StoredPathHasher(this.hashStore);
        StoredPathHasherTest.assertEquals((Object)new Pair((Object)"1", null), (Object)hasher.hash("/com/alfresco/"));
        StoredPathHasherTest.assertEquals((Object)new Pair((Object)"1", null), (Object)hasher.hash("/com/alfresco"));
        StoredPathHasherTest.assertEquals((Object)new Pair(null, (Object)Base64.encodeBase64String((byte[])"/com".getBytes())), (Object)hasher.hash("/com"));
        StoredPathHasherTest.assertEquals((Object)new Pair(null, (Object)Base64.encodeBase64String((byte[])"/com".getBytes())), (Object)hasher.hash("/com/"));
        StoredPathHasherTest.assertEquals((Object)new Pair((Object)"1", (Object)Base64.encodeBase64String((byte[])"foo/bar".getBytes())), (Object)hasher.hash("/com/alfresco/foo/bar"));
        StoredPathHasherTest.assertEquals((Object)new Pair((Object)"2", (Object)Base64.encodeBase64String((byte[])"foo/bar".getBytes())), (Object)hasher.hash("/org/alfresco/foo/bar"));
    }

    @Test
    public void testHashRoot() throws Exception {
        StoredPathHasher hasher = new StoredPathHasher(this.hashStore);
        StoredPathHasherTest.assertEquals((Object)new Pair(null, (Object)""), (Object)hasher.hash("/"));
    }

    @Test
    public void testNullPaths() throws Exception {
        StoredPathHasher hasher = new StoredPathHasher(this.hashStore);
        try {
            hasher.hash("");
            StoredPathHasherTest.fail((String)"Shold not be able to hash empty paths.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        hasher = new StoredPathHasher(this.hashStore);
        try {
            hasher.hash(null);
            StoredPathHasherTest.fail((String)"Shold not be able to hash null paths.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

