/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.replication;

import junit.framework.TestCase;
import org.alfresco.repo.replication.ReplicationDefinitionPersisterImpl;
import org.alfresco.repo.replication.ReplicationServiceImpl;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.replication.ReplicationDefinition;
import org.mockito.Mockito;

public class ReplicationServiceImplTest
extends TestCase {
    private ActionService actionService = (ActionService)Mockito.mock(ActionService.class);
    private final ReplicationDefinitionPersisterImpl replicationDefinitionPersister = (ReplicationDefinitionPersisterImpl)Mockito.mock(ReplicationDefinitionPersisterImpl.class);
    private ReplicationServiceImpl replicationService;
    private final String ACTION_NAME = "testName";
    private final String ACTION_NAME2 = "testName2";

    protected void setUp() throws Exception {
        this.replicationService = new ReplicationServiceImpl();
        this.replicationService.setActionService(this.actionService);
        this.replicationService.setReplicationDefinitionPersister(this.replicationDefinitionPersister);
    }

    public void testCreation() throws Exception {
        ReplicationDefinition replicationAction = this.replicationService.createReplicationDefinition("testName", "Test Definition");
        ReplicationServiceImplTest.assertNotNull((Object)replicationAction);
        ReplicationServiceImplTest.assertEquals((String)"Test Definition", (String)replicationAction.getDescription());
        ReplicationServiceImplTest.assertEquals((String)"testName", (String)replicationAction.getReplicationName());
        String id = replicationAction.getId();
        ReplicationServiceImplTest.assertNotNull((Object)id);
        ReplicationServiceImplTest.assertTrue((id.length() > 0 ? 1 : 0) != 0);
        ReplicationServiceImplTest.assertNotNull((Object)replicationAction.getPayload());
        ReplicationServiceImplTest.assertEquals((int)0, (int)replicationAction.getPayload().size());
        ReplicationServiceImplTest.assertNull((Object)replicationAction.getLocalTransferReport());
        ReplicationServiceImplTest.assertNull((Object)replicationAction.getRemoteTransferReport());
    }
}

