/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.domain.schema.SchemaBootstrap;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.DBTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@Category(value={OwnJVMTestsCategory.class, DBTests.class})
public class SchemaReferenceFileTest {
    private ClassPathXmlApplicationContext ctx;
    private SchemaBootstrap schemaBootstrap;

    @Before
    public void setUp() throws Exception {
        this.ctx = (ClassPathXmlApplicationContext)ApplicationContextHelper.getApplicationContext();
        this.schemaBootstrap = (SchemaBootstrap)this.ctx.getBean("schemaBootstrap");
    }

    @Test
    public void checkReferenceFile() {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(buff);
        int maybeProblems = this.schemaBootstrap.validateSchema(null, out);
        out.flush();
        if (maybeProblems > 0) {
            List<String> errors = this.computeRealErrors(buff);
            Assert.assertTrue((String)("\n" + buff), (boolean)errors.isEmpty());
        }
    }

    private List<String> computeRealErrors(ByteArrayOutputStream buff) {
        String[] lines = buff.toString().split("\\n");
        ArrayList<String> errors = new ArrayList<String>();
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (line.isEmpty()) break;
            errors.add(line);
            ++i;
        }
        return errors;
    }
}

