/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.admin.patch.AppliedPatch;
import org.alfresco.repo.admin.patch.Patch;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.extensions.surf.util.I18NUtil;

public abstract class AsynchronousPatch
extends AbstractPatch {
    private static final Log logger = LogFactory.getLog(AsynchronousPatch.class);
    private static final String JOB_NAME = "asynchronousPatch";
    private static final String MSG_CHECKING = "patch.asynchrounse.checking";
    private static final String MSG_NO_PATCHES_REQUIRED = "patch.executer.no_patches_required";
    private static final String MSG_SYSTEM_READ_ONLY = "patch.executer.system_readonly";
    private static final String MSG_NOT_EXECUTED = "patch.executer.not_executed";
    private static final String MSG_EXECUTED = "patch.executer.executed";
    private static final String MSG_FAILED = "patch.executer.failed";
    private static final long LOCK_TIME_TO_LIVE = 10000L;
    private static final long LOCK_REFRESH_TIME = 5000L;
    private JobLockService jobLockService;

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    @Override
    protected void checkProperties() {
        super.checkProperties();
        this.checkPropertyNotNull(this.jobLockService, "jobLockService");
    }

    public void executeAsynchronously() {
        QName lockQName = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)this.getId());
        String lockToken = this.jobLockService.getLock(lockQName, 10000L, 0L, 1);
        AsyncPatchCallback callback = new AsyncPatchCallback();
        this.jobLockService.refreshLock(lockToken, lockQName, 5000L, callback);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(String.valueOf(this.getId()) + ": job lock held"));
            }
            this.applyOutstandingPatch(this);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(String.valueOf(this.getId()) + ": job finished"));
            }
            callback.isActive = false;
            this.jobLockService.releaseLock(lockToken, lockQName);
        }
    }

    private void applyOutstandingPatch(Patch patch) {
        if (!this.patchService.validatePatch(patch)) {
            logger.warn((Object)I18NUtil.getMessage((String)MSG_SYSTEM_READ_ONLY));
            return;
        }
        logger.info((Object)I18NUtil.getMessage((String)MSG_CHECKING));
        AppliedPatch appliedPatch = this.patchService.getPatch(this.getId());
        if (appliedPatch != null && appliedPatch.getSucceeded()) {
            logger.info((Object)I18NUtil.getMessage((String)MSG_NO_PATCHES_REQUIRED));
            return;
        }
        this.patchService.applyOutstandingPatch(this);
        appliedPatch = this.patchService.getPatch(patch.getId());
        if (!appliedPatch.getWasExecuted()) {
            logger.info((Object)I18NUtil.getMessage((String)MSG_NOT_EXECUTED, (Object[])new Object[]{appliedPatch.getId(), appliedPatch.getReport()}));
        } else if (appliedPatch.getSucceeded()) {
            logger.info((Object)I18NUtil.getMessage((String)MSG_EXECUTED, (Object[])new Object[]{appliedPatch.getId(), appliedPatch.getReport()}));
        } else {
            logger.error((Object)I18NUtil.getMessage((String)MSG_FAILED, (Object[])new Object[]{appliedPatch.getId(), appliedPatch.getReport()}));
            throw new AlfrescoRuntimeException("Not all patches could be applied.");
        }
    }

    private class AsyncPatchCallback
    implements JobLockService.JobLockRefreshCallback {
        public boolean isActive = true;

        private AsyncPatchCallback() {
        }

        @Override
        public boolean isActive() {
            return this.isActive;
        }

        @Override
        public void lockReleased() {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"lock released");
            }
        }
    }

    public static class AsynchronousPatchJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            JobDataMap jobData = context.getJobDetail().getJobDataMap();
            Object asyncPatchObj = jobData.get((Object)AsynchronousPatch.JOB_NAME);
            if (asyncPatchObj == null || !(asyncPatchObj instanceof AsynchronousPatch)) {
                throw new AlfrescoRuntimeException("asynchronousPatch data must contain valid 'AsynchronousPatch' reference");
            }
            AsynchronousPatch patch = (AsynchronousPatch)asyncPatchObj;
            patch.executeAsynchronously();
        }
    }
}

