/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.contentdata.ibatis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.ibatis.IdsEntity;
import org.alfresco.repo.domain.contentdata.AbstractContentDataDAOImpl;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.domain.contentdata.ContentDataEntity;
import org.alfresco.repo.domain.contentdata.ContentUrlEntity;
import org.alfresco.repo.domain.contentdata.ContentUrlKeyEntity;
import org.alfresco.repo.domain.contentdata.ContentUrlOrphanQuery;
import org.alfresco.repo.domain.contentdata.ContentUrlUpdateEntity;
import org.alfresco.repo.domain.contentdata.SymmetricKeyCount;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataIntegrityViolationException;

public class ContentDataDAOImpl
extends AbstractContentDataDAOImpl {
    private static final String SELECT_CONTENT_URL_BY_ID = "alfresco.content.select_ContentUrlById";
    private static final String SELECT_CONTENT_URL_BY_KEY = "alfresco.content.select_ContentUrlByKey";
    private static final String SELECT_CONTENT_URL_BY_KEY_UNREFERENCED = "alfresco.content.select_ContentUrlByKeyUnreferenced";
    private static final String SELECT_CONTENT_URLS_ORPHANED = "alfresco.content.select.select_ContentUrlsOrphaned";
    private static final String SELECT_CONTENT_URLS_KEEP_ORPHANED = "alfresco.content.select_ContentUrlsKeepOrphaned";
    private static final String SELECT_CONTENT_DATA_BY_ID = "alfresco.content.select_ContentDataById";
    private static final String SELECT_CONTENT_DATA_BY_NODE_AND_QNAME = "alfresco.content.select_ContentDataByNodeAndQName";
    private static final String SELECT_CONTENT_DATA_BY_NODE_IDS = "alfresco.content.select_ContentDataByNodeIds";
    private static final String INSERT_CONTENT_URL = "alfresco.content.insert.insert_ContentUrl";
    private static final String INSERT_CONTENT_DATA = "alfresco.content.insert.insert_ContentData";
    private static final String UPDATE_CONTENT_URL_ORPHAN_TIME = "alfresco.content.update_ContentUrlOrphanTime";
    private static final String UPDATE_CONTENT_DATA = "alfresco.content.update_ContentData";
    private static final String DELETE_CONTENT_DATA = "alfresco.content.delete_ContentData";
    private static final String DELETE_CONTENT_URLS = "alfresco.content.delete_ContentUrls";
    private static final String DELETE_CONTENT_URL_KEYS = "alfresco.content.delete_ContentUrlKeys";
    private static final String DELETE_SYMMETRIC_KEY = "alfresco.content.delete_KeyData";
    private static final String UPDATE_SYMMETRIC_KEY = "alfresco.content.update_KeyData";
    private static final String INSERT_SYMMETRIC_KEY = "alfresco.content.insert.insert_KeyData";
    private static final String SELECT_SYMMETRIC_KEYS_BY_MASTER_KEY = "alfresco.content.select_SymmetricKeysByMasterKey";
    private static final String COUNT_SYMMETRIC_KEYS_BY_MASTER_KEY = "alfresco.content.select_CountSymmetricKeysByMasterKey";
    private static final String COUNT_SYMMETRIC_KEYS_FOR_MASTER_KEYS = "alfresco.content.select_CountSymmetricKeysForAllMasterKeys";
    protected SqlSessionTemplate template;

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    @Override
    public Pair<Long, String> createContentUrlOrphaned(String contentUrl, Date orphanTime) {
        ContentUrlEntity contentUrlEntity = new ContentUrlEntity();
        contentUrlEntity.setContentUrl(contentUrl);
        contentUrlEntity.setSize(0L);
        contentUrlEntity.setOrphanTime(orphanTime == null ? System.currentTimeMillis() : orphanTime.getTime());
        this.template.insert(INSERT_CONTENT_URL, (Object)contentUrlEntity);
        Long id = contentUrlEntity.getId();
        return new Pair((Object)id, (Object)contentUrl);
    }

    @Override
    protected ContentUrlEntity createContentUrlEntity(String contentUrl, long size, ContentUrlKeyEntity contentUrlKeyEntity) {
        ContentUrlEntity contentUrlEntity = new ContentUrlEntity();
        contentUrlEntity.setContentUrl(contentUrl);
        contentUrlEntity.setSize(size);
        contentUrlEntity.setOrphanTime(null);
        this.template.insert(INSERT_CONTENT_URL, (Object)contentUrlEntity);
        if (contentUrlKeyEntity != null) {
            this.template.insert(INSERT_SYMMETRIC_KEY, (Object)contentUrlKeyEntity);
        }
        return contentUrlEntity;
    }

    @Override
    protected ContentUrlEntity getContentUrlEntity(Long id) {
        ContentUrlEntity contentUrlEntity = new ContentUrlEntity();
        contentUrlEntity.setId(id);
        contentUrlEntity = (ContentUrlEntity)this.template.selectOne(SELECT_CONTENT_URL_BY_ID, (Object)contentUrlEntity);
        return contentUrlEntity;
    }

    @Override
    public ContentUrlEntity getContentUrlEntity(String contentUrl) {
        ContentUrlEntity contentUrlEntity = new ContentUrlEntity();
        contentUrlEntity.setContentUrl(contentUrl);
        if (contentUrlEntity.getContentUrlShort() != null) {
            contentUrlEntity.setContentUrlShort(contentUrlEntity.getContentUrlShort().toLowerCase());
        }
        contentUrlEntity = (ContentUrlEntity)this.template.selectOne(SELECT_CONTENT_URL_BY_KEY, (Object)contentUrlEntity);
        return contentUrlEntity;
    }

    @Override
    public void getContentUrlsOrphaned(ContentDataDAO.ContentUrlHandler contentUrlHandler, Long maxOrphanTimeExclusive, int maxResults) {
        ParameterCheck.mandatory((String)"maxOrphanTimeExclusive", (Object)maxOrphanTimeExclusive);
        ContentUrlOrphanQuery query = new ContentUrlOrphanQuery();
        query.setMaxOrphanTimeExclusive(maxOrphanTimeExclusive);
        query.setMaxRecords(Long.valueOf(maxResults));
        List results = this.template.selectList(SELECT_CONTENT_URLS_ORPHANED, (Object)query, new RowBounds(0, maxResults));
        for (ContentUrlEntity result : results) {
            contentUrlHandler.handle(result.getId(), result.getContentUrl(), result.getOrphanTime());
        }
    }

    @Override
    public void getContentUrlsKeepOrphaned(ContentDataDAO.ContentUrlHandler contentUrlHandler, int maxResults) {
        List results = this.template.selectList(SELECT_CONTENT_URLS_KEEP_ORPHANED, (Object)new RowBounds(0, maxResults));
        for (ContentUrlEntity result : results) {
            contentUrlHandler.handle(result.getId(), result.getContentUrl(), result.getOrphanTime());
        }
    }

    @Override
    public int updateContentUrlOrphanTime(Long id, Long orphanTime, Long oldOrphanTime) {
        ContentUrlUpdateEntity contentUrlUpdateEntity = new ContentUrlUpdateEntity();
        contentUrlUpdateEntity.setId(id);
        contentUrlUpdateEntity.setOrphanTime(orphanTime);
        contentUrlUpdateEntity.setOldOrphanTime(oldOrphanTime);
        return this.template.update(UPDATE_CONTENT_URL_ORPHAN_TIME, (Object)contentUrlUpdateEntity);
    }

    @Override
    public int deleteContentUrls(List<Long> ids) {
        this.template.delete(DELETE_CONTENT_URL_KEYS, ids);
        return this.template.delete(DELETE_CONTENT_URLS, ids);
    }

    @Override
    protected ContentUrlEntity getContentUrlEntityUnreferenced(String contentUrl) {
        ContentUrlEntity contentUrlEntity = new ContentUrlEntity();
        contentUrlEntity.setContentUrl(contentUrl);
        if (contentUrlEntity.getContentUrlShort() != null) {
            contentUrlEntity.setContentUrlShort(contentUrlEntity.getContentUrlShort().toLowerCase());
        }
        contentUrlEntity = (ContentUrlEntity)this.template.selectOne(SELECT_CONTENT_URL_BY_KEY_UNREFERENCED, (Object)contentUrlEntity);
        return contentUrlEntity;
    }

    @Override
    protected ContentDataEntity createContentDataEntity(Long contentUrlId, Long mimetypeId, Long encodingId, Long localeId) {
        ContentDataEntity contentDataEntity = new ContentDataEntity();
        contentDataEntity.setVersion(ContentDataEntity.CONST_LONG_ZERO);
        contentDataEntity.setContentUrlId(contentUrlId);
        contentDataEntity.setMimetypeId(mimetypeId);
        contentDataEntity.setEncodingId(encodingId);
        contentDataEntity.setLocaleId(localeId);
        try {
            this.template.insert(INSERT_CONTENT_DATA, (Object)contentDataEntity);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to insert ContentData: " + contentDataEntity, e);
        }
        return contentDataEntity;
    }

    @Override
    protected ContentDataEntity getContentDataEntity(Long id) {
        HashMap<String, Long> params = new HashMap<String, Long>(11);
        params.put("id", id);
        ContentDataEntity contentDataEntity = (ContentDataEntity)this.template.selectOne(SELECT_CONTENT_DATA_BY_ID, params);
        return contentDataEntity;
    }

    @Override
    protected List<ContentDataEntity> getContentDataEntitiesForNodes(Set<Long> nodeIds) {
        if (nodeIds.size() == 0) {
            return Collections.emptyList();
        }
        IdsEntity idsEntity = new IdsEntity();
        idsEntity.setIds(new ArrayList<Long>(nodeIds));
        return this.template.selectList(SELECT_CONTENT_DATA_BY_NODE_IDS, (Object)idsEntity);
    }

    @Override
    protected int updateContentDataEntity(ContentDataEntity entity) {
        entity.incrementVersion();
        return this.template.update(UPDATE_CONTENT_DATA, (Object)entity);
    }

    @Override
    protected int deleteContentDataEntity(Long id) {
        try {
            ContentData contentData = (ContentData)this.getContentData(id).getSecond();
            String contentUrl = contentData.getContentUrl();
            if (contentUrl != null) {
                this.registerDereferencedContentUrl(contentUrl);
            }
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {}
        HashMap<String, Long> params = new HashMap<String, Long>(11);
        params.put("id", id);
        return this.template.delete(DELETE_CONTENT_DATA, params);
    }

    @Override
    public void deleteContentDataForNode(Long nodeId, Set<Long> qnameIds) {
        if (qnameIds.size() == 0) {
            return;
        }
        IdsEntity idsEntity = new IdsEntity();
        idsEntity.setIdOne(nodeId);
        idsEntity.setIds(new ArrayList<Long>(qnameIds));
        List ids = this.template.selectList(SELECT_CONTENT_DATA_BY_NODE_AND_QNAME, (Object)idsEntity);
        for (Long id : ids) {
            try {
                this.deleteContentData(id);
            }
            catch (ConcurrencyFailureException concurrencyFailureException) {}
        }
    }

    @Override
    protected int updateContentUrlEntity(ContentUrlEntity existing, ContentUrlEntity entity) {
        int ret = 0;
        ContentUrlKeyEntity existingContentUrlKey = existing.getContentUrlKey();
        ContentUrlKeyEntity contentUrlKey = entity.getContentUrlKey();
        contentUrlKey.setContentUrlId(existing.getId());
        if (existingContentUrlKey == null) {
            ret = this.template.insert(INSERT_SYMMETRIC_KEY, (Object)contentUrlKey);
        } else if (!EqualsHelper.nullSafeEquals((Object)existingContentUrlKey, (Object)contentUrlKey)) {
            ret = this.template.update(UPDATE_SYMMETRIC_KEY, (Object)contentUrlKey);
        }
        return ret;
    }

    @Override
    protected int deleteContentUrlEntity(long id) {
        HashMap<String, Long> params = new HashMap<String, Long>(11);
        params.put("id", id);
        return this.template.delete(DELETE_SYMMETRIC_KEY, params);
    }

    @Override
    public List<ContentUrlKeyEntity> getSymmetricKeysByMasterKeyAlias(String masterKeyAlias, long fromId, int maxResults) {
        ContentUrlKeyEntity entity = new ContentUrlKeyEntity();
        entity.setMasterKeyAlias(masterKeyAlias);
        entity.setId(fromId);
        List results = this.template.selectList(SELECT_SYMMETRIC_KEYS_BY_MASTER_KEY, (Object)entity, new RowBounds(0, maxResults));
        return results;
    }

    @Override
    public Map<String, Integer> countSymmetricKeysForMasterKeys() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        List res = this.template.selectList(COUNT_SYMMETRIC_KEYS_FOR_MASTER_KEYS);
        for (SymmetricKeyCount count : res) {
            counts.put(count.getMasterKeyAlias(), count.getCount());
        }
        return counts;
    }

    @Override
    public int countSymmetricKeysForMasterKeyAlias(String masterKeyAlias) {
        return (Integer)this.template.selectOne(COUNT_SYMMETRIC_KEYS_BY_MASTER_KEY, (Object)masterKeyAlias);
    }
}

