/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tagging;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.tagging.TaggingServiceImpl;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.tagging.TagDetails;
import org.alfresco.service.namespace.QName;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TagScopePropertyMethodInterceptor
implements MethodInterceptor {
    private static ThreadLocal<Boolean> enabled = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };
    private ContentService contentService;
    private NodeService nodeService;
    private SimpleCache<String, List<String>> cache;

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCache(SimpleCache<String, List<String>> cache) {
        this.cache = cache;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        List<String> ret;
        if (Boolean.FALSE.equals(TagScopePropertyMethodInterceptor.getEnabled())) {
            return invocation.proceed();
        }
        String methodName = invocation.getMethod().getName();
        if ("getProperty".equals(methodName)) {
            Object[] args = invocation.getArguments();
            NodeRef nodeRef = (NodeRef)args[0];
            QName propertyQName = (QName)args[1];
            ret = ContentModel.PROP_TAGSCOPE_SUMMARY.equals((Object)propertyQName) ? this.getTagSummary(nodeRef, null) : invocation.proceed();
        } else if ("getProperties".equals(methodName)) {
            ret = invocation.proceed();
            if (Map.class.isAssignableFrom(ret.getClass())) {
                Map retMap = (Map)((Object)ret);
                NodeRef nodeRef = (NodeRef)invocation.getArguments()[0];
                List<String> tagSummary = this.getTagSummary(nodeRef, retMap);
                if (tagSummary != null) {
                    retMap.put(ContentModel.PROP_TAGSCOPE_SUMMARY, (Serializable)((Object)tagSummary));
                }
            }
        } else if ("setProperty".equals(methodName)) {
            Object[] args = invocation.getArguments();
            QName propertyQName = (QName)args[1];
            ret = !ContentModel.PROP_TAGSCOPE_SUMMARY.equals((Object)propertyQName) ? invocation.proceed() : null;
        } else if ("setProperties".equals(methodName)) {
            Object[] args = invocation.getArguments();
            Map properties = (Map)args[1];
            if (properties != null) {
                properties.remove(ContentModel.PROP_TAGSCOPE_SUMMARY);
            }
            ret = invocation.proceed();
        } else {
            ret = invocation.proceed();
        }
        return ret;
    }

    protected List<String> getTagSummary(NodeRef nodeRef, Map<QName, Serializable> allNodeProperties) {
        ContentReader contentReader;
        String contentUrl;
        List<String> tagSummary = null;
        ContentData tagScopeCache = null;
        tagScopeCache = allNodeProperties != null ? (ContentData)allNodeProperties.get(ContentModel.PROP_TAGSCOPE_CACHE) : (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_TAGSCOPE_CACHE);
        if (tagScopeCache != null && (contentUrl = tagScopeCache.getContentUrl()) != null && (tagSummary = (ArrayList)this.cache.get((Serializable)((Object)contentUrl))) == null && (contentReader = this.contentService.getRawReader(contentUrl)) != null && contentReader.exists()) {
            List<TagDetails> tagDetails = TaggingServiceImpl.readTagDetails(contentReader.getContentInputStream());
            tagSummary = new ArrayList(tagDetails.size());
            for (TagDetails tagDetail : tagDetails) {
                tagSummary.add(String.valueOf(tagDetail.getName()) + "=" + tagDetail.getCount());
            }
            tagSummary = Collections.unmodifiableList(tagSummary);
            this.cache.put((Serializable)((Object)contentUrl), tagSummary);
        }
        return tagSummary;
    }

    public static final Boolean getEnabled() {
        return enabled.get();
    }

    public static final Boolean setEnabled(Boolean enable) {
        Boolean oldSetting = enabled.get();
        enabled.set(enable);
        return oldSetting;
    }
}

