/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.repo.virtual.config.NodeRefExpression;
import org.alfresco.service.cmr.dictionary.ConstraintException;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.extensions.surf.util.I18NUtil;

public class SystemTemplateLocationsConstraint
extends ListOfValuesConstraint {
    public static final String NULL_SYSTEM_TEMPLATE = "nullSystemTemplate";
    public static final String NULL_SYSTEM_TEMPLATE_MESSAGE = "smf_smartFolder.nullSystemTemplate.message";
    private NodeService nodeService;
    private String templatesParentClasspath;
    private NodeRefExpression templatesParentRepositoryPath;
    private NamespacePrefixResolver namespacePrefixResolver;
    private String repositoryTemplateTypeName;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTemplatesParentClasspath(String templatesParentClasspath) {
        this.templatesParentClasspath = templatesParentClasspath;
    }

    public String getTemplatesParentClasspath() {
        return this.templatesParentClasspath;
    }

    public NodeRefExpression getTemplatesParentRepositoryPath() {
        return this.templatesParentRepositoryPath;
    }

    public void setTemplatesParentRepositoryPath(NodeRefExpression templatesParentRepositoryPath) {
        this.templatesParentRepositoryPath = templatesParentRepositoryPath;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setRepositoryTemplateTypeName(String repositoryTemplateTypeName) {
        this.repositoryTemplateTypeName = repositoryTemplateTypeName;
    }

    public List<String> getRawAllowedValues() {
        List<String> result = null;
        try {
            result = this.loadClasspathTemplates(this.templatesParentClasspath, "json");
        }
        catch (IOException e) {
            throw new ConstraintException("ListTemplateTypesConstraints", new Object[]{e});
        }
        List<String> repositoryTemplates = this.loadRepositoryTemplates(this.templatesParentRepositoryPath);
        result.addAll(repositoryTemplates);
        if (result.size() == 0) {
            result.add(NULL_SYSTEM_TEMPLATE);
        }
        super.setAllowedValues(result);
        return result;
    }

    public List<String> getAllowedValues() {
        if (this.sorted) {
            List<String> rawValues = this.getRawAllowedValues();
            ArrayList<String> values = new ArrayList<String>(rawValues);
            Collections.sort(values, new LabelComparator());
            return values;
        }
        return super.getAllowedValues();
    }

    public String getDisplayLabel(String constraintAllowableValue, MessageLookup messageLookup) {
        if (constraintAllowableValue.startsWith("N")) {
            Serializable nameProperty = this.nodeService.getProperty(new NodeRef(constraintAllowableValue.substring(1)), ContentModel.PROP_NAME);
            return nameProperty.toString();
        }
        if (constraintAllowableValue.equals(NULL_SYSTEM_TEMPLATE)) {
            String message = messageLookup.getMessage(NULL_SYSTEM_TEMPLATE_MESSAGE, I18NUtil.getLocale());
            return message == null ? constraintAllowableValue : message;
        }
        return constraintAllowableValue.substring(constraintAllowableValue.lastIndexOf("/") + 1);
    }

    protected void evaluateSingleValue(Object value) {
        super.setAllowedValues(this.getAllowedValues());
        super.evaluateSingleValue(value);
    }

    private List<String> loadClasspathTemplates(String templatesParentClasspath, String ... extensions) throws IOException {
        Resource[] resources;
        ArrayList<String> result = new ArrayList<String>(5);
        ArrayList<String> files = new ArrayList<String>(5);
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(cl);
        Resource[] resourceArray = resources = resolver.getResources("classpath*:" + templatesParentClasspath + "/*");
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            files.add(resource.getFilename());
            ++n2;
        }
        if (extensions != null && extensions.length > 0) {
            String extensionStr = "";
            int i = 0;
            while (i < extensions.length) {
                extensionStr = i == extensions.length - 1 ? String.valueOf(extensionStr) + extensions[i] : String.valueOf(extensionStr) + extensions[i] + "|";
                ++i;
            }
            String fileExtensions = "(?i).*\\.(" + extensionStr + ")$";
            Pattern pattern = Pattern.compile(fileExtensions);
            for (String file : files) {
                if (!pattern.matcher(file).matches()) continue;
                result.add("C" + templatesParentClasspath + "/" + file);
            }
        }
        return result;
    }

    private List<String> loadRepositoryTemplates(NodeRefExpression templatesParentRepositoryPath) {
        ArrayList<String> result = new ArrayList<String>();
        NodeRef findNodeRef = templatesParentRepositoryPath.resolve();
        if (findNodeRef != null) {
            QName repositoryTemplateTypeQName = QName.createQName((String)this.repositoryTemplateTypeName, (NamespacePrefixResolver)this.namespacePrefixResolver);
            HashSet<QName> searchTypeQNames = new HashSet<QName>();
            searchTypeQNames.add(repositoryTemplateTypeQName);
            List children = this.nodeService.getChildAssocs(findNodeRef, searchTypeQNames);
            for (ChildAssociationRef childAssociationRef : children) {
                NodeRef childNodeRef = childAssociationRef.getChildRef();
                QName childType = this.nodeService.getType(childNodeRef);
                if (!searchTypeQNames.contains(childType)) continue;
                result.add("N" + childNodeRef.toString());
            }
        }
        return result;
    }

    private class LabelComparator
    implements Comparator<String> {
        private LabelComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return SystemTemplateLocationsConstraint.this.getDisplayLabel(o1, null).compareTo(SystemTemplateLocationsConstraint.this.getDisplayLabel(o2, null));
        }
    }
}

