/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.alfresco.util.schemacomp.Difference;
import org.alfresco.util.schemacomp.Result;
import org.alfresco.util.schemacomp.Results;
import org.alfresco.util.schemacomp.ValidationResult;
import org.alfresco.util.schemacomp.model.Column;
import org.alfresco.util.schemacomp.model.ForeignKey;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.model.PrimaryKey;
import org.alfresco.util.schemacomp.model.Sequence;
import org.alfresco.util.schemacomp.model.Table;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.Assert;

public class SchemaCompTestingUtils {
    public static void dumpValidation(Results results) {
        System.out.println("Validation Results (" + results.size() + ")");
        for (Result r : results) {
            if (!(r instanceof ValidationResult)) continue;
            System.out.println(r);
        }
    }

    public static void dumpDiffs(Results differences, boolean showNonDifferences) {
        System.out.println("Differences (" + differences.size() + ")");
        for (Result d : differences) {
            Difference diff;
            if (!(d instanceof Difference) || (diff = (Difference)d).getWhere() == Difference.Where.IN_BOTH_NO_DIFFERENCE && !showNonDifferences) continue;
            System.out.println(d);
        }
    }

    public static Table table(String name) {
        return new Table(null, name, SchemaCompTestingUtils.columns("id NUMBER(10)"), SchemaCompTestingUtils.pk("pk_" + name, "id"), SchemaCompTestingUtils.fkeys(new ForeignKey[0]), SchemaCompTestingUtils.indexes(new String[0]));
    }

    public static Table table(String name, Collection<Column> columns, PrimaryKey primaryKey, Collection<ForeignKey> foreignKeys, Collection<Index> indexes) {
        return new Table(null, name, columns, primaryKey, foreignKeys, indexes);
    }

    public static Collection<Column> columns(boolean compareColOrder, String ... colDefs) {
        Assert.assertTrue((String)"Tables must have columns", (colDefs.length > 0 ? 1 : 0) != 0);
        Column[] columns = new Column[colDefs.length];
        int i = 0;
        while (i < colDefs.length) {
            String[] parts = colDefs[i].split(" ");
            columns[i] = new Column(null, parts[0], parts[1], false);
            columns[i].setOrder(i + 1);
            columns[i].setCompareOrder(compareColOrder);
            ++i;
        }
        return Arrays.asList(columns);
    }

    public static Collection<Column> columns(String ... colDefs) {
        return SchemaCompTestingUtils.columns(true, colDefs);
    }

    public static PrimaryKey pk(String name, String ... columnNames) {
        Assert.assertTrue((String)"No columns specified", (columnNames.length > 0 ? 1 : 0) != 0);
        ArrayList<Integer> columnOrders = new ArrayList<Integer>(columnNames.length);
        int i = 1;
        while (i <= columnNames.length) {
            columnOrders.add(i);
            ++i;
        }
        PrimaryKey pk = new PrimaryKey(null, name, Arrays.asList(columnNames), columnOrders);
        return pk;
    }

    public static List<ForeignKey> fkeys(ForeignKey ... fkeys) {
        return Arrays.asList(fkeys);
    }

    public static ForeignKey fk(String fkName, String localColumn, String targetTable, String targetColumn) {
        return new ForeignKey(null, fkName, localColumn, targetTable, targetColumn);
    }

    public static Collection<Index> indexes(String ... indexDefs) {
        Index[] indexes = new Index[indexDefs.length];
        int i = 0;
        while (i < indexDefs.length) {
            Object[] parts = indexDefs[i].split(" ");
            String name = parts[0];
            boolean unique = false;
            int columnsStart = 1;
            if (parts[1].equals("[unique]")) {
                unique = true;
                ++columnsStart;
            }
            String[] columns = (String[])ArrayUtils.subarray((Object[])parts, (int)columnsStart, (int)parts.length);
            indexes[i] = new Index(null, name, Arrays.asList(columns));
            indexes[i].setUnique(unique);
            ++i;
        }
        return Arrays.asList(indexes);
    }

    public static Sequence sequence(String name) {
        return new Sequence(name);
    }
}

