/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.events;

import java.util.Map;
import java.util.Objects;
import org.alfresco.repo.events.MessageProducer;
import org.alfresco.repo.events.MessagingException;
import org.apache.camel.ProducerTemplate;

class CamelMessageProducer
implements MessageProducer {
    private static final Map<String, Object> AMQP_HEADERS = Map.of("JMS_AMQP_MESSAGE_FORMAT", 0L);
    private final ProducerTemplate producer;
    private final String endpoint;

    CamelMessageProducer(ProducerTemplate producer, String endpoint) {
        this.producer = Objects.requireNonNull(producer);
        this.endpoint = Objects.requireNonNull(endpoint);
    }

    @Override
    public void send(Object message) {
        try {
            this.producer.sendBodyAndHeaders(this.endpoint, message, AMQP_HEADERS);
        }
        catch (Exception e) {
            throw new MessagingException("Could not send message", e);
        }
    }
}

