/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.util.Comparator;
import java.util.List;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.repo.site.AbstractSiteMembership;
import org.alfresco.repo.site.SiteMembershipComparator;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.util.Pair;

@AlfrescoPublicApi
public class SiteMembership
extends AbstractSiteMembership {
    private String firstName;
    private String lastName;
    private boolean isMemberOfGroup;

    public SiteMembership(SiteInfo siteInfo, String id, String firstName, String lastName, String role) {
        super(siteInfo, id, role);
        if (firstName == null) {
            throw new IllegalArgumentException("FirstName required building site membership of " + siteInfo.getShortName());
        }
        if (lastName == null) {
            throw new IllegalArgumentException("LastName required building site membership of " + siteInfo.getShortName());
        }
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public SiteMembership(SiteInfo siteInfo, String id, String firstName, String lastName, String role, boolean isMemberOfGroup) {
        super(siteInfo, id, role);
        if (firstName == null) {
            throw new IllegalArgumentException("FirstName required building site membership of " + siteInfo.getShortName());
        }
        if (lastName == null) {
            throw new IllegalArgumentException("LastName required building site membership of " + siteInfo.getShortName());
        }
        this.firstName = firstName;
        this.lastName = lastName;
        this.isMemberOfGroup = isMemberOfGroup;
    }

    public SiteMembership(SiteInfo siteInfo, String id, String role) {
        super(siteInfo, id, role);
    }

    public String getPersonId() {
        return this.id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public boolean isMemberOfGroup() {
        return this.isMemberOfGroup;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + (this.getSiteInfo() == null ? 0 : this.getSiteInfo().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SiteMembership other = (SiteMembership)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.role != other.role) {
            return false;
        }
        if (this.isMemberOfGroup != other.isMemberOfGroup) {
            return false;
        }
        return !(this.getSiteInfo() == null ? other.getSiteInfo() != null : !this.getSiteInfo().equals(other.getSiteInfo()));
    }

    public String toString() {
        return "SiteMembership [siteInfo=" + this.getSiteInfo() + ", id=" + this.id + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", role=" + this.role + ", isMemberOfGroup = " + this.isMemberOfGroup + "]";
    }

    static int compareTo(List<Pair<? extends Object, CannedQuerySortDetails.SortOrder>> sortPairs, SiteMembership o1, SiteMembership o2) {
        String personId1 = o1.getPersonId();
        String personId2 = o2.getPersonId();
        String firstName1 = o1.getFirstName();
        String firstName2 = o2.getFirstName();
        String lastName1 = o1.getLastName();
        String lastName2 = o2.getLastName();
        String siteRole1 = o1.getRole();
        String siteRole2 = o2.getRole();
        String shortName1 = o1.getSiteInfo().getShortName();
        String shortName2 = o2.getSiteInfo().getShortName();
        int personId = SiteMembershipComparator.safeCompare(personId1, personId2);
        int firstName = SiteMembershipComparator.safeCompare(firstName1, firstName2);
        int siteShortName = SiteMembershipComparator.safeCompare(shortName1, shortName2);
        int lastName = SiteMembershipComparator.safeCompare(lastName1, lastName2);
        int siteRole = SiteMembershipComparator.safeCompare(siteRole1, siteRole2);
        if (siteRole == 0 && siteShortName == 0 && personId == 0) {
            return 0;
        }
        return SiteMembershipComparator.compareSiteMembersBody(sortPairs, personId1, personId2, lastName1, lastName2, siteRole1, siteRole2, personId, firstName, lastName, siteRole, 0);
    }

    static Comparator<SiteMembership> getComparator(List<Pair<?, CannedQuerySortDetails.SortOrder>> sortPairs) {
        return (o1, o2) -> SiteMembership.compareTo(sortPairs, o1, o2);
    }
}

