/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.access;

import java.util.HashMap;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.access.ActionAccessException;
import org.alfresco.repo.action.access.ActionAccessRestriction;
import org.alfresco.repo.action.access.AdminActionAccessRestriction;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.util.BaseSpringTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AdminActionAccessRestrictionTest
extends BaseSpringTest {
    private static final String MAIL_ACTION = "mail";
    private static final String CONTROLLED_CONTEXT = "v1";
    private ActionAccessRestriction adminActionAccessRestriction;

    @Before
    public void setup() {
        this.adminActionAccessRestriction = (ActionAccessRestriction)this.applicationContext.getBean("adminActionAccessRestriction", AdminActionAccessRestriction.class);
    }

    @Test
    public void adminCanExecute() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        Action action = this.createMailAction();
        this.adminActionAccessRestriction.verifyAccessRestriction(action);
    }

    @Test
    public void systemCanExecute() {
        AuthenticationUtil.setRunAsUserSystem();
        Action action = this.createMailAction();
        this.adminActionAccessRestriction.verifyAccessRestriction(action);
    }

    @Test
    public void userCantExecute() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getGuestUserName());
        Action action = this.createMailAction();
        Assert.assertThrows(ActionAccessException.class, () -> this.adminActionAccessRestriction.verifyAccessRestriction(action));
    }

    private Action createMailAction() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("from", "admin@alfresco.com");
        params.put("to", "test@wp.pl");
        params.put("subject", "test");
        params.put("text", "test");
        ActionImpl action = new ActionImpl(null, "123", MAIL_ACTION, params);
        ActionAccessRestriction.setActionContext((Action)action, (String)CONTROLLED_CONTEXT);
        return action;
    }
}

