/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RunAsFullyAuthenticatedRule
implements TestRule {
    private static final Log log = LogFactory.getLog(RunAsFullyAuthenticatedRule.class);
    private final String fixedUserName;
    private final AlfrescoPerson personRule;

    public RunAsFullyAuthenticatedRule() {
        this.fixedUserName = null;
        this.personRule = null;
    }

    public RunAsFullyAuthenticatedRule(String userName) {
        ParameterCheck.mandatory((String)"userName", (Object)userName);
        this.fixedUserName = userName;
        this.personRule = null;
    }

    public RunAsFullyAuthenticatedRule(AlfrescoPerson personRule) {
        ParameterCheck.mandatory((String)"personRule", (Object)((Object)personRule));
        this.fixedUserName = null;
        this.personRule = personRule;
    }

    public String getUsername() {
        return this.fixedUserName;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                AuthenticationUtil.pushAuthentication();
                String runAsUser = RunAsFullyAuthenticatedRule.this.getMethodAnnotatedUserName(description);
                if (runAsUser != null) {
                    log.debug((Object)("Running as method annotation-provided user: " + runAsUser));
                    log.debug((Object)("   See " + description.getClassName() + "." + description.getMethodName()));
                } else if (RunAsFullyAuthenticatedRule.this.fixedUserName != null) {
                    runAsUser = RunAsFullyAuthenticatedRule.this.fixedUserName;
                    log.debug((Object)("Running as username defined in this rule: " + runAsUser));
                } else if (RunAsFullyAuthenticatedRule.this.personRule != null) {
                    runAsUser = RunAsFullyAuthenticatedRule.this.personRule.getUsername();
                    log.debug((Object)("Running as username provided by another rule: " + runAsUser));
                } else {
                    throw new Exception("Illegal rule: must provide username or " + AlfrescoPerson.class.getSimpleName() + " at rule construction or else a " + RunAsUser.class.getSimpleName() + " annotation.");
                }
                AuthenticationUtil.setFullyAuthenticatedUser((String)runAsUser);
                try {
                    base.evaluate();
                }
                finally {
                    AuthenticationUtil.popAuthentication();
                }
            }
        };
    }

    private String getMethodAnnotatedUserName(Description description) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String result = null;
        Collection annotations = description.getAnnotations();
        for (Annotation anno : annotations) {
            if (!anno.annotationType().equals(RunAsUser.class)) continue;
            result = (String)anno.annotationType().getMethod("userName", new Class[0]).invoke((Object)anno, new Object[0]);
        }
        return result;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface RunAsUser {
        public String userName() default "";
    }
}

