/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

@Deprecated
public class MultiUserRenditionTest {
    private ApplicationContext appContext;
    private static String ADMIN_USER;
    private static final String NON_ADMIN_USER = "nonAdmin";
    private MutableAuthenticationService authenticationService;
    private ContentService contentService;
    private NodeService nodeService;
    private PermissionService permissionService;
    private PersonService personService;
    private RenditionService renditionService;
    private Repository repositoryHelper;
    private RetryingTransactionHelper txnHelper;
    private TransactionService transactionService;
    private OwnableService ownableService;
    private List<NodeRef> nodesToBeTidiedUp = new ArrayList<NodeRef>();
    private NodeRef testFolder;

    @Before
    public void createTestFolder() {
        this.initContextAndCreateUser();
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        NodeRef companyHome = this.repositoryHelper.getCompanyHome();
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, this.getClass() + "_testFolder");
        this.testFolder = this.nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_FOLDER, props).getChildRef();
        this.permissionService.setPermission(this.testFolder, "GROUP_EVERYONE", "All", true);
        this.nodesToBeTidiedUp.add(this.testFolder);
    }

    public void initContextAndCreateUser() {
        this.appContext = ApplicationContextHelper.getApplicationContext();
        this.authenticationService = (MutableAuthenticationService)this.appContext.getBean("AuthenticationService");
        this.contentService = (ContentService)this.appContext.getBean("ContentService");
        this.nodeService = (NodeService)this.appContext.getBean("NodeService");
        this.permissionService = (PermissionService)this.appContext.getBean("PermissionService");
        this.personService = (PersonService)this.appContext.getBean("PersonService");
        this.renditionService = (RenditionService)this.appContext.getBean("RenditionService");
        this.repositoryHelper = (Repository)this.appContext.getBean("repositoryHelper");
        this.transactionService = (TransactionService)this.appContext.getBean("TransactionService");
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.ownableService = (OwnableService)this.appContext.getBean("ownableService");
        ADMIN_USER = AuthenticationUtil.getAdminUserName();
        this.createUser(NON_ADMIN_USER);
    }

    public void createUser(String userName) {
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, userName.toCharArray());
        }
        if (!this.personService.personExists(userName)) {
            PropertyMap ppOne = new PropertyMap();
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    @Test
    public void renditioningShouldNotChangeModifierOnSourceNode_ALF3991() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        final NodeRef adminPdfNode = (NodeRef)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                return MultiUserRenditionTest.this.createPdfDocumentAsCurrentlyAuthenticatedUser(String.valueOf(ADMIN_USER) + "_content");
            }
        });
        this.nodesToBeTidiedUp.add(adminPdfNode);
        AuthenticationUtil.setFullyAuthenticatedUser((String)NON_ADMIN_USER);
        final NodeRef nonAdminPdfNode = (NodeRef)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                return MultiUserRenditionTest.this.createPdfDocumentAsCurrentlyAuthenticatedUser("nonAdmin_content");
            }
        });
        this.nodesToBeTidiedUp.add(nonAdminPdfNode);
        final QName doclibRendDefQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"doclib");
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                MultiUserRenditionTest.this.renditionService.render(nonAdminPdfNode, doclibRendDefQName);
                return null;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)NON_ADMIN_USER);
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                MultiUserRenditionTest.this.renditionService.render(adminPdfNode, doclibRendDefQName);
                return null;
            }
        });
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Assert.assertEquals((String)"Incorrect modifier property", (Object)ADMIN_USER, (Object)MultiUserRenditionTest.this.nodeService.getProperty(adminPdfNode, ContentModel.PROP_MODIFIER));
                Assert.assertEquals((String)"Incorrect modifier property", (Object)MultiUserRenditionTest.NON_ADMIN_USER, (Object)MultiUserRenditionTest.this.nodeService.getProperty(nonAdminPdfNode, ContentModel.PROP_MODIFIER));
                return null;
            }
        });
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Assert.assertEquals((String)"Incorrect rendition owner", (Object)MultiUserRenditionTest.this.ownableService.getOwner(adminPdfNode), (Object)MultiUserRenditionTest.this.ownableService.getOwner(((ChildAssociationRef)MultiUserRenditionTest.this.renditionService.getRenditions(adminPdfNode).get(0)).getChildRef()));
                Assert.assertEquals((String)"Incorrect rendition owner", (Object)MultiUserRenditionTest.this.ownableService.getOwner(nonAdminPdfNode), (Object)MultiUserRenditionTest.this.ownableService.getOwner(((ChildAssociationRef)MultiUserRenditionTest.this.renditionService.getRenditions(nonAdminPdfNode).get(0)).getChildRef()));
                return null;
            }
        });
    }

    @Test
    public void testRenditionOwnerHasChangedAfterSourceOwnerChange() {
        final QName doclibRendDefQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"doclib");
        AuthenticationUtil.setFullyAuthenticatedUser((String)NON_ADMIN_USER);
        final NodeRef nonAdminPdfNode = (NodeRef)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef nonAdminPdfNode = MultiUserRenditionTest.this.createPdfDocumentAsCurrentlyAuthenticatedUser("nonAdmin_content");
                return nonAdminPdfNode;
            }
        });
        final Pair nonAdminNodes = (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Pair<NodeRef, NodeRef>>(){

            public Pair<NodeRef, NodeRef> execute() throws Throwable {
                MultiUserRenditionTest.this.renditionService.render(nonAdminPdfNode, doclibRendDefQName);
                NodeRef nonAdminRenditionNode = ((ChildAssociationRef)MultiUserRenditionTest.this.renditionService.getRenditions(nonAdminPdfNode).get(0)).getChildRef();
                MultiUserRenditionTest.this.ownableService.getOwner(nonAdminRenditionNode);
                return new Pair((Object)nonAdminPdfNode, (Object)nonAdminRenditionNode);
            }
        });
        this.nodesToBeTidiedUp.add((NodeRef)nonAdminNodes.getFirst());
        this.nodesToBeTidiedUp.add((NodeRef)nonAdminNodes.getSecond());
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                MultiUserRenditionTest.this.ownableService.setOwner((NodeRef)nonAdminNodes.getFirst(), ADMIN_USER);
                return null;
            }
        });
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Assert.assertEquals((String)"Incorrect rendition owner", (Object)ADMIN_USER, (Object)MultiUserRenditionTest.this.ownableService.getOwner((NodeRef)nonAdminNodes.getFirst()));
                Assert.assertEquals((String)"Incorrect rendition owner", (Object)ADMIN_USER, (Object)MultiUserRenditionTest.this.ownableService.getOwner((NodeRef)nonAdminNodes.getSecond()));
                return null;
            }
        });
    }

    @After
    public void tidyUpUnwantedNodeRefs() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                for (NodeRef node : MultiUserRenditionTest.this.nodesToBeTidiedUp) {
                    if (!MultiUserRenditionTest.this.nodeService.exists(node)) continue;
                    MultiUserRenditionTest.this.nodeService.deleteNode(node);
                }
                return null;
            }
        });
        this.nodesToBeTidiedUp.clear();
    }

    private NodeRef createPdfDocumentAsCurrentlyAuthenticatedUser(String nodeName) {
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, nodeName);
        NodeRef result = this.nodeService.createNode(this.testFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)nodeName), ContentModel.TYPE_CONTENT, props).getChildRef();
        File file = this.loadQuickPdfFile();
        ContentWriter writer = this.contentService.getWriter(result, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("application/pdf");
        writer.setEncoding("UTF-8");
        writer.putContent(file);
        return result;
    }

    private File loadQuickPdfFile() {
        File file;
        URL url = AbstractContentTransformerTest.class.getClassLoader().getResource("quick/quick.pdf");
        if (url == null) {
            Assert.fail((String)"Could not load pdf file");
        }
        if (!(file = new File(url.getFile())).exists()) {
            Assert.fail((String)"Could not load pdf file");
        }
        return file;
    }
}

