/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.activities.feed.cleanup.FeedCleaner;
import org.alfresco.repo.domain.activities.ActivityFeedDAO;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.repo.domain.activities.FeedControlDAO;
import org.alfresco.repo.domain.activities.FeedControlEntity;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.activities.ActivityPostService;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.activities.FeedControl;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.sync.repo.Client;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.surf.util.ParameterCheck;

public class ActivityServiceImpl
implements ActivityService,
InitializingBean {
    private static final Log logger = LogFactory.getLog(ActivityServiceImpl.class);
    private ActivityFeedDAO feedDAO;
    private FeedControlDAO feedControlDAO;
    private FeedCleaner feedCleaner;
    private AuthorityService authorityService;
    private TenantService tenantService;
    private SiteService siteService;
    private ActivityPostService activityPostService;
    private PersonService personService;
    private NodeService nodeService;
    private int maxFeedItems = 100;
    private boolean userNamesAreCaseSensitive = false;

    public void setMaxFeedItems(int maxFeedItems) {
        this.maxFeedItems = maxFeedItems;
    }

    public void setUserNamesAreCaseSensitive(boolean userNamesAreCaseSensitive) {
        this.userNamesAreCaseSensitive = userNamesAreCaseSensitive;
    }

    public void setFeedDAO(ActivityFeedDAO feedDAO) {
        this.feedDAO = feedDAO;
    }

    public void setFeedControlDAO(FeedControlDAO feedControlDAO) {
        this.feedControlDAO = feedControlDAO;
    }

    public void setFeedCleaner(FeedCleaner feedCleaner) {
        this.feedCleaner = feedCleaner;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setActivityPostService(ActivityPostService activityPostService) {
        this.activityPostService = activityPostService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void afterPropertiesSet() throws Exception {
        int feedCleanerMaxFeedItems = this.feedCleaner.getMaxFeedSize();
        if (this.maxFeedItems > feedCleanerMaxFeedItems) {
            logger.warn((Object)("Cannot retrieve more items than feed cleaner max items (overriding " + this.maxFeedItems + " to " + feedCleanerMaxFeedItems + ")"));
            this.maxFeedItems = feedCleanerMaxFeedItems;
        }
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, String activityData) {
        this.activityPostService.postActivity(activityType, siteId, appTool, activityData);
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, String activityData, String userId) {
        this.activityPostService.postActivity(activityType, siteId, appTool, activityData, userId);
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, NodeRef nodeRef) {
        this.activityPostService.postActivity(activityType, siteId, appTool, nodeRef);
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, NodeRef nodeRef, String name) {
        this.activityPostService.postActivity(activityType, siteId, appTool, nodeRef, name);
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, NodeRef nodeRef, String name, QName typeQName, NodeRef parentNodeRef) {
        this.activityPostService.postActivity(activityType, siteId, appTool, nodeRef, name, typeQName, parentNodeRef);
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, String jsonActivityData, Client client) {
        this.activityPostService.postActivity(activityType, siteId, appTool, jsonActivityData, client);
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, String jsonActivityData, Client client, FileInfo contentNodeInfo) {
        this.activityPostService.postActivity(activityType, siteId, appTool, jsonActivityData, client, contentNodeInfo);
    }

    @Override
    public List<String> getUserFeedEntries(String feedUserId, String siteId) {
        return this.getUserFeedEntries(feedUserId, siteId, false, false, null, null);
    }

    @Override
    public List<String> getUserFeedEntries(String feedUserId, String siteId, boolean excludeThisUser, boolean excludeOtherUsers) {
        return this.getUserFeedEntries(feedUserId, siteId, excludeThisUser, excludeOtherUsers, null, null);
    }

    @Override
    public List<String> getUserFeedEntries(String feedUserId, String siteId, boolean excludeThisUser, boolean excludeOtherUsers, Set<String> userFilter, Set<String> actvityFilter) {
        ArrayList<String> activityFeedEntries = new ArrayList<String>();
        try {
            List<ActivityFeedEntity> activityFeeds = this.getUserFeedEntries(feedUserId, siteId, excludeThisUser, excludeOtherUsers, userFilter, actvityFilter, -1L);
            if (activityFeeds != null) {
                for (ActivityFeedEntity activityFeed : activityFeeds) {
                    activityFeedEntries.add(activityFeed.getJSONString());
                }
            }
        }
        catch (JSONException je) {
            AlfrescoRuntimeException are = new AlfrescoRuntimeException("Unable to get user feed entries: " + je.getMessage());
            logger.error((Object)are);
            throw are;
        }
        return activityFeedEntries;
    }

    @Override
    public PagingResults<ActivityFeedEntity> getPagedUserFeedEntries(String feedUserId, String siteId, boolean excludeThisUser, boolean excludeOtherUsers, long minFeedId, PagingRequest pagingRequest) {
        try {
            String currentUser;
            ParameterCheck.mandatoryString((String)"feedUserId", (String)feedUserId);
            if (!this.userNamesAreCaseSensitive) {
                feedUserId = feedUserId.toLowerCase();
            }
            if (!((currentUser = this.getCurrentUser()) == null || this.authorityService.isAdminAuthority(currentUser) || currentUser.equals(feedUserId) || AuthenticationUtil.getSystemUserName().equals(this.tenantService.getBaseNameUser(currentUser)))) {
                throw new AccessDeniedException("Unable to get user feed entries for '" + feedUserId + "' - currently logged in as '" + currentUser + "'");
            }
            if (siteId != null) {
                siteId = this.tenantService.getName(siteId);
            }
            String networkId = this.tenantService.getCurrentUserDomain();
            PagingResults<ActivityFeedEntity> activityFeedEntries = this.feedDAO.selectPagedUserFeedEntries(feedUserId, networkId, siteId, excludeThisUser, excludeOtherUsers, minFeedId, pagingRequest);
            return activityFeedEntries;
        }
        catch (SQLException se) {
            AlfrescoRuntimeException are = new AlfrescoRuntimeException("Unable to get user feed entries: " + se.getMessage());
            logger.error((Object)are);
            throw are;
        }
    }

    protected NodeRef getUserAvatarNodeRef(ActivityFeedEntity activityFeed, Map<String, NodeRef> userIdToAvatarNodeRefCache) {
        NodeRef avatarNodeRef = null;
        String postUserId = null;
        if (activityFeed.getActivityType().equals("org.alfresco.site.user-role-changed")) {
            try {
                JSONObject j = new JSONObject(activityFeed.getActivitySummary());
                postUserId = j.get("memberUserName").toString();
            }
            catch (JSONException jSONException) {}
        } else {
            postUserId = activityFeed.getPostUserId();
        }
        if (postUserId != null) {
            if (userIdToAvatarNodeRefCache.containsKey(postUserId)) {
                avatarNodeRef = userIdToAvatarNodeRefCache.get(postUserId);
            } else {
                block10: {
                    try {
                        NodeRef postPerson = this.personService.getPerson(postUserId);
                        List assocRefs = this.nodeService.getTargetAssocs(postPerson, (QNamePattern)ContentModel.ASSOC_AVATAR);
                        if (!assocRefs.isEmpty()) {
                            avatarNodeRef = ((AssociationRef)assocRefs.get(0)).getTargetRef();
                        }
                    }
                    catch (NoSuchPersonException noSuchPersonException) {
                        if (!logger.isDebugEnabled()) break block10;
                        logger.warn((Object)("getUserFeedEntries: person no longer exists: " + postUserId));
                    }
                }
                userIdToAvatarNodeRefCache.put(postUserId, avatarNodeRef);
            }
        }
        return avatarNodeRef;
    }

    @Override
    public List<ActivityFeedEntity> getUserFeedEntries(String feedUserId, String siteId, boolean excludeThisUser, boolean excludeOtherUsers, long minFeedId) {
        return this.getUserFeedEntries(feedUserId, siteId, excludeThisUser, excludeOtherUsers, null, null, minFeedId);
    }

    @Override
    public List<ActivityFeedEntity> getUserFeedEntries(String feedUserId, String siteId, boolean excludeThisUser, boolean excludeOtherUsers, Set<String> userFilter, Set<String> actvityFilter, long minFeedId) {
        String currentUser;
        ParameterCheck.mandatoryString((String)"feedUserId", (String)feedUserId);
        if (!this.userNamesAreCaseSensitive) {
            feedUserId = feedUserId.toLowerCase();
        }
        if (!((currentUser = this.getCurrentUser()) == null || this.authorityService.isAdminAuthority(currentUser) || currentUser.equals(feedUserId) || AuthenticationUtil.getSystemUserName().equals(this.tenantService.getBaseNameUser(currentUser)))) {
            throw new AccessDeniedException("Unable to get user feed entries for '" + feedUserId + "' - currently logged in as '" + currentUser + "'");
        }
        ArrayList<ActivityFeedEntity> result = new ArrayList<ActivityFeedEntity>();
        if (actvityFilter != null && actvityFilter.isEmpty()) {
            return result;
        }
        if (userFilter != null && userFilter.isEmpty()) {
            return result;
        }
        try {
            if (siteId != null) {
                siteId = this.tenantService.getName(siteId);
            }
            List<ActivityFeedEntity> activityFeeds = this.feedDAO.selectUserFeedEntries(feedUserId, siteId, excludeThisUser, excludeOtherUsers, minFeedId, this.maxFeedItems);
            HashMap<String, NodeRef> userIdToAvatarNodeRefCache = new HashMap<String, NodeRef>();
            String currentTenantDomain = this.tenantService.getCurrentUserDomain();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Selected feed entries for user : '" + feedUserId + "',\n for site : '" + siteId + "',\n excluding this user : '" + excludeThisUser + "',\n excluding other users : '" + excludeOtherUsers + "',\n with min feed id : '" + minFeedId + "',\n with max feed items : '" + this.maxFeedItems));
            }
            for (ActivityFeedEntity activityFeed : activityFeeds) {
                if (actvityFilter != null && !actvityFilter.contains(activityFeed.getActivityType())) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace((Object)("Filtering " + activityFeed.toString() + " \n by the activity filter."));
                    continue;
                }
                if (userFilter != null && !userFilter.contains(activityFeed.getPostUserId())) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace((Object)("Filtering " + activityFeed.toString() + " \n by the user filter."));
                    continue;
                }
                String siteNetwork = activityFeed.getSiteNetwork();
                if (siteId == null && siteNetwork != null && !currentTenantDomain.equals(this.tenantService.getDomain(siteNetwork))) continue;
                NodeRef avatarNodeRef = null;
                String postUserId = activityFeed.getPostUserId();
                if (userIdToAvatarNodeRefCache.containsKey(postUserId)) {
                    avatarNodeRef = (NodeRef)userIdToAvatarNodeRefCache.get(postUserId);
                } else {
                    block16: {
                        try {
                            NodeRef postPerson = this.personService.getPerson(postUserId);
                            List assocRefs = this.nodeService.getTargetAssocs(postPerson, (QNamePattern)ContentModel.ASSOC_AVATAR);
                            if (!assocRefs.isEmpty()) {
                                avatarNodeRef = ((AssociationRef)assocRefs.get(0)).getTargetRef();
                            }
                        }
                        catch (NoSuchPersonException noSuchPersonException) {
                            if (!logger.isDebugEnabled()) break block16;
                            logger.warn((Object)("getUserFeedEntries: person no longer exists: " + postUserId));
                        }
                    }
                    userIdToAvatarNodeRefCache.put(postUserId, avatarNodeRef);
                }
                activityFeed.setPostUserAvatarNodeRef(avatarNodeRef);
                activityFeed.setSiteNetwork(this.tenantService.getBaseName(siteNetwork));
                result.add(activityFeed);
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Selected user feed entry: " + activityFeed.toString()));
            }
        }
        catch (SQLException se) {
            AlfrescoRuntimeException are = new AlfrescoRuntimeException("Unable to get user feed entries: " + se.getMessage());
            logger.error((Object)are);
            throw are;
        }
        return result;
    }

    @Override
    public List<String> getSiteFeedEntries(String siteId) {
        ParameterCheck.mandatoryString((String)"siteId", (String)siteId);
        ArrayList<String> activityFeedEntries = new ArrayList<String>();
        HashMap<String, NodeRef> userIdToAvatarNodeRefCache = new HashMap<String, NodeRef>();
        try {
            SiteInfo siteInfo;
            if (this.siteService != null && (siteInfo = this.siteService.getSite(siteId)) == null) {
                throw new AccessDeniedException("No such site: " + siteId);
            }
            siteId = this.tenantService.getName(siteId);
            List<ActivityFeedEntity> activityFeeds = this.feedDAO.selectSiteFeedEntries(siteId, this.maxFeedItems);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Selected feed entries for site : '" + siteId + "'"));
            }
            for (ActivityFeedEntity activityFeed : activityFeeds) {
                activityFeed.setSiteNetwork(this.tenantService.getBaseName(activityFeed.getSiteNetwork()));
                NodeRef avatarNodeRef = null;
                String postUserId = activityFeed.getPostUserId();
                if (userIdToAvatarNodeRefCache.containsKey(postUserId)) {
                    avatarNodeRef = (NodeRef)userIdToAvatarNodeRefCache.get(postUserId);
                } else {
                    block11: {
                        try {
                            NodeRef postPerson = this.personService.getPerson(postUserId);
                            List assocRefs = this.nodeService.getTargetAssocs(postPerson, (QNamePattern)ContentModel.ASSOC_AVATAR);
                            if (!assocRefs.isEmpty()) {
                                avatarNodeRef = ((AssociationRef)assocRefs.get(0)).getTargetRef();
                            }
                        }
                        catch (NoSuchPersonException noSuchPersonException) {
                            if (!logger.isDebugEnabled()) break block11;
                            logger.warn((Object)("getUserFeedEntries: person no longer exists: " + postUserId));
                        }
                    }
                    userIdToAvatarNodeRefCache.put(postUserId, avatarNodeRef);
                }
                activityFeed.setPostUserAvatarNodeRef(avatarNodeRef);
                activityFeedEntries.add(activityFeed.getJSONString());
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Selected site feed entry: " + activityFeed.toString()));
            }
        }
        catch (SQLException se) {
            AlfrescoRuntimeException are = new AlfrescoRuntimeException("Unable to get site feed entries: " + se.getMessage());
            logger.error((Object)are);
            throw are;
        }
        catch (JSONException je) {
            AlfrescoRuntimeException are = new AlfrescoRuntimeException("Unable to get site feed entries: " + je.getMessage());
            logger.error((Object)are);
            throw are;
        }
        return activityFeedEntries;
    }

    @Override
    public int getMaxFeedItems() {
        return this.maxFeedItems;
    }

    @Override
    public void setFeedControl(FeedControl feedControl) {
        ParameterCheck.mandatory((String)"feedControl", (Object)feedControl);
        String userId = this.getCurrentUser();
        if (userId == null) {
            throw new AlfrescoRuntimeException("Current user " + userId + " is not permitted to set feed control");
        }
        try {
            if (!this.existsFeedControl(feedControl)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Inserting feed control for siteId: " + feedControl.getSiteId() + ",\n appToolId : " + feedControl.getAppToolId() + ",\n for user : " + userId));
                }
                if (!this.userNamesAreCaseSensitive) {
                    userId = userId.toLowerCase();
                }
                this.feedControlDAO.insertFeedControl(new FeedControlEntity(userId, feedControl));
            }
        }
        catch (SQLException e) {
            AlfrescoRuntimeException are = new AlfrescoRuntimeException("Failed to set feed control: " + e, (Throwable)e);
            logger.error((Object)are);
            throw are;
        }
    }

    @Override
    public List<FeedControl> getFeedControls() {
        String userId = this.getCurrentUser();
        return this.getFeedControlsImpl(userId);
    }

    @Override
    public List<FeedControl> getFeedControls(String userId) {
        String currentUser;
        ParameterCheck.mandatoryString((String)"userId", (String)userId);
        if (!this.userNamesAreCaseSensitive) {
            userId = userId.toLowerCase();
        }
        if ((currentUser = this.getCurrentUser()) == null || !this.authorityService.isAdminAuthority(currentUser) && !currentUser.equals(userId) && !AuthenticationUtil.getSystemUserName().equals(this.tenantService.getBaseNameUser(currentUser))) {
            throw new AlfrescoRuntimeException("Current user " + currentUser + " is not permitted to get feed controls for " + userId);
        }
        return this.getFeedControlsImpl(userId);
    }

    private List<FeedControl> getFeedControlsImpl(String userId) {
        ParameterCheck.mandatoryString((String)"userId", (String)userId);
        if (!this.userNamesAreCaseSensitive) {
            userId = userId.toLowerCase();
        }
        try {
            List<FeedControlEntity> feedControlDaos = this.feedControlDAO.selectFeedControls(userId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Selecting feed controls for userId: " + userId));
            }
            ArrayList<FeedControl> feedControls = new ArrayList<FeedControl>(feedControlDaos.size());
            for (FeedControlEntity feedControlDao : feedControlDaos) {
                FeedControl feedCtrl = feedControlDao.getFeedControl();
                feedControls.add(feedCtrl);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Found feed control for userId: " + userId + ",\n appToolId : " + feedCtrl.getAppToolId() + ",\n siteId: " + feedCtrl.getSiteId()));
            }
            return feedControls;
        }
        catch (SQLException e) {
            AlfrescoRuntimeException are = new AlfrescoRuntimeException("Failed to get feed controls: " + e, (Throwable)e);
            logger.error((Object)are);
            throw are;
        }
    }

    @Override
    public void unsetFeedControl(FeedControl feedControl) {
        ParameterCheck.mandatory((String)"feedControl", (Object)feedControl);
        String userId = this.getCurrentUser();
        if (userId == null) {
            throw new AlfrescoRuntimeException("Current user " + userId + " is not permitted to unset feed control");
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Deleting feed control for siteId: " + feedControl.getSiteId() + ",\n appToolId : " + feedControl.getAppToolId() + ",\n for user : " + userId));
            }
            if (!this.userNamesAreCaseSensitive) {
                userId = userId.toLowerCase();
            }
            this.feedControlDAO.deleteFeedControl(new FeedControlEntity(userId, feedControl));
        }
        catch (SQLException e) {
            AlfrescoRuntimeException are = new AlfrescoRuntimeException("Failed to unset feed control: " + e, (Throwable)e);
            logger.error((Object)are);
            throw are;
        }
    }

    @Override
    public boolean existsFeedControl(FeedControl feedControl) {
        ParameterCheck.mandatory((String)"feedControl", (Object)feedControl);
        String userId = this.getCurrentUser();
        try {
            long id;
            boolean exists;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Selecting feed control for siteId: " + feedControl.getSiteId() + ",\n appToolId : " + feedControl.getAppToolId() + ",\n for user : " + userId));
            }
            if (!this.userNamesAreCaseSensitive) {
                userId = userId.toLowerCase();
            }
            boolean bl = exists = (id = this.feedControlDAO.selectFeedControl(new FeedControlEntity(userId, feedControl))) != -1L;
            if (logger.isDebugEnabled()) {
                if (exists) {
                    logger.debug((Object)"The entry exists.");
                } else {
                    logger.debug((Object)"The entry doesn't exist.");
                }
            }
            return exists;
        }
        catch (SQLException e) {
            AlfrescoRuntimeException are = new AlfrescoRuntimeException("Failed to query feed control: " + e, (Throwable)e);
            logger.error((Object)are);
            throw are;
        }
    }

    private String getCurrentUser() {
        String userId = AuthenticationUtil.getFullyAuthenticatedUser();
        if (userId != null && !this.userNamesAreCaseSensitive && !AuthenticationUtil.getSystemUserName().equals(this.tenantService.getBaseNameUser(userId))) {
            userId = userId.toLowerCase();
        }
        return userId;
    }
}

