/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit.generator;

import java.io.Serializable;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.audit.generator.AbstractDataGenerator;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyCheck;

public class AuthenticatedPersonDataGenerator
extends AbstractDataGenerator {
    private PersonService personService;
    private NodeService nodeService;

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        PropertyCheck.mandatory((Object)this, (String)"personService", (Object)this.personService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
    }

    @Override
    public Serializable getData() throws Throwable {
        String user = AuthenticationUtil.getFullyAuthenticatedUser();
        NodeRef personNodeRef = this.personService.getPerson(user);
        String fullName = null;
        if (personNodeRef != null && this.nodeService.exists(personNodeRef)) {
            String firstName = (String)((Object)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_FIRSTNAME));
            String lastName = (String)((Object)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_LASTNAME));
            String string = fullName = firstName != null && firstName.length() > 0 ? firstName : "";
            if (lastName != null && lastName.length() > 0) {
                fullName = String.valueOf(fullName) + (fullName.length() > 0 ? " " : "");
                fullName = String.valueOf(fullName) + lastName;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Generated name '" + fullName + "' for user '" + user + "'."));
        }
        return fullName;
    }
}

