/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryRepositoryBootstrap;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseSpringTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.transaction.annotation.Transactional;

@Category(value={BaseSpringTestsCategory.class})
@Transactional
public class DictionaryRepositoryBootstrapTest
extends BaseSpringTest {
    public static final String TEMPLATE_MODEL_XML = "<model name={0} xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>{1}</description>   <author>Alfresco</author>   <published>2005-05-30</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>      {2}    </imports>   <namespaces>      <namespace uri={3} prefix={4}/>   </namespaces>   <types>      <type name={5}>        <title>Base</title>        <description>The Base Type</description>        <properties>           <property name={6}>              <type>d:text</type>           </property>        </properties>      </type>   </types></model>";
    public static final String MESSAGES_KEY = "my_bootstrap_test";
    public static final String MESSAGES_VALUE = "My Message";
    public static final String MESSAGES_VALUE_FR = "Mon message";
    public static final String FOLDERNAME_MODELS = "models";
    public static final String FOLDERNAME_MESSAGES = "messages";
    public static final String BUNDLENAME_MESSAGES = "testBootstap";
    public static final String FILENAME_MESSAGES_EXT = ".properties";
    private BehaviourFilter behaviourFilter;
    private DictionaryRepositoryBootstrap bootstrap;
    private DictionaryDAO dictionaryDAO;
    private TransactionService transactionService;
    private TenantAdminService tenantAdminService;
    private NamespaceService namespaceService;
    private MessageService messageService;
    private PolicyComponent policyComponent;
    private ContentService contentService;
    private NodeService nodeService;
    private MutableAuthenticationService authenticationService;
    protected AuthenticationComponent authenticationComponent;
    private UserTransaction txn;
    private StoreRef storeRef;
    private NodeRef rootModelsNodeRef;
    private NodeRef rootMessagesNodeRef;

    @Before
    public void before() throws Exception {
        this.behaviourFilter = (BehaviourFilter)this.applicationContext.getBean("policyBehaviourFilter");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.dictionaryDAO = (DictionaryDAO)this.applicationContext.getBean("dictionaryDAO");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.tenantAdminService = (TenantAdminService)this.applicationContext.getBean("tenantAdminService");
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("namespaceService");
        this.messageService = (MessageService)this.applicationContext.getBean("messageService");
        this.policyComponent = (PolicyComponent)this.applicationContext.getBean("policyComponent");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        NodeRef rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        this.rootModelsNodeRef = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)FOLDERNAME_MODELS), ContentModel.TYPE_FOLDER).getChildRef();
        this.rootMessagesNodeRef = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)FOLDERNAME_MESSAGES), ContentModel.TYPE_FOLDER).getChildRef();
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        this.bootstrap = new DictionaryRepositoryBootstrap();
        this.bootstrap.setContentService(this.contentService);
        this.bootstrap.setDictionaryDAO(this.dictionaryDAO);
        this.bootstrap.setTransactionService(this.transactionService);
        this.bootstrap.setTenantAdminService(this.tenantAdminService);
        this.bootstrap.setNodeService(this.nodeService);
        this.bootstrap.setNamespaceService(this.namespaceService);
        this.bootstrap.setMessageService(this.messageService);
        this.bootstrap.setPolicyComponent(this.policyComponent);
        RepositoryLocation modelsLocation = new RepositoryLocation(this.storeRef, this.nodeService.getPath(this.rootModelsNodeRef).toPrefixString((NamespacePrefixResolver)this.namespaceService), "path");
        RepositoryLocation messagesLocation = new RepositoryLocation(this.storeRef, this.nodeService.getPath(this.rootMessagesNodeRef).toPrefixString((NamespacePrefixResolver)this.namespaceService), "path");
        ArrayList<RepositoryLocation> modelsLocations = new ArrayList<RepositoryLocation>();
        modelsLocations.add(modelsLocation);
        ArrayList<RepositoryLocation> messagesLocations = new ArrayList<RepositoryLocation>();
        messagesLocations.add(messagesLocation);
        this.bootstrap.setRepositoryModelsLocations(modelsLocations);
        this.bootstrap.setRepositoryMessagesLocations(messagesLocations);
        this.bootstrap.register();
        this.txn.commit();
    }

    @After
    public void after() throws Exception {
        this.authenticationService.clearCurrentSecurityContext();
    }

    @Test
    public void testBootstrap() throws Exception {
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        this.behaviourFilter.disableBehaviour(ContentModel.TYPE_DICTIONARY_MODEL);
        this.createModelNode("http://www.alfresco.org/model/test2DictionaryBootstrapFromRepo/1.0", "test2", "testModel2", " <import uri=\"http://www.alfresco.org/model/test1DictionaryBootstrapFromRepo/1.0\" prefix=\"test1\"/> ", "Test model two", "base2", "prop2");
        this.createModelNode("http://www.alfresco.org/model/test3DictionaryBootstrapFromRepo/1.0", "test3", "testModel3", " <import uri=\"http://www.alfresco.org/model/test1DictionaryBootstrapFromRepo/1.0\" prefix=\"test1\"/> ", "Test model three", "base3", "prop3");
        this.createModelNode("http://www.alfresco.org/model/test1DictionaryBootstrapFromRepo/1.0", "test1", "testModel1", "", "Test model one", "base1", "prop1");
        NodeRef messageNodeDefaultLoc = this.createMessagesNode(null, null);
        this.createMessagesNode(Locale.FRANCE.toString(), MESSAGES_VALUE_FR);
        String baseBundleName = String.valueOf(this.storeRef.toString()) + this.messageService.getBaseBundleName(this.nodeService.getPath(messageNodeDefaultLoc).toPrefixString((NamespacePrefixResolver)this.namespaceService));
        try {
            this.dictionaryDAO.getModel(QName.createQName((String)"http://www.alfresco.org/model/test1DictionaryBootstrapFromRepo/1.0", (String)"testModel1"));
            DictionaryRepositoryBootstrapTest.fail((String)"The model should not be there.");
        }
        catch (DictionaryException dictionaryException) {}
        this.bootstrap.init();
        ModelDefinition modelDefinition1 = this.dictionaryDAO.getModel(QName.createQName((String)"http://www.alfresco.org/model/test1DictionaryBootstrapFromRepo/1.0", (String)"testModel1"));
        DictionaryRepositoryBootstrapTest.assertNotNull((Object)modelDefinition1);
        ModelDefinition modelDefinition2 = this.dictionaryDAO.getModel(QName.createQName((String)"http://www.alfresco.org/model/test2DictionaryBootstrapFromRepo/1.0", (String)"testModel2"));
        DictionaryRepositoryBootstrapTest.assertNotNull((Object)modelDefinition2);
        ModelDefinition modelDefinition3 = this.dictionaryDAO.getModel(QName.createQName((String)"http://www.alfresco.org/model/test3DictionaryBootstrapFromRepo/1.0", (String)"testModel3"));
        DictionaryRepositoryBootstrapTest.assertNotNull((Object)modelDefinition3);
        DictionaryRepositoryBootstrapTest.assertTrue((String)"The message bundle should be registered", (boolean)this.messageService.getRegisteredBundles().contains(baseBundleName));
        DictionaryRepositoryBootstrapTest.assertEquals((String)"The default message value is not as expected", (String)MESSAGES_VALUE, (String)this.messageService.getMessage(MESSAGES_KEY));
        DictionaryRepositoryBootstrapTest.assertEquals((String)"The message value in french is not as expected", (String)MESSAGES_VALUE_FR, (String)this.messageService.getMessage(MESSAGES_KEY, Locale.FRANCE));
        this.txn.commit();
    }

    private NodeRef createModelNode(String uri, String prefix, String modelLocalName, String importStatement, String description, String typeName, String propertyName) {
        NodeRef model = this.nodeService.createNode(this.rootModelsNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}models"), ContentModel.TYPE_DICTIONARY_MODEL).getChildRef();
        ContentWriter contentWriter1 = this.contentService.getWriter(model, ContentModel.PROP_CONTENT, true);
        contentWriter1.setEncoding("UTF-8");
        contentWriter1.setMimetype("text/xml");
        String modelOne = this.getModelString(uri, prefix, modelLocalName, importStatement, description, typeName, propertyName);
        contentWriter1.putContent(modelOne);
        this.nodeService.setProperty(model, ContentModel.PROP_MODEL_ACTIVE, (Serializable)Boolean.TRUE);
        return model;
    }

    private NodeRef createMessagesNode(String locale, String localeValue) {
        String filename = "testBootstap.properties";
        String messageValue = MESSAGES_VALUE;
        if (locale != null) {
            filename = "testBootstap_" + locale + FILENAME_MESSAGES_EXT;
            messageValue = localeValue;
        }
        NodeRef messageNode = this.nodeService.createNode(this.rootMessagesNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)filename), ContentModel.TYPE_CONTENT, Collections.singletonMap(ContentModel.PROP_NAME, filename)).getChildRef();
        ContentWriter contentWriter = this.contentService.getWriter(messageNode, ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("text/plain");
        String messagesString = "my_bootstrap_test=" + messageValue;
        contentWriter.putContent(messagesString);
        return messageNode;
    }

    private String getModelString(String uri, String prefix, String modelLocalName, String importStatement, String description, String typeName, String propertyName) {
        return MessageFormat.format(TEMPLATE_MODEL_XML, "'" + prefix + ":" + modelLocalName + "'", description, importStatement, "'" + uri + "'", "'" + prefix + "'", "'" + prefix + ":" + typeName + "'", "'" + prefix + ":" + propertyName + "'");
    }
}

