/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr.facet.handler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.impl.solr.facet.handler.AbstractFacetLabelDisplayHandler;
import org.alfresco.repo.search.impl.solr.facet.handler.FacetLabel;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.util.ISO9075;
import org.springframework.extensions.surf.util.ParameterCheck;

public class SiteTitleDisplayHandler
extends AbstractFacetLabelDisplayHandler {
    private final Map<String, String> nonSiteLocationsLabels;

    public SiteTitleDisplayHandler(Set<String> supportedFieldFacets) {
        this(supportedFieldFacets, Collections.emptyMap());
    }

    public SiteTitleDisplayHandler(Set<String> supportedFieldFacets, Map<String, String> nonSiteLocationsLabels) {
        ParameterCheck.mandatory((String)"supportedFieldFacets", supportedFieldFacets);
        this.supportedFieldFacets = Collections.unmodifiableSet(new HashSet<String>(supportedFieldFacets));
        this.nonSiteLocationsLabels = nonSiteLocationsLabels == null ? Collections.emptyMap() : nonSiteLocationsLabels;
    }

    @Override
    public FacetLabel getDisplayLabel(String value) {
        SiteService siteService;
        SiteInfo siteInfo;
        value = ISO9075.decode((String)value);
        String title = null;
        title = this.nonSiteLocationsLabels.containsKey(value) ? this.nonSiteLocationsLabels.get(value) : ((siteInfo = (siteService = this.serviceRegistry.getSiteService()).getSite(value)) != null ? siteInfo.getTitle() : value);
        return new FacetLabel(value, title, -1);
    }
}

