/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.repo.rendition2.RenditionDefinitionRegistry2;
import org.alfresco.repo.rendition2.RenditionService2;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.repo.thumbnail.ThumbnailRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionServiceTransientException;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentServiceTransientException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class CreateThumbnailActionExecuter
extends ActionExecuterAbstractBase {
    private static Log logger = LogFactory.getLog(CreateThumbnailActionExecuter.class);
    private ThumbnailService thumbnailService;
    private NodeService nodeService;
    private HashMap<String, Long> mimetypeMaxSourceSizeKBytes;
    private RenditionService2 renditionService2;
    public static final String NAME = "create-thumbnail";
    public static final String PARAM_CONTENT_PROPERTY = "content-property";
    public static final String PARAM_THUMBANIL_NAME = "thumbnail-name";

    public void setThumbnailService(ThumbnailService thumbnailService) {
        this.thumbnailService = thumbnailService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setMimetypeMaxSourceSizeKBytes(HashMap<String, Long> mimetypeMaxSourceSizeKBytes) {
        this.mimetypeMaxSourceSizeKBytes = mimetypeMaxSourceSizeKBytes;
    }

    public void setRenditionService2(RenditionService2 renditionService2) {
        this.renditionService2 = renditionService2;
    }

    public void setGenerateThumbnails(boolean generateThumbnails) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Thumbnail generation is " + (generateThumbnails ? "enabled" : "disabled") + "via deprecated method in " + this.getClass().getSimpleName()));
        }
        this.thumbnailService.setThumbnailsEnabled(generateThumbnails);
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        if (!this.thumbnailService.getThumbnailsEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Thumbnail transformations are not enabled");
            }
            return;
        }
        if (this.nodeService.exists(actionedUponNodeRef)) {
            CharSequence msg;
            Serializable contentProp;
            String thumbnailName = (String)((Object)action.getParameterValue(PARAM_THUMBANIL_NAME));
            ThumbnailRegistry registry = this.thumbnailService.getThumbnailRegistry();
            ThumbnailDefinition details = registry.getThumbnailDefinition(thumbnailName);
            if (details == null) {
                throw new AlfrescoRuntimeException("The thumbnail name '" + thumbnailName + "' is not registered");
            }
            QName contentProperty = (QName)action.getParameterValue(PARAM_CONTENT_PROPERTY);
            if (contentProperty == null) {
                contentProperty = ContentModel.PROP_CONTENT;
            }
            if ((contentProp = this.nodeService.getProperty(actionedUponNodeRef, contentProperty)) == null) {
                logger.info((Object)("Creation of thumbnail, null content for " + details.getName()));
                return;
            }
            if (contentProp instanceof ContentData) {
                Long maxSourceSizeKBytes;
                ContentData content = (ContentData)contentProp;
                String mimetype = content.getMimetype();
                if (!registry.isThumbnailDefinitionAvailable(content.getContentUrl(), mimetype, content.getSize(), actionedUponNodeRef, details)) {
                    logger.debug((Object)("Unable to create thumbnail '" + details.getName() + "' for " + mimetype + " as no transformer is currently available"));
                    return;
                }
                if (this.mimetypeMaxSourceSizeKBytes != null && (maxSourceSizeKBytes = this.mimetypeMaxSourceSizeKBytes.get(mimetype)) != null && maxSourceSizeKBytes >= 0L && maxSourceSizeKBytes < content.getSize() / 1024L) {
                    logger.debug((Object)("Unable to create thumbnail '" + details.getName() + "' for " + mimetype + " as content is too large (" + content.getSize() / 1024L + "K > " + maxSourceSizeKBytes + "K)"));
                    return;
                }
            }
            try {
                boolean async = action.getExecuteAsychronously();
                RenditionDefinition2 renditionDefinition = null;
                if (async) {
                    RenditionDefinitionRegistry2 renditionDefinitionRegistry2 = this.renditionService2.getRenditionDefinitionRegistry2();
                    renditionDefinition = renditionDefinitionRegistry2.getRenditionDefinition(thumbnailName);
                }
                if (async && renditionDefinition != null) {
                    this.renditionService2.render(actionedUponNodeRef, thumbnailName);
                } else {
                    TransformationOptions options = details.getTransformationOptions();
                    this.thumbnailService.createThumbnail(actionedUponNodeRef, contentProperty, details.getMimetype(), options, thumbnailName, null);
                }
            }
            catch (ContentServiceTransientException cste) {
                msg = new StringBuilder();
                ((StringBuilder)msg).append("Creation of thumbnail '").append(details.getName()).append("' declined");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)((StringBuilder)msg).toString());
                }
                throw new ActionServiceTransientException(((StringBuilder)msg).toString(), cste);
            }
            catch (Exception exception) {
                msg = "Creation of thumbnail '" + details.getName() + "' failed";
                logger.info((Object)msg);
                throw new AlfrescoRuntimeException((String)msg, (Throwable)exception);
            }
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_THUMBANIL_NAME, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_THUMBANIL_NAME)));
        paramList.add(new ParameterDefinitionImpl(PARAM_CONTENT_PROPERTY, DataTypeDefinition.QNAME, false, this.getParamDisplayLabel(PARAM_CONTENT_PROPERTY)));
    }
}

