/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryRepositoryBootstrap;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.test.context.transaction.TestTransaction;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ResourceUtils;

@Category(value={BaseSpringTestsCategory.class, LuceneTests.class})
@Transactional
public class DictionaryModelTypeTest
extends BaseSpringTest {
    private static final QName TEST_MODEL_ONE = QName.createQName((String)"{http://www.alfresco.org/test/testmodel1/1.0}testModelOne");
    private static final QName TEST_MODEL_TWO = QName.createQName((String)"{http://www.alfresco.org/test/testmodel2/1.0}testModelTwo");
    private static final QName TEST_MODEL_THREE = QName.createQName((String)"{http://www.alfresco.org/test/testmodel3/1.0}testModelThree");
    public static final String MODEL_ONE_XML = "<model name='test1:testModelOne' xmlns='http://www.alfresco.org/model/dictionary/1.0'>   <description>Test model one</description>   <author>Alfresco</author>   <published>2005-05-30</published>   <version>1.0</version>   <imports>      <import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d'/>      <import uri='http://www.alfresco.org/model/content/1.0' prefix='cm'/>   </imports>   <namespaces>      <namespace uri='http://www.alfresco.org/test/testmodel1/1.0' prefix='test1'/>   </namespaces>   <types>      <type name='test1:base'>        <title>Base</title>        <description>The Base Type</description>        <parent>cm:content</parent>        <properties>           <property name='test1:prop1'>              <type>d:text</type>           </property>        </properties>      </type>   </types></model>";
    public static final String MODEL_ONE_MODIFIED_XML = "<model name='test1:testModelOne' xmlns='http://www.alfresco.org/model/dictionary/1.0'>   <description>Test model one (updated)</description>   <author>Alfresco</author>   <published>2005-05-30</published>   <version>1.1</version>   <imports>      <import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d'/>      <import uri='http://www.alfresco.org/model/content/1.0' prefix='cm'/>   </imports>   <namespaces>      <namespace uri='http://www.alfresco.org/test/testmodel1/1.0' prefix='test1'/>   </namespaces>   <types>      <type name='test1:base'>        <title>Base</title>        <description>The Base Type</description>        <parent>cm:content</parent>        <properties>           <property name='test1:prop1'>              <type>d:text</type>           </property>           <property name='test1:prop2'>              <type>d:boolean</type>           </property>        </properties>      </type>   </types></model>";
    public static final String MODEL_ONE_MODIFIED2_XML = "<model name='test1:testModelOne' xmlns='http://www.alfresco.org/model/dictionary/1.0'>   <description>Test model one (updated 2)</description>   <author>Alfresco</author>   <published>2005-05-30</published>   <version>1.2</version>   <imports>      <import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d'/>      <import uri='http://www.alfresco.org/model/content/1.0' prefix='cm'/>   </imports>   <namespaces>      <namespace uri='http://www.alfresco.org/test/testmodel1/1.0' prefix='test1'/>   </namespaces>   <types>      <type name='test1:base'>        <title>Base</title>        <description>The Base Type</description>        <parent>cm:content</parent>        <properties>           <property name='test1:prop1'>              <type>d:text</type>           </property>           <property name='test1:prop99'>              <type>d:text</type>           </property>        </properties>      </type>   </types></model>";
    public static final String MODEL_TWO_XML = "<model name='test2:testModelTwo' xmlns='http://www.alfresco.org/model/dictionary/1.0'>   <description>Test model two</description>   <author>Alfresco</author>   <published>2010-01-13</published>   <version>1.0</version>   <imports>      <import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d'/>      <import uri='http://www.alfresco.org/model/content/1.0' prefix='cm'/>   </imports>   <namespaces>      <namespace uri='http://www.alfresco.org/test/testmodel2/1.0' prefix='test2'/>   </namespaces>   <constraints>      <constraint name='test2:con1' type='LIST'>         <parameter name='allowedValues'>            <list>               <value>alfresco</value>               <value>file</value>            </list>         </parameter>      </constraint>   </constraints>   <types>      <type name='test2:base'>        <title>Base</title>        <description>The Base Type</description>        <parent>cm:content</parent>        <properties>           <property name='test2:prop2'>              <type>d:text</type>              <constraints>                 <constraint ref='test2:con1'/>              </constraints>           </property>        </properties>      </type>   </types></model>";
    public static final String MODEL_TWO_INVALID_XML = "<model name='test2:testModelTwo' xmlns='http://www.alfresco.org/model/dictionary/1.0'>   <description>Test model two</description>   <author>Alfresco</author>   <published>2010-01-14</published>   <version>1.1</version>   <imports>      <import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d'/>      <import uri='http://www.alfresco.org/model/content/1.0' prefix='cm'/>   </imports>   <namespaces>      <namespace uri='http://www.alfresco.org/test/testmodel2/1.0' prefix='test2'/>   </namespaces>   <types>      <type name='test2:base'>        <title>Base</title>        <description>The Base Type</description>        <parent>cm:content</parent>        <properties>           <property name='test2:prop2'>              <type>d:text</type>              <constraints>                 <constraint ref='test2:con1'/>              </constraints>           </property>        </properties>      </type>   </types></model>";
    public static final String MODEL_TWO_MODIFIED_XML = "<model name='test2:testModelTwo' xmlns='http://www.alfresco.org/model/dictionary/1.0'>   <description>Test model two - modified</description>   <author>Alfresco - modified</author>   <published>2010-01-14</published>   <version>1.1</version>   <imports>      <import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d'/>      <import uri='http://www.alfresco.org/model/content/1.0' prefix='cm'/>   </imports>   <namespaces>      <namespace uri='http://www.alfresco.org/test/testmodel2/1.0' prefix='test2'/>   </namespaces>   <types>      <type name='test2:base'>        <title>Base</title>        <description>The Base Type</description>        <parent>cm:content</parent>        <properties>           <property name='test2:prop2'>              <type>d:text</type>           </property>        </properties>      </type>   </types></model>";
    public static final String MODEL_THREE_XML = "<model name='test3:testModelThree' xmlns='http://www.alfresco.org/model/dictionary/1.0'>   <description>Test model three</description>   <author>Alfresco</author>   <published>2005-05-30</published>   <version>1.0</version>   <imports>      <import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d'/>      <import uri='http://www.alfresco.org/model/content/1.0' prefix='cm'/>   </imports>   <namespaces>      <namespace uri='http://www.alfresco.org/test/testmodel3/1.0' prefix='test3'/>   </namespaces>   <types>      <type name='test3:base'>        <title>Base</title>        <description>The Base Type</description>        <parent>cm:content</parent>        <properties>           <property name='test3:prop1'>              <type>d:text</type>              <mandatory enforced='false'>true</mandatory>           </property>        </properties>      </type>      <type name='test3:base-override'>        <title>Base</title>        <description>The Base Type</description>        <parent>test3:base</parent>        <overrides>           <property name='test3:prop1'>              <mandatory enforced='true'>true</mandatory>           </property>        </overrides>      </type>   </types></model>";
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private CheckOutCheckInService cociService;
    private DictionaryDAO dictionaryDAO;
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private ContentService contentService;
    private MutableAuthenticationService authenticationService;
    private StoreRef storeRef;
    private NodeRef rootNodeRef;
    private ActionService actionService;
    private TransactionService transactionService;
    private AuthenticationComponent authenticationComponent;

    @Before
    public void before() throws Exception {
        TestTransaction.flagForCommit();
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        this.dictionaryService = (DictionaryService)this.applicationContext.getBean("dictionaryService");
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("namespaceService");
        this.cociService = (CheckOutCheckInService)this.applicationContext.getBean("checkOutCheckInService");
        this.dictionaryDAO = (DictionaryDAO)this.applicationContext.getBean("dictionaryDAO");
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService");
        this.policyComponent = (PolicyComponent)this.applicationContext.getBean("policyComponent");
        TenantAdminService tenantAdminService = (TenantAdminService)this.applicationContext.getBean("tenantAdminService");
        MessageService messageService = (MessageService)this.applicationContext.getBean("messageService");
        TestTransaction.end();
        TestTransaction.start();
        TestTransaction.flagForCommit();
        DictionaryRepositoryBootstrap bootstrap = new DictionaryRepositoryBootstrap();
        bootstrap.setContentService(this.contentService);
        bootstrap.setDictionaryDAO(this.dictionaryDAO);
        bootstrap.setTransactionService(this.transactionService);
        bootstrap.setTenantAdminService(tenantAdminService);
        bootstrap.setNodeService(this.nodeService);
        bootstrap.setNamespaceService(this.namespaceService);
        bootstrap.setMessageService(messageService);
        bootstrap.setPolicyComponent(this.policyComponent);
        RepositoryLocation location = new RepositoryLocation();
        location.setStoreProtocol(this.storeRef.getProtocol());
        location.setStoreId(this.storeRef.getIdentifier());
        location.setQueryLanguage("path");
        ArrayList<RepositoryLocation> locations = new ArrayList<RepositoryLocation>();
        locations.add(location);
        bootstrap.setRepositoryModelsLocations(locations);
        bootstrap.register();
        TestTransaction.end();
        TestTransaction.start();
    }

    @After
    public void after() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    @Test
    public void testCreateAndUpdateDictionaryModelNodeContent() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        try {
            this.dictionaryService.getModel(TEST_MODEL_ONE);
            DictionaryModelTypeTest.fail((String)"This model has not yet been loaded into the dictionary service");
        }
        catch (DictionaryException dictionaryException) {}
        String uri = this.namespaceService.getNamespaceURI("test1");
        DictionaryModelTypeTest.assertNull((Object)uri);
        final NodeRef modelNode = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            PropertyMap properties = new PropertyMap(1);
            properties.put((Object)ContentModel.PROP_MODEL_ACTIVE, (Object)true);
            NodeRef model = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"dictionaryModels"), ContentModel.TYPE_DICTIONARY_MODEL, (Map)properties).getChildRef();
            DictionaryModelTypeTest.assertNotNull((Object)model);
            ContentWriter contentWriter = this.contentService.getWriter(model, ContentModel.PROP_CONTENT, true);
            contentWriter.setEncoding("UTF-8");
            contentWriter.setMimetype("text/xml");
            contentWriter.putContent(MODEL_ONE_XML);
            return model;
        }, false, true);
        final NodeRef workingCopy = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Exception {
                String uri = DictionaryModelTypeTest.this.namespaceService.getNamespaceURI("test1");
                DictionaryModelTypeTest.assertNotNull((Object)uri);
                DictionaryModelTypeTest.assertEquals((Object)QName.createQName((String)"{http://www.alfresco.org/test/testmodel1/1.0}testModelOne"), (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_NAME));
                DictionaryModelTypeTest.assertEquals((Object)"Test model one", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_DESCRIPTION));
                DictionaryModelTypeTest.assertEquals((Object)"Alfresco", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_AUTHOR));
                DictionaryModelTypeTest.assertEquals((Object)"1.0", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_VERSION));
                ModelDefinition modelDefinition2 = DictionaryModelTypeTest.this.dictionaryService.getModel(TEST_MODEL_ONE);
                DictionaryModelTypeTest.assertNotNull((Object)modelDefinition2);
                DictionaryModelTypeTest.assertEquals((String)"Test model one", (String)modelDefinition2.getDescription((MessageLookup)DictionaryModelTypeTest.this.dictionaryService));
                String uri2 = DictionaryModelTypeTest.this.namespaceService.getNamespaceURI("test1");
                DictionaryModelTypeTest.assertEquals((String)uri2, (String)"http://www.alfresco.org/test/testmodel1/1.0");
                NodeRef workingCopy = DictionaryModelTypeTest.this.cociService.checkout(modelNode);
                ContentWriter contentWriter2 = DictionaryModelTypeTest.this.contentService.getWriter(workingCopy, ContentModel.PROP_CONTENT, true);
                contentWriter2.putContent(DictionaryModelTypeTest.MODEL_ONE_MODIFIED_XML);
                return workingCopy;
            }
        }, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                DictionaryModelTypeTest.assertEquals((Object)"1.0", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(workingCopy, ContentModel.PROP_MODEL_VERSION));
                DictionaryModelTypeTest.this.cociService.checkin(workingCopy, null);
                return null;
            }
        }, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                DictionaryModelTypeTest.assertEquals((Object)"1.1", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_VERSION));
                return null;
            }
        }, false, true);
        final NodeRef node1 = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Exception {
                NodeRef node = DictionaryModelTypeTest.this.nodeService.createNode(DictionaryModelTypeTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"node1"), QName.createQName((String)"http://www.alfresco.org/test/testmodel1/1.0", (String)"base"), null).getChildRef();
                DictionaryModelTypeTest.assertNotNull((Object)node);
                return node;
            }
        }, false, true);
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Exception {
                    DictionaryModelTypeTest.this.nodeService.deleteNode(modelNode);
                    return null;
                }
            }, false, true);
            DictionaryModelTypeTest.fail((String)"Unexpected - should not be able to delete model");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                DictionaryModelTypeTest.this.nodeService.deleteNode(node1);
                return null;
            }
        }, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                DictionaryModelTypeTest.this.nodeService.deleteNode(modelNode);
                return null;
            }
        }, false, true);
    }

    @Test
    public void testUpdateDictionaryModelPropertyDelete() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        try {
            this.dictionaryService.getModel(TEST_MODEL_ONE);
            DictionaryModelTypeTest.fail((String)"This model has not yet been loaded into the dictionary service");
        }
        catch (DictionaryException dictionaryException) {}
        String uri = this.namespaceService.getNamespaceURI("test1");
        DictionaryModelTypeTest.assertNull((Object)uri);
        PropertyMap properties = new PropertyMap(1);
        properties.put((Object)ContentModel.PROP_MODEL_ACTIVE, (Object)true);
        final NodeRef modelNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"dictionaryModels"), ContentModel.TYPE_DICTIONARY_MODEL, (Map)properties).getChildRef();
        DictionaryModelTypeTest.assertNotNull((Object)modelNode);
        ContentWriter contentWriter = this.contentService.getWriter(modelNode, ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("text/xml");
        contentWriter.putContent(MODEL_ONE_MODIFIED_XML);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        final NodeRef node1 = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Exception {
                String uri = DictionaryModelTypeTest.this.namespaceService.getNamespaceURI("test1");
                DictionaryModelTypeTest.assertNotNull((Object)uri);
                PropertyMap properties = new PropertyMap(1);
                properties.put((Object)QName.createQName((String)"http://www.alfresco.org/test/testmodel1/1.0", (String)"prop2"), (Object)"false");
                NodeRef node = DictionaryModelTypeTest.this.nodeService.createNode(DictionaryModelTypeTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"node1"), QName.createQName((String)"http://www.alfresco.org/test/testmodel1/1.0", (String)"base"), (Map)properties).getChildRef();
                DictionaryModelTypeTest.assertNotNull((Object)node);
                return node;
            }
        }, false, true);
        final NodeRef workingCopy = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Exception {
                NodeRef workingCopy = DictionaryModelTypeTest.this.cociService.checkout(modelNode);
                ContentWriter contentWriter2 = DictionaryModelTypeTest.this.contentService.getWriter(workingCopy, ContentModel.PROP_CONTENT, true);
                contentWriter2.putContent(DictionaryModelTypeTest.MODEL_ONE_MODIFIED2_XML);
                return workingCopy;
            }
        }, false, true);
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Exception {
                    DictionaryModelTypeTest.assertEquals((Object)"1.1", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(workingCopy, ContentModel.PROP_MODEL_VERSION));
                    DictionaryModelTypeTest.this.cociService.checkin(workingCopy, null);
                    return null;
                }
            });
            DictionaryModelTypeTest.fail((String)"Unexpected - should not be able to update model");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                DictionaryModelTypeTest.this.nodeService.deleteNode(node1);
                return null;
            }
        }, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                DictionaryModelTypeTest.assertEquals((Object)"1.1", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(workingCopy, ContentModel.PROP_MODEL_VERSION));
                DictionaryModelTypeTest.this.cociService.checkin(workingCopy, null);
                return null;
            }
        }, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                DictionaryModelTypeTest.assertEquals((Object)"1.2", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_VERSION));
                return null;
            }
        }, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                DictionaryModelTypeTest.this.nodeService.deleteNode(modelNode);
                return null;
            }
        }, false, true);
    }

    @Test
    public void testUpdateDictionaryModelConstraintDelete() throws Exception {
        try {
            this.dictionaryService.getModel(TEST_MODEL_TWO);
            DictionaryModelTypeTest.fail((String)"This model has not yet been loaded into the dictionary service");
        }
        catch (DictionaryException dictionaryException) {}
        String uri = this.namespaceService.getNamespaceURI("test2");
        DictionaryModelTypeTest.assertNull((Object)uri);
        PropertyMap properties = new PropertyMap(1);
        properties.put((Object)ContentModel.PROP_MODEL_ACTIVE, (Object)true);
        final NodeRef modelNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"dictionaryModels"), ContentModel.TYPE_DICTIONARY_MODEL, (Map)properties).getChildRef();
        DictionaryModelTypeTest.assertNotNull((Object)modelNode);
        ContentWriter contentWriter = this.contentService.getWriter(modelNode, ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("text/xml");
        contentWriter.putContent(MODEL_TWO_XML);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        final NodeRef workingCopy = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Exception {
                String uri = DictionaryModelTypeTest.this.namespaceService.getNamespaceURI("test2");
                DictionaryModelTypeTest.assertNotNull((Object)uri);
                Collection constraints = DictionaryModelTypeTest.this.dictionaryService.getConstraints(TEST_MODEL_TWO, true);
                DictionaryModelTypeTest.assertEquals((int)1, (int)constraints.size());
                DictionaryModelTypeTest.assertEquals((String)"test2:con1", (String)((ConstraintDefinition)constraints.iterator().next()).getName().getPrefixString());
                NodeRef workingCopy = DictionaryModelTypeTest.this.cociService.checkout(modelNode);
                ContentWriter contentWriter2 = DictionaryModelTypeTest.this.contentService.getWriter(workingCopy, ContentModel.PROP_CONTENT, true);
                contentWriter2.putContent(DictionaryModelTypeTest.MODEL_TWO_INVALID_XML);
                return workingCopy;
            }
        });
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Exception {
                    DictionaryModelTypeTest.assertEquals((Object)"1.0", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(workingCopy, ContentModel.PROP_MODEL_VERSION));
                    DictionaryModelTypeTest.this.cociService.checkin(workingCopy, null);
                    return null;
                }
            });
            DictionaryModelTypeTest.fail((String)"Unexpected - should not be able to update model");
        }
        catch (AlfrescoRuntimeException are) {
            DictionaryModelTypeTest.assertTrue((boolean)are.getMessage().contains("Failed to validate constraint delete"));
        }
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                DictionaryModelTypeTest.assertEquals((Object)"1.0", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_VERSION));
                ContentWriter contentWriter2 = DictionaryModelTypeTest.this.contentService.getWriter(workingCopy, ContentModel.PROP_CONTENT, true);
                contentWriter2.putContent(DictionaryModelTypeTest.MODEL_TWO_MODIFIED_XML);
                DictionaryModelTypeTest.this.cociService.checkin(workingCopy, null);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                Collection constraints = DictionaryModelTypeTest.this.dictionaryService.getConstraints(TEST_MODEL_TWO, true);
                DictionaryModelTypeTest.assertEquals((int)0, (int)constraints.size());
                DictionaryModelTypeTest.assertEquals((Object)"1.1", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_VERSION));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                DictionaryModelTypeTest.this.nodeService.deleteNode(modelNode);
                return null;
            }
        });
    }

    @Test
    public void testIsActiveFlagAndDelete() throws Exception {
        try {
            this.dictionaryService.getModel(TEST_MODEL_ONE);
            DictionaryModelTypeTest.fail((String)"This model has not yet been loaded into the dictionary service");
        }
        catch (DictionaryException dictionaryException) {}
        PropertyMap properties = new PropertyMap(1);
        final NodeRef modelNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"dictionaryModels"), ContentModel.TYPE_DICTIONARY_MODEL, (Map)properties).getChildRef();
        DictionaryModelTypeTest.assertNotNull((Object)modelNode);
        ContentWriter contentWriter = this.contentService.getWriter(modelNode, ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("text/xml");
        contentWriter.putContent(MODEL_ONE_XML);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                try {
                    DictionaryModelTypeTest.this.dictionaryService.getModel(TEST_MODEL_ONE);
                    DictionaryModelTypeTest.fail((String)"This model has not yet been loaded into the dictionary service");
                }
                catch (DictionaryException dictionaryException) {}
                DictionaryModelTypeTest.this.nodeService.setProperty(modelNode, ContentModel.PROP_MODEL_ACTIVE, (Serializable)Boolean.valueOf(true));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                DictionaryModelTypeTest.assertNotNull((Object)DictionaryModelTypeTest.this.dictionaryService.getModel(TEST_MODEL_ONE));
                DictionaryModelTypeTest.this.nodeService.setProperty(modelNode, ContentModel.PROP_MODEL_ACTIVE, (Serializable)Boolean.valueOf(false));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                try {
                    DictionaryModelTypeTest.this.dictionaryService.getModel(TEST_MODEL_ONE);
                    DictionaryModelTypeTest.fail((String)"This model has not yet been loaded into the dictionary service");
                }
                catch (DictionaryException dictionaryException) {}
                DictionaryModelTypeTest.this.nodeService.setProperty(modelNode, ContentModel.PROP_MODEL_ACTIVE, (Serializable)Boolean.valueOf(true));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                DictionaryModelTypeTest.assertNotNull((Object)DictionaryModelTypeTest.this.dictionaryService.getModel(TEST_MODEL_ONE));
                DictionaryModelTypeTest.this.nodeService.deleteNode(modelNode);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                try {
                    DictionaryModelTypeTest.this.dictionaryService.getModel(TEST_MODEL_ONE);
                    DictionaryModelTypeTest.fail((String)"This model has not yet been loaded into the dictionary service");
                }
                catch (DictionaryException dictionaryException) {}
                return null;
            }
        });
    }

    @Test
    public void testOverrideMandatoryProperty() throws Exception {
        try {
            this.dictionaryService.getModel(TEST_MODEL_THREE);
            DictionaryModelTypeTest.fail((String)"This model has not yet been loaded into the dictionary service");
        }
        catch (DictionaryException dictionaryException) {}
        String uri = this.namespaceService.getNamespaceURI("test3");
        DictionaryModelTypeTest.assertNull((Object)uri);
        PropertyMap properties = new PropertyMap(1);
        properties.put((Object)ContentModel.PROP_MODEL_ACTIVE, (Object)true);
        final NodeRef modelNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"dictionaryModels"), ContentModel.TYPE_DICTIONARY_MODEL, (Map)properties).getChildRef();
        DictionaryModelTypeTest.assertNotNull((Object)modelNode);
        ContentWriter contentWriter = this.contentService.getWriter(modelNode, ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("text/xml");
        contentWriter.putContent(MODEL_THREE_XML);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                ContentReader reader = DictionaryModelTypeTest.this.contentService.getReader(modelNode, ContentModel.PROP_CONTENT);
                StreamSource transferReportSource = new StreamSource(reader.getContentInputStream());
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = sf.newSchema(ResourceUtils.getURL((String)"classpath:alfresco/model/modelSchema.xsd"));
                Validator validator = schema.newValidator();
                validator.validate(transferReportSource);
                return null;
            }
        });
        final NodeRef node1 = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Exception {
                HashMap<QName, String> properties = new HashMap<QName, String>();
                properties.put(QName.createQName((String)"http://www.alfresco.org/test/testmodel3/1.0", (String)"prop1"), "testvalue");
                NodeRef node = DictionaryModelTypeTest.this.nodeService.createNode(DictionaryModelTypeTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"node1"), QName.createQName((String)"http://www.alfresco.org/test/testmodel3/1.0", (String)"base-override"), properties).getChildRef();
                DictionaryModelTypeTest.assertNotNull((Object)node);
                return node;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                DictionaryModelTypeTest.this.nodeService.deleteNode(node1);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                DictionaryModelTypeTest.this.nodeService.deleteNode(modelNode);
                return null;
            }
        });
    }

    @Test
    public void testImportingSameNamespaceFails() throws Exception {
        block5: {
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
            NodeRef modelNode = this.createActiveModel("dictionary/testModel.xml");
            TestTransaction.flagForCommit();
            TestTransaction.end();
            TestTransaction.start();
            PropertyMap properties = new PropertyMap(1);
            properties.put((Object)ContentModel.PROP_MODEL_ACTIVE, (Object)true);
            final NodeRef modelNode2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"dictionaryModels"), ContentModel.TYPE_DICTIONARY_MODEL, (Map)properties).getChildRef();
            TestTransaction.flagForCommit();
            TestTransaction.end();
            try {
                try {
                    this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        public Void execute() throws Exception {
                            ContentWriter contentWriter = DictionaryModelTypeTest.this.contentService.getWriter(modelNode2, ContentModel.PROP_CONTENT, true);
                            contentWriter.putContent(Thread.currentThread().getContextClassLoader().getResourceAsStream("dictionary/testModel2.xml"));
                            return null;
                        }
                    });
                    DictionaryModelTypeTest.fail((String)"Validation should fail as a circular dependency was introduced");
                }
                catch (AlfrescoRuntimeException e) {
                    DictionaryModelTypeTest.assertTrue((boolean)e.getCause().getMessage().contains("URI mage.model cannot be imported as it is already contained in the model's namespaces"));
                    this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(modelNode){
                        private final /* synthetic */ NodeRef val$modelNode;
                        {
                            this.val$modelNode = nodeRef;
                        }

                        public Object execute() throws Exception {
                            DictionaryModelTypeTest.this.nodeService.deleteNode(this.val$modelNode);
                            return null;
                        }
                    });
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new /* invalid duplicate definition of identical inner class */);
        }
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void testImportingSameNamespaceFailsWithinSingleModel() throws Exception {
        PropertyMap properties = new PropertyMap(1);
        properties.put((Object)ContentModel.PROP_MODEL_ACTIVE, (Object)true);
        final NodeRef modelNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"dictionaryModels"), ContentModel.TYPE_DICTIONARY_MODEL, (Map)properties).getChildRef();
        DictionaryModelTypeTest.assertNotNull((Object)modelNode);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        try {
            try {
                RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
                txnHelper.setMaxRetries(1);
                txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Exception {
                        ContentWriter contentWriter = DictionaryModelTypeTest.this.contentService.getWriter(modelNode, ContentModel.PROP_CONTENT, true);
                        contentWriter.setEncoding("UTF-8");
                        contentWriter.setMimetype("text/xml");
                        contentWriter.putContent(Thread.currentThread().getContextClassLoader().getResourceAsStream("dictionary/modelWithCurrentNamespaceImported.xml"));
                        return null;
                    }
                }, false, true);
                DictionaryModelTypeTest.fail((String)"Validation should fail as a circular dependency was introduced");
            }
            catch (AlfrescoRuntimeException e) {
                DictionaryModelTypeTest.assertTrue((boolean)e.getCause().getMessage().contains("URI http://www.alfresco.org/model/dictionary/1.0 cannot be imported as it is already contained in the model's namespaces"));
                throw e;
            }
        }
        catch (Throwable throwable) {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(modelNode){
                private final /* synthetic */ NodeRef val$modelNode;
                {
                    this.val$modelNode = nodeRef;
                }

                public Object execute() throws Exception {
                    DictionaryModelTypeTest.this.nodeService.deleteNode(this.val$modelNode);
                    return null;
                }
            }, false, true);
            throw throwable;
        }
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new /* invalid duplicate definition of identical inner class */, false, true);
    }

    @Test
    public void testCircularDependencyDetected() throws Exception {
        block7: {
            RetryingTransactionHelper txnHelper;
            final NodeRef modelANode = this.createActiveModel("dictionary/modelA.xml");
            TestTransaction.flagForCommit();
            TestTransaction.end();
            TestTransaction.start();
            NodeRef modelBNode = this.createActiveModel("dictionary/modelB.xml");
            TestTransaction.flagForCommit();
            TestTransaction.end();
            try {
                txnHelper = this.transactionService.getRetryingTransactionHelper();
                txnHelper.setMaxRetries(3);
                txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Exception {
                        ContentWriter contentWriter = DictionaryModelTypeTest.this.contentService.getWriter(modelANode, ContentModel.PROP_CONTENT, true);
                        contentWriter.putContent(Thread.currentThread().getContextClassLoader().getResourceAsStream("dictionary/modelAupdated.xml"));
                        return null;
                    }
                });
                DictionaryModelTypeTest.fail((String)"Validation should fail as a circular dependency was introduced");
            }
            catch (AlfrescoRuntimeException e) {
                DictionaryModelTypeTest.assertTrue((boolean)e.getMessage().contains("Failed to validate model update - found circular dependency. You can't set parent model-B as it's model already depends on prefixA:model-A"));
            }
            try {
                try {
                    txnHelper = this.transactionService.getRetryingTransactionHelper();
                    txnHelper.setMaxRetries(3);
                    txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        public Void execute() throws Exception {
                            ContentWriter contentWriter = DictionaryModelTypeTest.this.contentService.getWriter(modelANode, ContentModel.PROP_CONTENT, true);
                            contentWriter.putContent(Thread.currentThread().getContextClassLoader().getResourceAsStream("dictionary/modelAupdatedWithSecondNamespace.xml"));
                            return null;
                        }
                    });
                    DictionaryModelTypeTest.fail((String)"Validation should fail as a circular dependency was introduced");
                }
                catch (AlfrescoRuntimeException e) {
                    DictionaryModelTypeTest.assertTrue((boolean)e.getMessage().contains("Failed to validate model update - found circular dependency. You can't set parent model-B as it's model already depends on prefixA:model-A"));
                    this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(modelANode, modelBNode){
                        private final /* synthetic */ NodeRef val$modelANode;
                        private final /* synthetic */ NodeRef val$modelBNode;
                        {
                            this.val$modelANode = nodeRef;
                            this.val$modelBNode = nodeRef2;
                        }

                        public Object execute() throws Exception {
                            DictionaryModelTypeTest.this.nodeService.deleteNode(this.val$modelANode);
                            DictionaryModelTypeTest.this.nodeService.deleteNode(this.val$modelBNode);
                            return null;
                        }
                    });
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new /* invalid duplicate definition of identical inner class */);
        }
    }

    private NodeRef createActiveModel(String contentFile) {
        PropertyMap properties = new PropertyMap(1);
        properties.put((Object)ContentModel.PROP_MODEL_ACTIVE, (Object)true);
        NodeRef modelNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"dictionaryModels"), ContentModel.TYPE_DICTIONARY_MODEL, (Map)properties).getChildRef();
        DictionaryModelTypeTest.assertNotNull((Object)modelNode);
        ContentWriter contentWriter = this.contentService.getWriter(modelNode, ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("text/xml");
        contentWriter.putContent(Thread.currentThread().getContextClassLoader().getResourceAsStream(contentFile));
        return modelNode;
    }
}

