/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed;

import java.util.List;
import org.alfresco.repo.activities.feed.FeedNotifier;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantUtil;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class FeedNotifierJob
implements Job {
    private static final String KEY_FEED_NOTIFIER = "feedNotifier";
    private static final String KEY_TENANT_ADMIN_SERVICE = "tenantAdminService";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobData = context.getJobDetail().getJobDataMap();
        final FeedNotifier feedNotifier = (FeedNotifier)jobData.get((Object)KEY_FEED_NOTIFIER);
        TenantAdminService tenantAdminService = (TenantAdminService)jobData.get((Object)KEY_TENANT_ADMIN_SERVICE);
        Long repeatInterval = null;
        Trigger trigger = context.getTrigger();
        if (trigger instanceof SimpleTrigger) {
            repeatInterval = ((SimpleTrigger)trigger).getRepeatInterval();
        }
        final int repeatIntervalMins = Long.valueOf(repeatInterval == null ? 0L : repeatInterval / 1000L / 60L).intValue();
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                feedNotifier.execute(repeatIntervalMins);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (tenantAdminService != null && tenantAdminService.isEnabled()) {
            List<Tenant> tenants = tenantAdminService.getAllTenants();
            for (Tenant tenant : tenants) {
                TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        feedNotifier.execute(repeatIntervalMins);
                        return null;
                    }
                }, (String)tenant.getTenantDomain());
            }
        }
    }
}

