/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HashPasswordTransactionListener
implements TransactionListener {
    private static Log logger = LogFactory.getLog(HashPasswordTransactionListener.class);
    private final String username;
    private final char[] password;
    private TransactionService transactionService;
    private MutableAuthenticationDao authenticationDao;

    public HashPasswordTransactionListener(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthenticationDao(MutableAuthenticationDao authenticationDao) {
        this.authenticationDao = authenticationDao;
    }

    @Override
    public void flush() {
    }

    @Override
    public void beforeCommit(boolean readOnly) {
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void afterCommit() {
        RetryingTransactionHelper txHelper = this.transactionService.getRetryingTransactionHelper();
        txHelper.setForceWritable(true);
        txHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuthenticationUtil.pushAuthentication();
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Re-hashing password for user: " + HashPasswordTransactionListener.this.username));
                    }
                    HashPasswordTransactionListener.this.authenticationDao.updateUser(HashPasswordTransactionListener.this.username, HashPasswordTransactionListener.this.password);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Password for user '" + HashPasswordTransactionListener.this.username + "' has been re-hashed following login"));
                    }
                    return null;
                }
                finally {
                    AuthenticationUtil.popAuthentication();
                }
            }
        }, false, true);
    }

    @Override
    public void afterRollback() {
    }
}

