/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.TestHelper;
import org.alfresco.util.testing.category.DBTests;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class, DBTests.class})
public class JobLockServiceTest
extends TestCase {
    public static final String NAMESPACE = "http://www.alfresco.org/test/JobLockServiceTest";
    private static final Log logger = LogFactory.getLog(JobLockServiceTest.class);
    private ApplicationContext ctx;
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private JobLockService jobLockService;
    private QName lockA;
    private QName lockAA;
    private QName lockAAA;
    private QName lockAAB;
    private QName lockAAC;
    private QName lockAB;
    private QName lockABA;
    private QName lockABB;
    private QName lockABC;

    public void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.jobLockService = (JobLockService)this.ctx.getBean("jobLockService");
        String testName = this.getName();
        this.lockA = QName.createQName((String)NAMESPACE, (String)("a-" + testName));
        this.lockAA = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".a-" + testName));
        this.lockAAA = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".a-" + testName + ".a-" + testName));
        this.lockAAB = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".a-" + testName + ".b-" + testName));
        this.lockAAC = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".a-" + testName + ".c-" + testName));
        this.lockAB = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".b-" + testName));
        this.lockABA = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".b-" + testName + ".a-" + testName));
        this.lockABB = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".b-" + testName + ".b-" + testName));
        this.lockABC = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".b-" + testName + ".c-" + testName));
    }

    public void testSetUp() {
        JobLockServiceTest.assertNotNull((Object)this.jobLockService);
    }

    public void testSimpleLock() {
        String lockToken = this.jobLockService.getLock(this.lockAAA, 20L);
        this.jobLockService.refreshLock(lockToken, this.lockAAA, 20L);
        this.jobLockService.releaseLock(lockToken, this.lockAAA);
        try {
            this.jobLockService.refreshLock(lockToken, this.lockAAA, 20L);
            JobLockServiceTest.fail((String)"Lock refresh should have failed after release");
        }
        catch (LockAcquisitionException lockAcquisitionException) {}
        lockToken = this.jobLockService.getLock(this.lockAAA, 20L, 5L, 0);
        this.jobLockService.refreshLock(lockToken, this.lockAAA, 20L);
        this.jobLockService.releaseLock(lockToken, this.lockAAA);
        try {
            this.jobLockService.getLock(this.lockAAA, 20L, 5L, -1);
            JobLockServiceTest.fail((String)"getLock should have failed ");
        }
        catch (IllegalArgumentException expected) {
            expected.getMessage().contains("Job lock retry count cannot be negative");
        }
    }

    public void testEnforceTxn() {
        try {
            this.jobLockService.getTransactionalLock(this.lockAAA, 50L);
            JobLockServiceTest.fail((String)"Service did not enforce the presence of a transaction");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public void testLockInReadOnly() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> lockCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                JobLockServiceTest.this.jobLockService.getTransactionalLock(JobLockServiceTest.this.lockAAA, 500L);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)lockCallback, true, true);
    }

    public void testLockReleaseOnCommit() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> lockCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                JobLockServiceTest.this.jobLockService.getTransactionalLock(JobLockServiceTest.this.lockAAA, 5000L);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)lockCallback, true, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> lockCheckCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                JobLockServiceTest.this.jobLockService.getTransactionalLock(JobLockServiceTest.this.lockAAA, 50L);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)lockCheckCallback, true, true);
    }

    public void testLockReleaseOnRollback() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> lockCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                JobLockServiceTest.this.jobLockService.getTransactionalLock(JobLockServiceTest.this.lockAAA, 5000L);
                throw new UnsupportedOperationException("ALERT!");
            }
        };
        try {
            this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)lockCallback, true, true);
            JobLockServiceTest.fail((String)"Expected transaction failure");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        RetryingTransactionHelper.RetryingTransactionCallback<Object> lockCheckCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                JobLockServiceTest.this.jobLockService.getTransactionalLock(JobLockServiceTest.this.lockAAA, 50L);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)lockCheckCallback, true, true);
    }

    public synchronized void testDeadlockPrevention() throws Throwable {
        DeadlockingThread t1 = new DeadlockingThread(new QName[]{this.lockAAA, this.lockAAB});
        DeadlockingThread t2 = new DeadlockingThread(new QName[]{this.lockAAB, this.lockAAA});
        t1.start();
        t2.start();
        t1.incrementNextLock();
        t2.incrementNextLock();
        try {
            ((Object)((Object)this)).wait(2000L);
        }
        catch (InterruptedException interruptedException) {}
        t1.incrementNextLock();
        t2.incrementNextLock();
        try {
            ((Object)((Object)this)).wait(2000L);
        }
        catch (InterruptedException interruptedException) {}
        t1.incrementNextLock();
        t2.incrementNextLock();
        try {
            ((Object)((Object)this)).wait(2000L);
        }
        catch (InterruptedException interruptedException) {}
        if (t1.otherFailure != null) {
            throw t1.otherFailure;
        }
        if (t2.otherFailure != null) {
            throw t2.otherFailure;
        }
        JobLockServiceTest.assertNull((String)("T1 should have succeeded as the ordered locker: " + (Object)((Object)t1.lockFailure)), (Object)((Object)t1.lockFailure));
        JobLockServiceTest.assertNotNull((String)"T2 should have failed as the unordered locker.", (Object)((Object)t2.lockFailure));
    }

    public synchronized void testLockCallbackReleaseInactive() throws Exception {
        QName lockQName = QName.createQName((String)NAMESPACE, (String)this.getName());
        String lockToken = this.jobLockService.getLock(lockQName, 1000L);
        final int[] checked = new int[1];
        final int[] released = new int[1];
        JobLockService.JobLockRefreshCallback callback = new JobLockService.JobLockRefreshCallback(){

            public boolean isActive() {
                checked[0] = checked[0] + 1;
                return false;
            }

            public void lockReleased() {
                released[0] = released[0] + 1;
            }
        };
        this.jobLockService.refreshLock(lockToken, lockQName, 1000L, callback);
        ((Object)((Object)this)).wait(1000L);
        JobLockServiceTest.assertTrue((String)"Expected lockReleased to have been called", (released[0] > 0 ? 1 : 0) != 0);
        try {
            this.jobLockService.getLock(lockQName, 1000L);
        }
        catch (LockAcquisitionException lockAcquisitionException) {
            JobLockServiceTest.fail((String)"Lock should have been released by callback infrastructure");
        }
        int checkedCount = checked[0];
        int releasedCount = released[0];
        ((Object)((Object)this)).wait(2000L);
        JobLockServiceTest.assertEquals((String)"Lock callback timer was not terminated", (int)checkedCount, (int)checked[0]);
        JobLockServiceTest.assertEquals((String)"Lock callback timer was not terminated", (int)releasedCount, (int)released[0]);
    }

    public synchronized void testLockCallbackReleaseSelf() throws Exception {
        Level saveLogLevel = LogManager.getLogger((String)"org.alfresco.repo.lock").getLevel();
        Configurator.setLevel((Logger)LogManager.getLogger((String)"org.alfresco.repo.lock"), (Level)Level.ALL);
        try {
            final QName lockQName = QName.createQName((String)NAMESPACE, (String)this.getName());
            final String lockToken = this.jobLockService.getLock(lockQName, 1000L);
            final int[] checked = new int[1];
            final int[] released = new int[1];
            JobLockService.JobLockRefreshCallback callback = new JobLockService.JobLockRefreshCallback(){

                public boolean isActive() {
                    checked[0] = checked[0] + 1;
                    JobLockServiceTest.this.jobLockService.releaseLock(lockToken, lockQName);
                    return false;
                }

                public void lockReleased() {
                    released[0] = released[0] + 1;
                }
            };
            this.jobLockService.refreshLock(lockToken, lockQName, 1000L, callback);
            ((Object)((Object)this)).wait(1000L);
            JobLockServiceTest.assertFalse((String)"Lock should be optimistically released", (released[0] > 0 ? 1 : 0) != 0);
            try {
                this.jobLockService.getLock(lockQName, 1000L);
            }
            catch (LockAcquisitionException lockAcquisitionException) {
                JobLockServiceTest.fail((String)"Lock should have been released by callback infrastructure");
            }
            int checkedCount = checked[0];
            int releasedCount = released[0];
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("checkedCount=" + checkedCount + ",releasedCount=" + releasedCount));
            }
            ((Object)((Object)this)).wait(10000L);
            JobLockServiceTest.assertEquals((String)"Lock callback timer was not terminated", (int)checkedCount, (int)checked[0]);
            JobLockServiceTest.assertEquals((String)"Lock callback timer was not terminated", (int)releasedCount, (int)released[0]);
        }
        finally {
            Configurator.setLevel((Logger)LogManager.getLogger((String)"org.alfresco.repo.lock"), (Level)saveLogLevel);
        }
    }

    public synchronized void testLockCallbackReleaseTimed() throws Exception {
        QName lockQName = QName.createQName((String)NAMESPACE, (String)this.getName());
        final long lockNow = System.currentTimeMillis();
        String lockToken = this.jobLockService.getLock(lockQName, 1000L);
        final int[] checked = new int[1];
        final int[] released = new int[1];
        JobLockService.JobLockRefreshCallback callback = new JobLockService.JobLockRefreshCallback(){

            public boolean isActive() {
                checked[0] = checked[0] + 1;
                return System.currentTimeMillis() - lockNow <= 3000L;
            }

            public void lockReleased() {
                released[0] = released[0] + 1;
            }
        };
        this.jobLockService.refreshLock(lockToken, lockQName, 1000L, callback);
        ((Object)((Object)this)).wait(2000L);
        JobLockServiceTest.assertTrue((String)("Expected at least 2 active checks; only got " + checked[0]), (checked[0] >= 2 ? 1 : 0) != 0);
        JobLockServiceTest.assertFalse((String)"lockReleased should NOT have been called", (released[0] > 0 ? 1 : 0) != 0);
        try {
            this.jobLockService.getLock(lockQName, 1000L);
            JobLockServiceTest.fail((String)"Lock should still be held");
        }
        catch (LockAcquisitionException lockAcquisitionException) {}
        ((Object)((Object)this)).wait(2000L);
        int checkedCount = checked[0];
        int releasedCount = released[0];
        ((Object)((Object)this)).wait(2000L);
        JobLockServiceTest.assertEquals((String)"Lock callback timer was not terminated", (int)checkedCount, (int)checked[0]);
        JobLockServiceTest.assertEquals((String)"Lock callback timer was not terminated", (int)releasedCount, (int)released[0]);
    }

    public void testGetLockWithCallbackNullLock() {
        this.runGetLockWithCallback(0);
    }

    public void testGetLockWithCallbackNullCallback() {
        this.runGetLockWithCallback(1);
    }

    public void testGetLockWithCallbackShortTTL() {
        this.runGetLockWithCallback(2);
    }

    public void testGetLockWithCallbackLocked() {
        this.runGetLockWithCallback(3);
    }

    public void testGetLockWithCallbackNormal() {
        this.runGetLockWithCallback(4);
    }

    /*
     * Loose catch block
     */
    public void runGetLockWithCallback(int t) {
        block41: {
            String tokenB;
            Level saveLogLevel;
            block44: {
                saveLogLevel = LogManager.getLogger((String)"org.alfresco.repo.lock").getLevel();
                Configurator.setLevel((Logger)LogManager.getLogger((String)"org.alfresco.repo.lock"), (Level)Level.ALL);
                logger.debug((Object)("runGetLockWithCallback " + t + "\n----------------------------------------" + "\n" + Thread.currentThread().getStackTrace()[2].getMethodName() + "\n----------------------------------------"));
                String token = null;
                tokenB = null;
                try {
                    QName lockName = t == 0 ? null : this.lockA;
                    TestCallback callback = t == 1 ? null : new TestCallback();
                    long timeToLive = t == 2 ? 1 : 500;
                    if (t == 3) {
                        long ttlLongerThanDefaultRetry = 2200L;
                        tokenB = this.jobLockService.getLock(this.lockA, ttlLongerThanDefaultRetry);
                    }
                    token = this.jobLockService.getLock(lockName, timeToLive, (JobLockService.JobLockRefreshCallback)callback);
                    if (t < 4) {
                        JobLockServiceTest.fail((String)"expected getLock to fail");
                    }
                    if (callback == null) {
                        throw new IllegalStateException();
                    }
                    TestHelper.waitForMethodToFinish(Duration.of(100L, ChronoUnit.MILLIS), () -> {
                        JobLockServiceTest.assertEquals((boolean)false, (boolean)testCallback.released);
                        JobLockServiceTest.assertEquals((int)0, (int)callback.getIsActiveCount());
                    }, AssertionFailedError.class);
                    TestHelper.waitForMethodToFinish(Duration.of(1L, ChronoUnit.SECONDS), () -> {
                        JobLockServiceTest.assertEquals((boolean)false, (boolean)testCallback.released);
                        JobLockServiceTest.assertEquals((int)1, (int)callback.getIsActiveCount());
                    }, AssertionFailedError.class);
                    callback.isActive = false;
                    TestHelper.waitForMethodToFinish(Duration.of(2L, ChronoUnit.SECONDS), () -> {
                        JobLockServiceTest.assertEquals((boolean)true, (boolean)testCallback.released);
                        JobLockServiceTest.assertEquals((int)2, (int)callback.getIsActiveCount());
                    }, AssertionFailedError.class);
                }
                catch (IllegalArgumentException e) {
                    switch (t) {
                        case 0: {
                            logger.debug((Object)("null lock      => exception as expected: " + e));
                            break;
                        }
                        case 1: {
                            logger.debug((Object)("null callback  => exception as expected: " + e));
                            break;
                        }
                        case 2: {
                            logger.debug((Object)("short ttl      => exception as expected: " + e));
                            break;
                        }
                        default: {
                            JobLockServiceTest.fail((String)("exception not expected: " + e));
                        }
                    }
                    if (token != null) {
                        logger.debug((Object)"token should have been released");
                        if (this.jobLockService.releaseLockVerify(token, this.lockA)) {
                            JobLockServiceTest.fail((String)"token not released");
                        }
                    }
                    if (tokenB != null) {
                        logger.debug((Object)"tokenB should be released");
                        this.jobLockService.releaseLockVerify(tokenB, this.lockA);
                    }
                    try {
                        logger.debug((Object)"lock should have been released so check can acquire");
                        String tokenC = this.jobLockService.getLock(this.lockA, 50L);
                        this.jobLockService.releaseLock(tokenC, this.lockA);
                    }
                    catch (LockAcquisitionException lockAcquisitionException) {
                        JobLockServiceTest.fail((String)"lock not released");
                    }
                    logger.debug((Object)"runGetLockWithCallback\n----------------------------------------");
                    Configurator.setLevel((Logger)LogManager.getLogger((String)"org.alfresco.repo.lock"), (Level)saveLogLevel);
                    break block41;
                }
                catch (LockAcquisitionException e) {
                    block42: {
                        switch (t) {
                            case 3: {
                                logger.debug((Object)("already locked => exception as expected: " + (Object)((Object)e)));
                                break;
                            }
                            default: {
                                JobLockServiceTest.fail((String)("exception not expected: " + (Object)((Object)e)));
                            }
                        }
                        if (token == null) break block42;
                        logger.debug((Object)"token should have been released");
                        if (this.jobLockService.releaseLockVerify(token, this.lockA)) {
                            JobLockServiceTest.fail((String)"token not released");
                        }
                    }
                    if (tokenB != null) {
                        logger.debug((Object)"tokenB should be released");
                        this.jobLockService.releaseLockVerify(tokenB, this.lockA);
                    }
                    try {
                        logger.debug((Object)"lock should have been released so check can acquire");
                        String tokenC = this.jobLockService.getLock(this.lockA, 50L);
                        this.jobLockService.releaseLock(tokenC, this.lockA);
                    }
                    catch (LockAcquisitionException lockAcquisitionException) {
                        JobLockServiceTest.fail((String)"lock not released");
                    }
                    logger.debug((Object)"runGetLockWithCallback\n----------------------------------------");
                    Configurator.setLevel((Logger)LogManager.getLogger((String)"org.alfresco.repo.lock"), (Level)saveLogLevel);
                    break block41;
                }
                catch (Exception e) {
                    block43: {
                        JobLockServiceTest.fail((String)("exception not expected: " + e));
                        if (token == null) break block43;
                        {
                            catch (Throwable throwable) {
                                if (token != null) {
                                    logger.debug((Object)"token should have been released");
                                    if (this.jobLockService.releaseLockVerify(token, this.lockA)) {
                                        JobLockServiceTest.fail((String)"token not released");
                                    }
                                }
                                if (tokenB != null) {
                                    logger.debug((Object)"tokenB should be released");
                                    this.jobLockService.releaseLockVerify(tokenB, this.lockA);
                                }
                                try {
                                    logger.debug((Object)"lock should have been released so check can acquire");
                                    String tokenC = this.jobLockService.getLock(this.lockA, 50L);
                                    this.jobLockService.releaseLock(tokenC, this.lockA);
                                }
                                catch (LockAcquisitionException lockAcquisitionException) {
                                    JobLockServiceTest.fail((String)"lock not released");
                                }
                                logger.debug((Object)"runGetLockWithCallback\n----------------------------------------");
                                Configurator.setLevel((Logger)LogManager.getLogger((String)"org.alfresco.repo.lock"), (Level)saveLogLevel);
                                throw throwable;
                            }
                        }
                        logger.debug((Object)"token should have been released");
                        if (this.jobLockService.releaseLockVerify(token, this.lockA)) {
                            JobLockServiceTest.fail((String)"token not released");
                        }
                    }
                    if (tokenB != null) {
                        logger.debug((Object)"tokenB should be released");
                        this.jobLockService.releaseLockVerify(tokenB, this.lockA);
                    }
                    try {
                        logger.debug((Object)"lock should have been released so check can acquire");
                        String tokenC = this.jobLockService.getLock(this.lockA, 50L);
                        this.jobLockService.releaseLock(tokenC, this.lockA);
                    }
                    catch (LockAcquisitionException lockAcquisitionException) {
                        JobLockServiceTest.fail((String)"lock not released");
                    }
                    logger.debug((Object)"runGetLockWithCallback\n----------------------------------------");
                    Configurator.setLevel((Logger)LogManager.getLogger((String)"org.alfresco.repo.lock"), (Level)saveLogLevel);
                    break block41;
                }
                if (token == null) break block44;
                logger.debug((Object)"token should have been released");
                if (this.jobLockService.releaseLockVerify(token, this.lockA)) {
                    JobLockServiceTest.fail((String)"token not released");
                }
            }
            if (tokenB != null) {
                logger.debug((Object)"tokenB should be released");
                this.jobLockService.releaseLockVerify(tokenB, this.lockA);
            }
            try {
                logger.debug((Object)"lock should have been released so check can acquire");
                String tokenC = this.jobLockService.getLock(this.lockA, 50L);
                this.jobLockService.releaseLock(tokenC, this.lockA);
            }
            catch (LockAcquisitionException lockAcquisitionException) {
                JobLockServiceTest.fail((String)"lock not released");
            }
            logger.debug((Object)"runGetLockWithCallback\n----------------------------------------");
            Configurator.setLevel((Logger)LogManager.getLogger((String)"org.alfresco.repo.lock"), (Level)saveLogLevel);
        }
    }

    private class DeadlockingThread
    extends Thread {
        private final QName[] lockQNames;
        private volatile int nextLock;
        private LockAcquisitionException lockFailure;
        private Throwable otherFailure;

        private DeadlockingThread(QName ... lockQNames) {
            super("DeadlockingThread");
            this.nextLock = -1;
            this.lockQNames = lockQNames;
            this.setDaemon(true);
        }

        private void incrementNextLock() {
            ++this.nextLock;
        }

        @Override
        public void run() {
            RetryingTransactionHelper.RetryingTransactionCallback<Object> runCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public synchronized Object execute() throws Throwable {
                    int currentLock = -1;
                    while (currentLock < DeadlockingThread.this.lockQNames.length - 1) {
                        if (DeadlockingThread.this.nextLock > currentLock) {
                            JobLockServiceTest.this.jobLockService.getTransactionalLock(DeadlockingThread.this.lockQNames[++currentLock], 5000L);
                            continue;
                        }
                        try {
                            this.wait(20L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    return null;
                }
            };
            try {
                JobLockServiceTest.this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)runCallback, true);
            }
            catch (LockAcquisitionException e) {
                this.lockFailure = e;
            }
            catch (Throwable e) {
                this.otherFailure = e;
            }
        }
    }

    private class TestCallback
    implements JobLockService.JobLockRefreshCallback {
        public volatile AtomicInteger isActiveCounter = new AtomicInteger();
        public volatile boolean released;
        public volatile boolean isActive = true;

        private TestCallback() {
        }

        public boolean isActive() {
            int currentIsActiveCount = this.isActiveCounter.incrementAndGet();
            logger.debug((Object)("TestCallback.isActive => " + this.isActive + " (" + currentIsActiveCount + ")"));
            return this.isActive;
        }

        public void lockReleased() {
            logger.debug((Object)"TestCallback.lockReleased");
            this.released = true;
        }

        public int getIsActiveCount() {
            return this.isActiveCounter.get();
        }
    }
}

