/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.regex.Pattern;
import org.alfresco.repo.admin.SysAdminParams;

public class UrlUtil {
    public static final Pattern PATTERN = Pattern.compile("\\$\\{shareUrl\\}");
    public static final Pattern REPO_PATTERN = Pattern.compile("\\$\\{alfrescoUrl\\}");

    public static String getAlfrescoUrl(SysAdminParams sysAdminParams) {
        return UrlUtil.buildUrl(sysAdminParams.getAlfrescoProtocol(), sysAdminParams.getAlfrescoHost(), sysAdminParams.getAlfrescoPort(), sysAdminParams.getAlfrescoContext());
    }

    public static String getShareUrl(SysAdminParams sysAdminParams) {
        return UrlUtil.buildUrl(sysAdminParams.getShareProtocol(), sysAdminParams.getShareHost(), sysAdminParams.getSharePort(), sysAdminParams.getShareContext());
    }

    public static String getApiExplorerUrl(SysAdminParams sysAdminParams) {
        return UrlUtil.getApiExplorerUrl(sysAdminParams, "", "");
    }

    public static String getApiExplorerUrl(SysAdminParams sysAdminParams, String requestURL, String requestURI) {
        if (!sysAdminParams.getApiExplorerUrl().isEmpty()) {
            return sysAdminParams.getApiExplorerUrl();
        }
        if (!requestURI.isEmpty() && !requestURL.isEmpty()) {
            return requestURL.replace(requestURI, "/api-explorer");
        }
        return "";
    }

    public static String replaceShareUrlPlaceholder(String value, SysAdminParams sysAdminParams) {
        if (value != null) {
            return PATTERN.matcher(value).replaceAll(UrlUtil.getShareUrl(sysAdminParams));
        }
        return value;
    }

    public static String replaceAlfrescoUrlPlaceholder(String value, SysAdminParams sysAdminParams) {
        if (value != null) {
            return REPO_PATTERN.matcher(value).replaceAll(UrlUtil.getAlfrescoUrl(sysAdminParams));
        }
        return value;
    }

    protected static String buildUrl(String protocol, String host, int port, String context) {
        StringBuilder url = new StringBuilder();
        url.append(protocol);
        url.append("://");
        url.append(host);
        if (!("http".equals(protocol) && port == 80 || "https".equals(protocol) && port == 443)) {
            url.append(':');
            url.append(port);
        }
        url.append('/');
        url.append(context);
        return url.toString();
    }
}

