/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.service.cmr.repository.TransformationOptionPair;
import org.alfresco.util.EqualsHelper;

@AlfrescoPublicApi
@Deprecated
public class TransformationOptionLimits
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Deprecated
    public static final String OPT_TIMEOUT_MS = "timeoutMs";
    @Deprecated
    public static final String OPT_READ_LIMIT_TIME_MS = "readLimitTimeMs";
    @Deprecated
    public static final String OPT_MAX_SOURCE_SIZE_K_BYTES = "maxSourceSizeKBytes";
    @Deprecated
    public static final String OPT_READ_LIMIT_K_BYTES = "readLimitKBytes";
    @Deprecated
    public static final String OPT_MAX_PAGES = "maxPages";
    @Deprecated
    public static final String OPT_PAGE_LIMIT = "pageLimit";
    public static final String TIME_MESSAGE = "Both timeoutMs and readLimitTimeMs should not be set.";
    public static final String KBYTES_MESSAGE = "Both maxSourceSizeKBytes and readLimitKBytes should not be set.";
    public static final String PAGES_MESSAGE = "Both maxPages and pageLimit should not be set.";
    private TransformationOptionPair time = new TransformationOptionPair();
    private TransformationOptionPair kbytes = new TransformationOptionPair();
    private TransformationOptionPair pages = new TransformationOptionPair();

    public TransformationOptionLimits() {
        this.time = new TransformationOptionPair();
        this.kbytes = new TransformationOptionPair();
        this.pages = new TransformationOptionPair();
    }

    private TransformationOptionLimits(TransformationOptionLimits a, TransformationOptionLimits b, boolean lower) {
        if (lower) {
            this.time = a.time.combine(b.time);
            this.kbytes = a.kbytes.combine(b.kbytes);
            this.pages = a.pages.combine(b.pages);
        } else {
            this.time = a.time.combineUpper(b.time);
            this.kbytes = a.kbytes.combineUpper(b.kbytes);
            this.pages = a.pages.combineUpper(b.pages);
        }
    }

    public void defaultTo(TransformationOptionLimits limits) {
        this.time.defaultTo(limits.time);
        this.kbytes.defaultTo(limits.kbytes);
        this.pages.defaultTo(limits.pages);
    }

    public TransformationOptionPair getTimePair() {
        return this.time;
    }

    public long getTimeoutMs() {
        return this.time.getMax();
    }

    public void setTimeoutMs(long timeoutMs) {
        this.time.setMax(timeoutMs, TIME_MESSAGE);
    }

    public long getReadLimitTimeMs() {
        return this.time.getLimit();
    }

    public void setReadLimitTimeMs(long readLimitTimeMs) {
        this.time.setLimit(readLimitTimeMs, TIME_MESSAGE);
    }

    public TransformationOptionPair getKBytesPair() {
        return this.kbytes;
    }

    public long getMaxSourceSizeKBytes() {
        return this.kbytes.getMax();
    }

    public void setMaxSourceSizeKBytes(long maxSourceSizeKBytes) {
        this.kbytes.setMax(maxSourceSizeKBytes, KBYTES_MESSAGE);
    }

    public long getReadLimitKBytes() {
        return this.kbytes.getLimit();
    }

    public void setReadLimitKBytes(long readLimitKBytes) {
        this.kbytes.setLimit(readLimitKBytes, KBYTES_MESSAGE);
    }

    public TransformationOptionPair getPagesPair() {
        return this.pages;
    }

    public int getMaxPages() {
        return (int)this.pages.getMax();
    }

    public void setMaxPages(int maxPages) {
        this.pages.setMax(maxPages, PAGES_MESSAGE);
    }

    public int getPageLimit() {
        return (int)this.pages.getLimit();
    }

    public void setPageLimit(int pageLimit) {
        this.pages.setLimit(pageLimit, PAGES_MESSAGE);
    }

    public boolean supported() {
        return this.time.supported() && this.kbytes.supported() && this.pages.supported();
    }

    public Map<String, Object> toMap(Map<String, Object> optionsMap) {
        this.time.toMap(optionsMap, OPT_TIMEOUT_MS, OPT_READ_LIMIT_TIME_MS);
        this.kbytes.toMap(optionsMap, OPT_MAX_SOURCE_SIZE_K_BYTES, OPT_READ_LIMIT_K_BYTES);
        this.pages.toMap(optionsMap, OPT_MAX_PAGES, OPT_PAGE_LIMIT);
        return optionsMap;
    }

    public static Map<String, Object> removeFromMap(Map<String, Object> optionsMap) {
        optionsMap.remove(OPT_TIMEOUT_MS);
        optionsMap.remove(OPT_READ_LIMIT_TIME_MS);
        optionsMap.remove(OPT_MAX_SOURCE_SIZE_K_BYTES);
        optionsMap.remove(OPT_READ_LIMIT_K_BYTES);
        optionsMap.remove(OPT_MAX_PAGES);
        optionsMap.remove(OPT_PAGE_LIMIT);
        return optionsMap;
    }

    public void set(Map<String, Object> optionsMap) {
        this.time.set(optionsMap, OPT_TIMEOUT_MS, OPT_READ_LIMIT_TIME_MS, TIME_MESSAGE);
        this.kbytes.set(optionsMap, OPT_MAX_SOURCE_SIZE_K_BYTES, OPT_READ_LIMIT_K_BYTES, KBYTES_MESSAGE);
        this.pages.set(optionsMap, OPT_MAX_PAGES, OPT_PAGE_LIMIT, PAGES_MESSAGE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        this.time.append(sb, OPT_TIMEOUT_MS, OPT_READ_LIMIT_TIME_MS);
        this.kbytes.append(sb, OPT_MAX_SOURCE_SIZE_K_BYTES, OPT_READ_LIMIT_K_BYTES);
        this.pages.append(sb, OPT_MAX_PAGES, OPT_PAGE_LIMIT);
        sb.append("}");
        return sb.length() == 2 ? "no limits" : sb.toString();
    }

    public TransformationOptionLimits combine(TransformationOptionLimits that) {
        return this.combine(that, true);
    }

    public TransformationOptionLimits combineUpper(TransformationOptionLimits that) {
        return this.combine(that, false);
    }

    private TransformationOptionLimits combine(TransformationOptionLimits that, boolean lower) {
        return new TransformationOptionLimits(this, that, lower){
            private static final long serialVersionUID = 1L;

            @Override
            public void setTimeoutMs(long timeoutMs) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setReadLimitTimeMs(long readLimitTimeMs) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setMaxSourceSizeKBytes(long maxSourceSizeKBytes) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setReadLimitKBytes(long readLimitKBytes) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setMaxPages(int maxPages) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setPageLimit(int pageLimit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Map<String, Object> optionsMap) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int hashCode() {
        int hashCode = 37 * this.time.hashCode();
        hashCode += 37 * this.kbytes.hashCode();
        return hashCode += 37 * this.pages.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TransformationOptionLimits) {
            TransformationOptionLimits that = (TransformationOptionLimits)obj;
            return EqualsHelper.nullSafeEquals((Object)this.time, (Object)that.time) && EqualsHelper.nullSafeEquals((Object)this.kbytes, (Object)that.kbytes) && EqualsHelper.nullSafeEquals((Object)this.pages, (Object)that.pages);
        }
        return false;
    }

    /* synthetic */ TransformationOptionLimits(TransformationOptionLimits transformationOptionLimits, TransformationOptionLimits transformationOptionLimits2, boolean bl, TransformationOptionLimits transformationOptionLimits3) {
        this(transformationOptionLimits, transformationOptionLimits2, bl);
    }
}

