/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.util.Properties;
import org.alfresco.repo.cache.AbstractCacheFactory;
import org.alfresco.repo.cache.SimpleCache;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractCacheFactoryTest {
    private AbstractCacheFactory<Integer, String> cacheFactory;
    private Properties properties;

    @Before
    public void setUp() throws Exception {
        this.cacheFactory = new CacheFactoryTestImpl();
        this.properties = new Properties();
        this.cacheFactory.setProperties(this.properties);
    }

    @Test
    public void nullPropertyYieldsDefault() {
        Assert.assertNull((Object)this.cacheFactory.getProperty("the.cache.name", "noProperty", null));
        Assert.assertEquals((Object)"non-empty-default", (Object)this.cacheFactory.getProperty("the.cache.name", "noProperty", "non-empty-default"));
    }

    @Test
    public void emptyPropertyYieldsDefault() {
        this.properties.setProperty("the.cache.name.emptyProperty", "");
        Assert.assertEquals((Object)"", (Object)this.cacheFactory.getProperty("the.cache.name", "emptyProperty", ""));
        this.properties.setProperty("the.cache.name.emptyProperty", "");
        Assert.assertEquals(null, (Object)this.cacheFactory.getProperty("the.cache.name", "emptyProperty", null));
        this.properties.setProperty("the.cache.name.emptyProperty", "");
        Assert.assertEquals((Object)"non-empty-default", (Object)this.cacheFactory.getProperty("the.cache.name", "emptyProperty", "non-empty-default"));
        this.properties.setProperty("the.cache.name.emptyProperty", "  \t  ");
        Assert.assertEquals((Object)"default", (Object)this.cacheFactory.getProperty("the.cache.name", "emptyProperty", "default"));
    }

    @Test
    public void nonEmptyPropertyIsReturned() {
        this.properties.setProperty("the.cache.name.nonEmpty", "this has a non-empty value");
        Assert.assertEquals((Object)"this has a non-empty value", (Object)this.cacheFactory.getProperty("the.cache.name", "nonEmpty", "default"));
    }

    @Test
    public void nonEmptyPropertyIsTrimmedOfWhitespace() {
        this.properties.setProperty("the.cache.name.nonEmpty", "   \t  value    \t");
        Assert.assertEquals((Object)"value", (Object)this.cacheFactory.getProperty("the.cache.name", "nonEmpty", "default"));
    }

    private static class CacheFactoryTestImpl
    extends AbstractCacheFactory<Integer, String> {
        private CacheFactoryTestImpl() {
        }

        public SimpleCache createCache(String cacheName) {
            return null;
        }
    }
}

