/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.schedule;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cleaner {
    private static final Logger LOGGER = LoggerFactory.getLogger(Cleaner.class);
    private final NodeService nodeService;
    private final TransactionService transactionService;
    private static final String ARCHIVE_STORE_URL = "archive://SpacesStore";
    private final int deleteBatchCount;
    private List<NodeRef> nodesToClean;
    private int numErrors;
    private static final int REMOVAL_WAIT_TIME_MS = 5000;

    public Cleaner(NodeService nodeService, TransactionService transactionService, int deleteBatchCount) {
        this.nodeService = nodeService;
        this.transactionService = transactionService;
        this.deleteBatchCount = deleteBatchCount;
    }

    private int deleteNodes(List<NodeRef> nodes) {
        AtomicInteger deletedNodes = new AtomicInteger();
        for (NodeRef nodeRef : nodes) {
            AuthenticationUtil.runAsSystem(() -> {
                RetryingTransactionHelper.RetryingTransactionCallback txnWork = () -> {
                    try {
                        this.nodeService.deleteNode(nodeRef);
                    }
                    catch (InvalidNodeRefException invalidNodeRefException) {
                        ++this.numErrors;
                    }
                    deletedNodes.getAndIncrement();
                    Thread.sleep(5000L);
                    return null;
                };
                return (Void)this.transactionService.getRetryingTransactionHelper().doInTransaction(txnWork, false, true);
            });
        }
        return deletedNodes.get();
    }

    private List<NodeRef> getBatchToDelete() {
        return this.getChildAssocs().stream().map(ChildAssociationRef::getChildRef).collect(Collectors.toList());
    }

    private List<ChildAssociationRef> getChildAssocs() {
        StoreRef archiveStore = new StoreRef(ARCHIVE_STORE_URL);
        NodeRef archiveRoot = this.nodeService.getRootNode(archiveStore);
        return this.nodeService.getChildAssocs(archiveRoot, (QNamePattern)ContentModel.ASSOC_CHILDREN, RegexQNamePattern.MATCH_ALL, this.deleteBatchCount, false);
    }

    public void clean() {
        LOGGER.info("Running TestCleaner");
        AuthenticationUtil.runAsSystem(() -> {
            RetryingTransactionHelper.RetryingTransactionCallback txnWork = () -> {
                this.nodesToClean = this.getBatchToDelete();
                LOGGER.info(String.format("Number of nodes to delete: %s", this.nodesToClean.size()));
                return null;
            };
            return (Void)this.transactionService.getRetryingTransactionHelper().doInTransaction(txnWork, true, true);
        });
        int deletedNodes = this.deleteNodes(this.nodesToClean);
        LOGGER.info("TestCleaner finished. Number of deleted nodes: {}", (Object)deletedNodes);
    }

    public boolean hasErrors() {
        return this.numErrors > 0;
    }
}

