/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.propval;

import org.alfresco.repo.domain.CrcHelper;
import org.alfresco.util.Pair;

public class PropertyStringQueryEntity {
    private final Short persistedType;
    private final Long actualTypeId;
    private final String stringValue;
    private final String stringEndLower;
    private final Long stringCrc;

    public PropertyStringQueryEntity(Short persistedType, Long actualTypeId, String value) {
        this.persistedType = persistedType;
        this.actualTypeId = actualTypeId;
        this.stringValue = value;
        Pair<String, Long> crcPair = CrcHelper.getStringCrcPair(value, 16, false, true);
        this.stringEndLower = (String)crcPair.getFirst();
        this.stringCrc = (Long)crcPair.getSecond();
    }

    public Short getPersistedType() {
        return this.persistedType;
    }

    public Long getActualTypeId() {
        return this.actualTypeId;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String getStringEndLower() {
        return this.stringEndLower;
    }

    public Long getStringCrc() {
        return this.stringCrc;
    }
}

