/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.action.executer.ContentMetadataEmbedder;
import org.alfresco.repo.action.executer.ContentMetadataExtracter;
import org.alfresco.repo.content.metadata.AsynchronousExtractor;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracterRegistry;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.content.transform.UnsupportedTransformationException;
import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.repo.rendition2.RenditionDefinitionRegistry2Impl;
import org.alfresco.repo.rendition2.RenditionService2;
import org.alfresco.repo.rendition2.RenditionService2Impl;
import org.alfresco.repo.rendition2.TransformClient;
import org.alfresco.repo.search.impl.noindex.NoIndexCategoryServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.tagging.TaggingServiceImpl;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.transform.registry.TransformServiceRegistry;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={BaseSpringTestsCategory.class})
public class AsynchronousExtractorTest
extends BaseSpringTest {
    private static final String ID = GUID.generate();
    private static final String AFTER_CALLING_EXECUTE = "after calling execute";
    private static final String AFTER_THE_TRANSFORM = "after the transform";
    private static final Integer UNCHANGED_HASHCODE = null;
    private static final Integer CHANGED_HASHCODE = 1234;
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy");
    private static final ExecutorService executorService = Executors.newCachedThreadPool();
    private NodeService nodeService;
    private NodeService publicNodeService;
    private ContentService contentService;
    private DictionaryService dictionaryService;
    private MimetypeService mimetypeService;
    private MetadataExtracterRegistry metadataExtracterRegistry;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private AsynchronousExtractor asynchronousExtractor;
    private NamespacePrefixResolver namespacePrefixResolver;
    private TransformerDebug transformerDebug;
    private TransactionService transactionService;
    private TransformServiceRegistry transformServiceRegistry;
    private RenditionDefinitionRegistry2Impl renditionDefinitionRegistry2;
    private TaggingServiceImpl taggingService;
    private ContentMetadataExtracter contentMetadataExtracter;
    private ContentMetadataEmbedder contentMetadataEmbedder;
    private RenditionService2Impl renditionService2;
    private TransformClient transformClient;
    private CategoryService categoryService;
    private MockCategoryService mockCategoryService;
    private long origSize;
    private Map<QName, Serializable> origProperties;
    private Map<QName, Serializable> expectedProperties;
    private Map<QName, Serializable> properties;
    private Map<String, String> transformOptionsPassedToTEngine;

    @Before
    public void before() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.publicNodeService = (NodeService)this.applicationContext.getBean("NodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.dictionaryService = (DictionaryService)this.applicationContext.getBean("dictionaryService");
        this.mimetypeService = (MimetypeService)this.applicationContext.getBean("mimetypeService");
        this.namespacePrefixResolver = (NamespacePrefixResolver)this.applicationContext.getBean("namespaceService");
        this.transformerDebug = (TransformerDebug)this.applicationContext.getBean("transformerDebug");
        this.renditionService2 = (RenditionService2Impl)this.applicationContext.getBean("renditionService2");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionService");
        this.transformServiceRegistry = (TransformServiceRegistry)this.applicationContext.getBean("transformServiceRegistry");
        this.renditionDefinitionRegistry2 = (RenditionDefinitionRegistry2Impl)this.applicationContext.getBean("renditionDefinitionRegistry2");
        this.taggingService = (TaggingServiceImpl)this.applicationContext.getBean("taggingService");
        this.transformClient = (TransformClient)this.applicationContext.getBean("transformClient");
        this.asynchronousExtractor = (AsynchronousExtractor)this.applicationContext.getBean("extractor.Asynchronous");
        this.categoryService = (CategoryService)this.applicationContext.getBean("CategoryService");
        this.metadataExtracterRegistry = new MetadataExtracterRegistry();
        this.contentMetadataExtracter = new ContentMetadataExtracter();
        this.contentMetadataExtracter.setNodeService(this.nodeService);
        this.contentMetadataExtracter.setContentService(this.contentService);
        this.contentMetadataExtracter.setDictionaryService(this.dictionaryService);
        this.contentMetadataExtracter.setMetadataExtracterRegistry(this.metadataExtracterRegistry);
        this.contentMetadataExtracter.setTaggingService((TaggingService)this.taggingService);
        this.contentMetadataExtracter.setApplicableTypes(new String[]{ContentModel.TYPE_CONTENT.toString()});
        this.contentMetadataExtracter.setCarryAspectProperties(true);
        this.contentMetadataExtracter.setEnableStringTagging(true);
        this.contentMetadataEmbedder = new ContentMetadataEmbedder();
        this.contentMetadataEmbedder.setNodeService(this.nodeService);
        this.contentMetadataEmbedder.setContentService(this.contentService);
        this.contentMetadataEmbedder.setMetadataExtracterRegistry(this.metadataExtracterRegistry);
        this.contentMetadataEmbedder.setApplicableTypes(new String[]{ContentModel.TYPE_CONTENT.toString()});
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationComponent authenticationComponent = (AuthenticationComponent)AsynchronousExtractorTest.this.applicationContext.getBean("authenticationComponent");
                authenticationComponent.setSystemUserAsCurrentUser();
                AsynchronousExtractorTest.this.testStoreRef = AsynchronousExtractorTest.this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
                AsynchronousExtractorTest.this.rootNodeRef = AsynchronousExtractorTest.this.nodeService.getRootNode(AsynchronousExtractorTest.this.testStoreRef);
                AsynchronousExtractorTest.this.nodeRef = AsynchronousExtractorTest.this.nodeService.createNode(AsynchronousExtractorTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
                authenticationComponent.setSystemUserAsCurrentUser();
                ContentWriter cw = AsynchronousExtractorTest.this.contentService.getWriter(AsynchronousExtractorTest.this.nodeRef, ContentModel.PROP_CONTENT, true);
                cw.setMimetype("application/pdf");
                cw.putContent(AbstractContentTransformerTest.loadQuickTestFile("pdf"));
                AsynchronousExtractorTest.this.origProperties = AsynchronousExtractorTest.this.nodeService.getProperties(AsynchronousExtractorTest.this.nodeRef);
                AsynchronousExtractorTest.this.nodeService.setProperties(AsynchronousExtractorTest.this.nodeRef, AsynchronousExtractorTest.this.origProperties);
                AsynchronousExtractorTest.this.origProperties = new HashMap(AsynchronousExtractorTest.this.origProperties);
                AsynchronousExtractorTest.this.expectedProperties = new HashMap(AsynchronousExtractorTest.this.origProperties);
                AsynchronousExtractorTest.this.origSize = AsynchronousExtractorTest.this.getSize(AsynchronousExtractorTest.this.nodeRef);
                AsynchronousExtractorTest.this.mockCategoryService = new MockCategoryService(AsynchronousExtractorTest.this.nodeService, AsynchronousExtractorTest.this.publicNodeService);
                AsynchronousExtractorTest.this.taggingService.setCategoryService((CategoryService)AsynchronousExtractorTest.this.mockCategoryService);
                return null;
            }
        });
    }

    @After
    public void after() throws Exception {
        this.renditionService2.setTransformClient(this.transformClient);
        this.renditionService2.setAsynchronousExtractor(this.asynchronousExtractor);
        this.taggingService.setCategoryService(this.categoryService);
    }

    private void assertAsyncMetadataExecute(ActionExecuterAbstractBase executor, String mockResult, Integer changedHashcode, long expectedSize, Map<QName, Serializable> expectedProperties, MetadataExtracter.OverwritePolicy policy, QName ... ignoreProperties) throws Exception {
        TestAsynchronousExtractor extractor = new TestAsynchronousExtractor(mockResult, changedHashcode, policy);
        extractor.setEnableStringTagging(true);
        this.executeAction(executor, extractor);
        this.assertContentSize(this.nodeRef, this.origSize, AFTER_CALLING_EXECUTE);
        this.assertProperties(this.nodeRef, this.origProperties, AFTER_CALLING_EXECUTE, ignoreProperties);
        extractor.wait(-1, 10000);
        this.assertContentSize(this.nodeRef, expectedSize, AFTER_THE_TRANSFORM);
        this.assertProperties(this.nodeRef, expectedProperties, AFTER_THE_TRANSFORM, ignoreProperties);
    }

    private void executeAction(ActionExecuterAbstractBase extractor, TestAsynchronousExtractor asynchronousExtractor) throws SystemException, NotSupportedException, HeuristicRollbackException, HeuristicMixedException, RollbackException {
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        ActionImpl action = new ActionImpl(null, ID, "set-property-value", null);
        extractor.execute((Action)action, this.nodeRef);
        txn.commit();
    }

    void assertContentSize(NodeRef nodeRef, long expectSize, String state) {
        long size = this.getSize(nodeRef);
        if (expectSize == this.origSize) {
            AsynchronousExtractorTest.assertEquals((String)("The content should remain unchanged " + state), (long)this.origSize, (long)size);
        } else {
            AsynchronousExtractorTest.assertEquals((String)("The content should have changed " + state), (long)expectSize, (long)size);
        }
    }

    private long getSize(NodeRef nodeRef) {
        ContentReader reader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        return reader.getSize();
    }

    private void assertProperties(NodeRef nodeRef, Map<QName, Serializable> expectProperties, String state, QName[] ignoreProperties) {
        this.properties = this.nodeService.getProperties(nodeRef);
        StringJoiner sj = new StringJoiner("\n");
        ArrayList<QName> ignoreKeys = new ArrayList<QName>(Arrays.asList(ContentModel.PROP_MODIFIED, ContentModel.PROP_MODIFIER, ContentModel.PROP_CONTENT, ContentModel.PROP_CREATED, ContentModel.PROP_CREATOR));
        ignoreKeys.addAll(Arrays.asList(ignoreProperties));
        for (Map.Entry<QName, Serializable> entry : expectProperties.entrySet()) {
            QName k = entry.getKey();
            Serializable v = entry.getValue();
            Serializable actual = this.properties.get(k);
            if (ignoreKeys.contains(k) || v.equals(actual)) continue;
            sj.add(k + "\n  Expected: " + v + "\n       Was: " + actual);
        }
        for (QName k : this.properties.keySet()) {
            Serializable actual = this.properties.get(k);
            if (ignoreKeys.contains(k) || expectProperties.containsKey(k)) continue;
            sj.add(k + "\n  Expected: null\n       Was: " + actual);
        }
        if (sj.length() != 0) {
            if (expectProperties.equals(this.origProperties)) {
                AsynchronousExtractorTest.fail((String)("The properties should remain unchanged " + state + "\n" + sj));
            } else {
                AsynchronousExtractorTest.fail((String)("The properties should have changed " + state + "\n" + sj));
            }
        }
    }

    @Test
    public void testExtractHtml() throws Exception {
        this.expectedProperties.put(QName.createQName((String)"cm:author", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"Nevin Nollop"));
        this.expectedProperties.put(QName.createQName((String)"cm:description", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"Gym class featuring a brown fox and lazy dog"));
        this.expectedProperties.put(QName.createQName((String)"cm:title", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"The quick brown fox jumps over the lazy dog"));
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataExtracter, "quick/quick.html_metadata.json", UNCHANGED_HASHCODE, this.origSize, this.expectedProperties, MetadataExtracter.OverwritePolicy.PRAGMATIC, new QName[0]);
    }

    @Test
    public void testExtractNodeDeleted() throws Exception {
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataExtracter, "quick/quick.html_metadata.json", -1, this.origSize, this.origProperties, MetadataExtracter.OverwritePolicy.PRAGMATIC, new QName[0]);
    }

    @Test
    public void testExtractContentChanged() throws Exception {
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataExtracter, "quick/quick.html_metadata.json", CHANGED_HASHCODE, this.origSize, this.origProperties, MetadataExtracter.OverwritePolicy.PRAGMATIC, new QName[0]);
    }

    @Test
    public void testExtractTransformFailure() throws Exception {
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataExtracter, null, UNCHANGED_HASHCODE, this.origSize, this.origProperties, MetadataExtracter.OverwritePolicy.PRAGMATIC, new QName[0]);
    }

    @Test
    public void testExtractTransformCorrupt() throws Exception {
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataExtracter, "quick.html", UNCHANGED_HASHCODE, this.origSize, this.origProperties, MetadataExtracter.OverwritePolicy.PRAGMATIC, new QName[0]);
    }

    @Test
    public void testUnknownNamespaceInResponse() throws Exception {
        this.expectedProperties.put(QName.createQName((String)"cm:author", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"Used"));
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataExtracter, "quick/unknown_namespace_metadata.json", UNCHANGED_HASHCODE, this.origSize, this.expectedProperties, MetadataExtracter.OverwritePolicy.PRAGMATIC, new QName[0]);
    }

    @Test
    public void testExtractMsg() throws Exception {
        this.expectedProperties.put(QName.createQName((String)"cm:addressee", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"mark.rogers@alfresco.com"));
        this.expectedProperties.put(QName.createQName((String)"cm:description", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"This is a quick test"));
        this.expectedProperties.put(QName.createQName((String)"cm:addressees", (NamespacePrefixResolver)this.namespacePrefixResolver), new ArrayList<String>(Arrays.asList("mark.rogers@alfresco.com", "speedy@quick.com", "mrquick@nowhere.com")));
        this.expectedProperties.put(QName.createQName((String)"cm:sentdate", (NamespacePrefixResolver)this.namespacePrefixResolver), SIMPLE_DATE_FORMAT.parse("Fri Jan 18 13:44:20 GMT 2013"));
        this.expectedProperties.put(QName.createQName((String)"cm:subjectline", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"This is a quick test"));
        this.expectedProperties.put(QName.createQName((String)"cm:author", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"Mark Rogers"));
        this.expectedProperties.put(QName.createQName((String)"cm:originator", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"Mark Rogers"));
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataExtracter, "quick/quick.msg_metadata.json", UNCHANGED_HASHCODE, this.origSize, this.expectedProperties, MetadataExtracter.OverwritePolicy.PRAGMATIC, new QName[0]);
        this.properties.get(QName.createQName((String)"cm:sentdate", (NamespacePrefixResolver)this.namespacePrefixResolver));
    }

    @Test
    public void testExtractEml() throws Exception {
        this.expectedProperties.put(QName.createQName((String)"cm:addressee", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"Nevin Nollop <nevin.nollop@gmail.com>"));
        this.expectedProperties.put(QName.createQName((String)"cm:description", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"The quick brown fox jumps over the lazy dog"));
        this.expectedProperties.put(QName.createQName((String)"cm:addressees", (NamespacePrefixResolver)this.namespacePrefixResolver), new ArrayList<String>(Arrays.asList("Nevin Nollop <nevinn@alfresco.com>")));
        this.expectedProperties.put(QName.createQName((String)"imap:dateSent", (NamespacePrefixResolver)this.namespacePrefixResolver), SIMPLE_DATE_FORMAT.parse("Fri Jun 04 13:23:22 BST 2004"));
        this.expectedProperties.put(QName.createQName((String)"imap:messageTo", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"Nevin Nollop <nevin.nollop@gmail.com>"));
        this.expectedProperties.put(QName.createQName((String)"imap:messageId", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"<20040604122322.GV1905@phoenix.home>"));
        this.expectedProperties.put(QName.createQName((String)"cm:title", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"The quick brown fox jumps over the lazy dog"));
        this.expectedProperties.put(QName.createQName((String)"imap:messageSubject", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"The quick brown fox jumps over the lazy dog"));
        this.expectedProperties.put(QName.createQName((String)"imap:messageCc", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"Nevin Nollop <nevinn@alfresco.com>"));
        this.expectedProperties.put(QName.createQName((String)"cm:sentdate", (NamespacePrefixResolver)this.namespacePrefixResolver), SIMPLE_DATE_FORMAT.parse("Fri Jun 04 13:23:22 BST 2004"));
        this.expectedProperties.put(QName.createQName((String)"cm:subjectline", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"The quick brown fox jumps over the lazy dog"));
        this.expectedProperties.put(QName.createQName((String)"imap:messageFrom", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"Nevin Nollop <nevin.nollop@alfresco.com>"));
        this.expectedProperties.put(QName.createQName((String)"cm:originator", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"Nevin Nollop <nevin.nollop@alfresco.com>"));
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataExtracter, "quick/quick.eml_metadata.json", UNCHANGED_HASHCODE, this.origSize, this.expectedProperties, MetadataExtracter.OverwritePolicy.PRAGMATIC, QName.createQName((String)"cm:author", (NamespacePrefixResolver)this.namespacePrefixResolver));
    }

    @Test
    public void testEmbed() throws Exception {
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("quick/quick.html");
        AsynchronousExtractorTest.assertNotNull((String)"File not found", (Object)resource);
        File file = new File(resource.toURI());
        long fileSize = file.length();
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataEmbedder, "quick/quick.html", UNCHANGED_HASHCODE, fileSize, this.expectedProperties, MetadataExtracter.OverwritePolicy.PRAGMATIC, new QName[0]);
        String metadata = this.transformOptionsPassedToTEngine.get("metadata");
        System.err.println("METADATA=" + metadata);
        AsynchronousExtractorTest.assertTrue((String)"System properties were not set: simple value", (boolean)metadata.contains("\"{http://www.alfresco.org/model/content/1.0}creator\":\"System\""));
        int i = metadata.indexOf("\"{http://www.alfresco.org/model/content/1.0}title\":[");
        AsynchronousExtractorTest.assertTrue((String)("The title is missing: " + metadata), (i > 0 ? 1 : 0) != 0);
        int j = metadata.indexOf(93, i);
        AsynchronousExtractorTest.assertTrue((String)("No closing ] : " + metadata.substring(i)), (j > 0 ? 1 : 0) != 0);
        String collection = metadata.substring(i, j);
        AsynchronousExtractorTest.assertTrue((String)("There should have 3 elements: " + collection), (collection.split(",").length == 3 ? 1 : 0) != 0);
        AsynchronousExtractorTest.assertTrue((String)"\"one\" is missing", (boolean)collection.contains("\"one\""));
        AsynchronousExtractorTest.assertTrue((String)"\"two\" is missing", (boolean)collection.contains("\"two\""));
        AsynchronousExtractorTest.assertTrue((String)"\"three\" is missing", (boolean)collection.contains("\"three\""));
    }

    @Test
    public void testEmbedNodeDeleted() throws Exception {
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataEmbedder, "quick/quick.html", -1, this.origSize, this.origProperties, MetadataExtracter.OverwritePolicy.PRAGMATIC, new QName[0]);
    }

    @Test
    public void testEmbedContentChanged() throws Exception {
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataEmbedder, "quick/quick.html", CHANGED_HASHCODE, this.origSize, this.origProperties, MetadataExtracter.OverwritePolicy.PRAGMATIC, new QName[0]);
    }

    @Test
    public void testEmbedTransformFailure() throws Exception {
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataEmbedder, null, UNCHANGED_HASHCODE, this.origSize, this.origProperties, MetadataExtracter.OverwritePolicy.PRAGMATIC, new QName[0]);
    }

    @Test
    public void testOverwritePolicyEager() throws Exception {
        QName author = QName.createQName((String)"cm:author", (NamespacePrefixResolver)this.namespacePrefixResolver);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            Map properties = this.nodeService.getProperties(this.nodeRef);
            properties.put(author, "Original author");
            this.nodeService.addProperties(this.nodeRef, properties);
            return null;
        });
        this.origProperties.put(author, (Serializable)((Object)"Original author"));
        this.expectedProperties.put(author, (Serializable)((Object)"Nevin Nollop"));
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataExtracter, "quick/quick.eager_policy_metadata.json", UNCHANGED_HASHCODE, this.origSize, this.expectedProperties, MetadataExtracter.OverwritePolicy.EAGER, new QName[0]);
    }

    @Test
    public void testOverwritePolicyCautious() throws Exception {
        QName author = QName.createQName((String)"cm:author", (NamespacePrefixResolver)this.namespacePrefixResolver);
        QName title = QName.createQName((String)"cm:title", (NamespacePrefixResolver)this.namespacePrefixResolver);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            Map properties = this.nodeService.getProperties(this.nodeRef);
            properties.put(author, "Original author");
            this.nodeService.addProperties(this.nodeRef, properties);
            return null;
        });
        this.origProperties.put(author, (Serializable)((Object)"Original author"));
        this.expectedProperties.put(author, (Serializable)((Object)"Original author"));
        this.expectedProperties.put(title, (Serializable)((Object)"The quick brown fox jumps over the lazy dog"));
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataExtracter, "quick/quick.cautious_policy_metadata.json", UNCHANGED_HASHCODE, this.origSize, this.expectedProperties, MetadataExtracter.OverwritePolicy.CAUTIOUS, new QName[0]);
    }

    @Test
    public void testOverwritePolicyPrudent() throws Exception {
        QName author = QName.createQName((String)"cm:author", (NamespacePrefixResolver)this.namespacePrefixResolver);
        QName title = QName.createQName((String)"cm:title", (NamespacePrefixResolver)this.namespacePrefixResolver);
        QName description = QName.createQName((String)"cm:description", (NamespacePrefixResolver)this.namespacePrefixResolver);
        QName audio = QName.createQName((String)"audio:audio", (NamespacePrefixResolver)this.namespacePrefixResolver);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            Map properties = this.nodeService.getProperties(this.nodeRef);
            properties.put(author, "Original author");
            properties.put(title, "");
            properties.put(audio, "Default audio");
            this.nodeService.addProperties(this.nodeRef, properties);
            return null;
        });
        this.origProperties.put(author, (Serializable)((Object)"Original author"));
        this.origProperties.put(title, (Serializable)((Object)""));
        this.origProperties.put(audio, (Serializable)((Object)"Default audio"));
        this.expectedProperties.put(author, (Serializable)((Object)"Original author"));
        this.expectedProperties.put(title, (Serializable)((Object)"The quick brown fox jumps over the lazy dog"));
        this.expectedProperties.put(description, (Serializable)((Object)"Gym class featuring a brown fox and lazy dog"));
        this.expectedProperties.put(audio, (Serializable)((Object)"Default audio"));
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataExtracter, "quick/quick.prudent_policy_metadata.json", UNCHANGED_HASHCODE, this.origSize, this.expectedProperties, MetadataExtracter.OverwritePolicy.PRUDENT, new QName[0]);
    }

    @Test
    public void testOverwritePolicyPragmatic() throws Exception {
        QName author = QName.createQName((String)"cm:author", (NamespacePrefixResolver)this.namespacePrefixResolver);
        QName title = QName.createQName((String)"cm:title", (NamespacePrefixResolver)this.namespacePrefixResolver);
        QName description = QName.createQName((String)"cm:description", (NamespacePrefixResolver)this.namespacePrefixResolver);
        QName audio = QName.createQName((String)"audio:audio", (NamespacePrefixResolver)this.namespacePrefixResolver);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            Map properties = this.nodeService.getProperties(this.nodeRef);
            properties.put(author, "Original author");
            properties.put(title, "");
            properties.put(audio, "Default audio");
            this.nodeService.addProperties(this.nodeRef, properties);
            return null;
        });
        this.origProperties.put(author, (Serializable)((Object)"Original author"));
        this.origProperties.put(title, (Serializable)((Object)""));
        this.origProperties.put(audio, (Serializable)((Object)"Default audio"));
        this.expectedProperties.put(author, (Serializable)((Object)"Original author"));
        this.expectedProperties.put(title, (Serializable)((Object)"The quick brown fox jumps over the lazy dog"));
        this.expectedProperties.put(description, (Serializable)((Object)"Gym class featuring a brown fox and lazy dog"));
        this.expectedProperties.put(audio, (Serializable)((Object)"New audio"));
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataExtracter, "quick/quick.pragmatic_policy_metadata.json", UNCHANGED_HASHCODE, this.origSize, this.expectedProperties, MetadataExtracter.OverwritePolicy.PRAGMATIC, new QName[0]);
    }

    @Test
    public void testCarryAspectFalse() throws Exception {
        QName title = QName.createQName((String)"cm:title", (NamespacePrefixResolver)this.namespacePrefixResolver);
        QName author = QName.createQName((String)"cm:author", (NamespacePrefixResolver)this.namespacePrefixResolver);
        QName description = QName.createQName((String)"cm:description", (NamespacePrefixResolver)this.namespacePrefixResolver);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            Map properties = this.nodeService.getProperties(this.nodeRef);
            properties.put(title, "Default title");
            this.nodeService.addProperties(this.nodeRef, properties);
            return null;
        });
        this.origProperties.put(title, (Serializable)((Object)"Default title"));
        this.expectedProperties.put(author, (Serializable)((Object)"Nevin Nollop"));
        this.expectedProperties.put(description, (Serializable)((Object)"Gym class featuring a brown fox and lazy dog"));
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataExtracter, "quick/quick.carryAspectFalse_metadata.json", UNCHANGED_HASHCODE, this.origSize, this.expectedProperties, MetadataExtracter.OverwritePolicy.PRAGMATIC, new QName[0]);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            Map properties = this.nodeService.getProperties(this.nodeRef);
            AsynchronousExtractorTest.assertFalse((String)"Title should be removed from properties because the extracted value is null", (boolean)properties.containsKey(title));
            return null;
        });
    }

    @Test
    public void testCarryAspectTrue() throws Exception {
        QName title = QName.createQName((String)"cm:title", (NamespacePrefixResolver)this.namespacePrefixResolver);
        QName author = QName.createQName((String)"cm:author", (NamespacePrefixResolver)this.namespacePrefixResolver);
        QName description = QName.createQName((String)"cm:description", (NamespacePrefixResolver)this.namespacePrefixResolver);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            Map properties = this.nodeService.getProperties(this.nodeRef);
            properties.put(title, "Default title");
            this.nodeService.addProperties(this.nodeRef, properties);
            return null;
        });
        this.origProperties.put(title, (Serializable)((Object)"Default title"));
        this.expectedProperties.put(author, (Serializable)((Object)"Nevin Nollop"));
        this.expectedProperties.put(title, (Serializable)((Object)"Default title"));
        this.expectedProperties.put(description, (Serializable)((Object)"Gym class featuring a brown fox and lazy dog"));
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataExtracter, "quick/quick.carryAspectTrue_metadata.json", UNCHANGED_HASHCODE, this.origSize, this.expectedProperties, MetadataExtracter.OverwritePolicy.PRAGMATIC, new QName[0]);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            Map properties = this.nodeService.getProperties(this.nodeRef);
            AsynchronousExtractorTest.assertTrue((String)"Title should NOT be removed from properties because carryAspectProperties is true", (boolean)properties.containsKey(title));
            return null;
        });
    }

    @Test
    public void testExtractTagging() throws Exception {
        QName taggable = QName.createQName((String)"cm:taggable", (NamespacePrefixResolver)this.namespacePrefixResolver);
        this.contentMetadataExtracter.setEnableStringTagging(true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            Map properties = this.nodeService.getProperties(this.nodeRef);
            AsynchronousExtractorTest.assertFalse((boolean)properties.containsKey(ContentModel.PROP_TAGS));
            return null;
        });
        List<String> expectedTags = Arrays.asList("tag1", "tag2", "tag3");
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataExtracter, "quick/quick.tagging_metadata.json", UNCHANGED_HASHCODE, this.origSize, this.expectedProperties, MetadataExtracter.OverwritePolicy.PRAGMATIC, taggable);
        List actualTags = (List)this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            Map properties = this.nodeService.getProperties(this.nodeRef);
            AsynchronousExtractorTest.assertTrue((boolean)properties.containsKey(ContentModel.PROP_TAGS));
            return this.taggingService.getTags(this.nodeRef);
        });
        for (String expectedTag : expectedTags) {
            AsynchronousExtractorTest.assertTrue((String)("Expected tag " + expectedTag + " not in " + actualTags), (boolean)actualTags.contains(expectedTag));
        }
    }

    @Test
    public void testExtractTaggingWhenDisabled() throws Exception {
        this.contentMetadataExtracter.setEnableStringTagging(false);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            Map properties = this.nodeService.getProperties(this.nodeRef);
            AsynchronousExtractorTest.assertFalse((boolean)properties.containsKey(ContentModel.PROP_TAGS));
            return null;
        });
        this.assertAsyncMetadataExecute((ActionExecuterAbstractBase)this.contentMetadataExtracter, "quick/quick.tagging_metadata_enable_false.json", UNCHANGED_HASHCODE, this.origSize, this.expectedProperties, MetadataExtracter.OverwritePolicy.PRAGMATIC, new QName[0]);
        List tags = (List)this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            Map properties = this.nodeService.getProperties(this.nodeRef);
            AsynchronousExtractorTest.assertFalse((boolean)properties.containsKey(ContentModel.PROP_TAGS));
            return this.taggingService.getTags(this.nodeRef);
        });
        AsynchronousExtractorTest.assertEquals((String)"Unexpected tags", (int)0, (int)tags.size());
    }

    @Test
    public void testStaticMethods() {
        AsynchronousExtractorTest.assertTrue((String)"isMetadataExtractMimetype", (boolean)AsynchronousExtractor.isMetadataExtractMimetype((String)"alfresco-metadata-extract"));
        AsynchronousExtractorTest.assertTrue((String)"isMetadataEmbedMimetype", (boolean)AsynchronousExtractor.isMetadataEmbedMimetype((String)"alfresco-metadata-embed"));
        AsynchronousExtractorTest.assertFalse((String)"isMetadataExtractMimetype", (boolean)AsynchronousExtractor.isMetadataExtractMimetype((String)"alfresco-metadata-embed"));
        AsynchronousExtractorTest.assertFalse((String)"isMetadataEmbedMimetype", (boolean)AsynchronousExtractor.isMetadataEmbedMimetype((String)"alfresco-metadata-extract"));
        AsynchronousExtractorTest.assertEquals((String)"getTargetMimetypeFromTransformName", (String)"alfresco-metadata-extract", (String)AsynchronousExtractor.getTargetMimetypeFromTransformName((String)"alfresco-metadata-extract/text/plain"));
        AsynchronousExtractorTest.assertEquals((String)"getTargetMimetypeFromTransformName", (String)"alfresco-metadata-embed", (String)AsynchronousExtractor.getTargetMimetypeFromTransformName((String)"alfresco-metadata-embed/text/plain"));
        AsynchronousExtractorTest.assertEquals((String)"getTargetMimetypeFromTransformName", null, (String)AsynchronousExtractor.getTargetMimetypeFromTransformName((String)"anything else"));
        AsynchronousExtractorTest.assertEquals((String)"getTargetMimetypeFromTransformName", null, (String)AsynchronousExtractor.getTargetMimetypeFromTransformName(null));
        AsynchronousExtractorTest.assertEquals((String)"getTargetMimetypeFromTransformName", (String)"text/plain", (String)AsynchronousExtractor.getSourceMimetypeFromTransformName((String)"alfresco-metadata-extract/text/plain"));
        AsynchronousExtractorTest.assertEquals((String)"getTargetMimetypeFromTransformName", (String)"text/plain", (String)AsynchronousExtractor.getSourceMimetypeFromTransformName((String)"alfresco-metadata-embed/text/plain"));
    }

    private class MockCategoryService
    extends NoIndexCategoryServiceImpl {
        private NodeRef taggableCat;

        MockCategoryService(NodeService nodeService, NodeService publicNodeService) {
            this.setNodeService(nodeService);
            this.setPublicNodeService(publicNodeService);
            NodeRef catContainer = nodeService.createNode(AsynchronousExtractorTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"categoryContainer"), ContentModel.TYPE_CONTAINER).getChildRef();
            NodeRef catRoot = nodeService.createNode(catContainer, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"categoryRoot"), ContentModel.TYPE_CATEGORYROOT).getChildRef();
            this.taggableCat = nodeService.createNode(catRoot, ContentModel.ASSOC_CATEGORIES, ContentModel.ASPECT_TAGGABLE, ContentModel.TYPE_CATEGORY).getChildRef();
        }

        public void setTaggableCat(NodeRef taggableCat) {
            this.taggableCat = taggableCat;
        }

        protected Set<NodeRef> getClassificationNodes(StoreRef storeRef, QName qname) {
            return Collections.singleton(this.taggableCat);
        }
    }

    private class TestAsynchronousExtractor
    extends AsynchronousExtractor {
        private final String mockResult;
        private final Integer changedHashcode;
        private final Random random = new Random();
        private boolean finished;
        TransformClient mockTransformClient = new TransformClient(){

            public void checkSupported(NodeRef sourceNodeRef, RenditionDefinition2 renditionDefinition, String sourceMimetype, long sourceSizeInBytes, String contentUrl) {
            }

            public void transform(NodeRef sourceNodeRef, RenditionDefinition2 renditionDefinition, String user, int sourceContentHashCode) throws UnsupportedTransformationException, ContentIOException {
                TestAsynchronousExtractor.this.mockTransform(sourceNodeRef, renditionDefinition, sourceContentHashCode);
            }
        };

        TestAsynchronousExtractor(String mockResult, Integer changedHashcode, MetadataExtracter.OverwritePolicy policy) {
            this.mockResult = mockResult;
            this.changedHashcode = changedHashcode;
            this.setNodeService(AsynchronousExtractorTest.this.nodeService);
            this.setNamespacePrefixResolver(AsynchronousExtractorTest.this.namespacePrefixResolver);
            this.setTransformerDebug(AsynchronousExtractorTest.this.transformerDebug);
            this.setRenditionService2((RenditionService2)AsynchronousExtractorTest.this.renditionService2);
            this.setContentService(AsynchronousExtractorTest.this.contentService);
            this.setTransactionService(AsynchronousExtractorTest.this.transactionService);
            this.setTransformServiceRegistry(AsynchronousExtractorTest.this.transformServiceRegistry);
            this.setRenditionDefinitionRegistry2(AsynchronousExtractorTest.this.renditionDefinitionRegistry2);
            this.setEnableStringTagging(true);
            this.setTaggingService((TaggingService)AsynchronousExtractorTest.this.taggingService);
            this.setRegistry(AsynchronousExtractorTest.this.metadataExtracterRegistry);
            this.setMimetypeService(AsynchronousExtractorTest.this.mimetypeService);
            this.setDictionaryService(AsynchronousExtractorTest.this.dictionaryService);
            this.setExecutorService(executorService);
            this.setOverwritePolicy(policy);
            this.register();
            AsynchronousExtractorTest.this.renditionService2.setTransformClient(this.mockTransformClient);
            AsynchronousExtractorTest.this.renditionService2.setAsynchronousExtractor((AsynchronousExtractor)this);
        }

        public boolean isSupported(String sourceMimetype, long sourceSizeInBytes) {
            return true;
        }

        public boolean isEmbedderSupported(String sourceMimetype, long sourceSizeInBytes) {
            return true;
        }

        protected Map<String, Serializable> mapSystemToRaw(Map<QName, Serializable> systemMetadata) {
            HashMap<QName, Serializable> metadataWithCollection = new HashMap<QName, Serializable>(systemMetadata);
            ArrayList<String> collection = new ArrayList<String>(Set.of("one", "two", "three"));
            metadataWithCollection.put(ContentModel.PROP_TITLE, collection);
            return super.mapSystemToRaw(metadataWithCollection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mockTransform(NodeRef sourceNodeRef, RenditionDefinition2 renditionDefinition, int sourceContentHashCode) {
            Object object;
            block19: {
                int transformContentHashCode;
                AsynchronousExtractorTest.this.transformOptionsPassedToTEngine = renditionDefinition.getTransformOptions();
                try {
                    AsynchronousExtractorTest.this.transformerDebug.pushMisc();
                    this.wait(50, 700);
                }
                finally {
                    AsynchronousExtractorTest.this.transformerDebug.popMisc();
                }
                int n = transformContentHashCode = this.changedHashcode == null ? sourceContentHashCode : this.changedHashcode;
                if (this.mockResult != null) {
                    try {
                        object = null;
                        Object var6_9 = null;
                        try (InputStream transformInputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.mockResult);){
                            AsynchronousExtractorTest.this.renditionService2.consume(sourceNodeRef, transformInputStream, renditionDefinition, transformContentHashCode);
                            break block19;
                        }
                        catch (Throwable throwable) {
                            if (object == null) {
                                object = throwable;
                            } else if (object != throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            throw object;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not read '" + this.mockResult + "' from the classpath.", e);
                    }
                }
                AsynchronousExtractorTest.this.renditionService2.failure(sourceNodeRef, renditionDefinition, transformContentHashCode);
            }
            object = this;
            synchronized (object) {
                this.finished = true;
                ((Object)((Object)this)).notifyAll();
            }
        }

        public synchronized void wait(int from, int to) {
            long start = System.currentTimeMillis();
            long end = start + (long)(from < 0 ? to : from + this.random.nextInt(to - from));
            while (!this.finished && System.currentTimeMillis() < end) {
                try {
                    long ms = end - System.currentTimeMillis();
                    if (ms <= 0L) continue;
                    ((Object)((Object)this)).wait(ms);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

