/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr.facet;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetComparator;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetProperties;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Function;
import org.junit.Assert;
import org.junit.Test;

public class SolrFacetComparatorTest {
    @Test
    public void simpleSortOfSortedFacets() throws Exception {
        List<String> expectedIds = Arrays.asList("a", "b", "c", "d");
        SolrFacetProperties.Builder builder = new SolrFacetProperties.Builder();
        List<SolrFacetProperties> facets = Arrays.asList(builder.filterID("a").build(), builder.filterID("d").build(), builder.filterID("b").build(), builder.filterID("c").build());
        Collections.sort(facets, new SolrFacetComparator(expectedIds));
        Assert.assertEquals(expectedIds, this.toFacetIds(facets));
    }

    private List<String> toFacetIds(List<SolrFacetProperties> facets) {
        return CollectionUtils.transform(facets, (Function)new Function<SolrFacetProperties, String>(){

            public String apply(SolrFacetProperties value) {
                return value.getFilterID();
            }
        });
    }
}

