/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.filestore;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.repo.content.AbstractContentWriter;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@AlfrescoPublicApi
public class FileContentWriter
extends AbstractContentWriter {
    private static final Log logger = LogFactory.getLog(FileContentWriter.class);
    private File file;
    private boolean allowRandomAccess;

    public FileContentWriter(File file) {
        this(file, null);
    }

    public FileContentWriter(File file, ContentReader existingContentReader) {
        this(file, "store://" + file.getAbsolutePath(), existingContentReader);
    }

    public FileContentWriter(File file, String url, ContentReader existingContentReader) {
        super(url, existingContentReader);
        this.file = file;
        this.allowRandomAccess = true;
    }

    void setAllowRandomAccess(boolean allow) {
        this.allowRandomAccess = allow;
    }

    public File getFile() {
        return this.file;
    }

    public long getSize() {
        if (this.file == null) {
            return 0L;
        }
        if (!this.file.exists()) {
            return 0L;
        }
        return this.file.length();
    }

    @Override
    protected ContentReader createReader() throws ContentIOException {
        FileContentReader reader = new FileContentReader(this.file, this.getContentUrl());
        reader.setAllowRandomAccess(this.allowRandomAccess);
        return reader;
    }

    @Override
    protected WritableByteChannel getDirectWritableChannel() throws ContentIOException {
        try {
            if (this.file.exists() && this.file.length() > 0L) {
                throw new IOException("File exists - overwriting not allowed");
            }
            WritableByteChannel channel = null;
            if (this.allowRandomAccess) {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "rw");
                channel = randomAccessFile.getChannel();
            } else {
                FileOutputStream os = new FileOutputStream(this.file);
                channel = Channels.newChannel(os);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Opened write channel to file: \n   file: " + this.file + "\n" + "   random-access: " + this.allowRandomAccess));
            }
            return channel;
        }
        catch (Throwable e) {
            throw new ContentIOException("Failed to open file channel: " + this, e);
        }
    }

    public boolean canWrite() {
        return true;
    }
}

