/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.TransactionalCache;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodeEntity;
import org.alfresco.repo.domain.node.NodePropertyEntity;
import org.alfresco.repo.domain.node.NodePropertyValue;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.Pair;
import org.alfresco.util.testing.category.DBTests;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.Assert;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class, DBTests.class, LuceneTests.class})
public class NodeDAOTest
extends TestCase {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private NodeDAO nodeDAO;
    private SimpleCache<Serializable, TransactionalCache.ValueHolder<Node>> rootNodesCache;

    public void setUp() {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.txnHelper.setMinRetryWaitMs(10);
        this.txnHelper.setRetryWaitIncrementMs(10);
        this.txnHelper.setMaxRetryWaitMs(50);
        this.nodeDAO = (NodeDAO)this.ctx.getBean("nodeDAO");
        this.rootNodesCache = (SimpleCache)this.ctx.getBean("node.rootNodesSharedCache");
    }

    public void testTransaction() throws Throwable {
        boolean[] newTxn = new boolean[1];
        RetryingTransactionHelper.RetryingTransactionCallback getTxnIdCallback = () -> {
            Long currentTransactionId = this.nodeDAO.getCurrentTransactionId(newTxn[0]);
            Long currentTransactionCommitTime = this.nodeDAO.getCurrentTransactionCommitTime();
            return new Pair((Object)currentTransactionId, (Object)currentTransactionCommitTime);
        };
        try {
            getTxnIdCallback.execute();
            NodeDAOTest.fail((String)"Should have failed when running outside of a transaction");
        }
        catch (Throwable throwable) {}
        Pair txn0 = (Pair)this.txnHelper.doInTransaction(getTxnIdCallback);
        Long txnId0 = (Long)txn0.getFirst();
        Long commitTime0 = (Long)txn0.getSecond();
        NodeDAOTest.assertNull((String)"No Txn ID should be present in read-only txn", (Object)txnId0);
        NodeDAOTest.assertNull((String)"No Txn Commit time should be present in read-only txn", (Object)commitTime0);
        Pair txn1 = (Pair)this.txnHelper.doInTransaction(getTxnIdCallback);
        Long txnId1 = (Long)txn1.getFirst();
        Long commitTime1 = (Long)txn1.getSecond();
        NodeDAOTest.assertNull((String)"No Txn ID should be present in untouched txn", (Object)txnId1);
        NodeDAOTest.assertNull((String)"No Txn Commit time should be present in untouched txn", (Object)commitTime1);
        newTxn[0] = true;
        Pair txn2 = (Pair)this.txnHelper.doInTransaction(getTxnIdCallback);
        Long txnId2 = (Long)txn2.getFirst();
        Long commitTime2 = (Long)txn2.getSecond();
        NodeDAOTest.assertNotNull((String)"Txn ID should be present by forcing it", (Object)txnId2);
        NodeDAOTest.assertNotNull((String)"Txn commit time should be present by forcing it", (Object)commitTime2);
    }

    public void testSelectNodePropertiesByTypes() throws Exception {
        final Set<QName> qnames = Collections.singleton(ContentModel.PROP_NAME);
        RetryingTransactionHelper.RetryingTransactionCallback<List<NodePropertyEntity>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<List<NodePropertyEntity>>(){

            public List<NodePropertyEntity> execute() throws Throwable {
                return NodeDAOTest.this.nodeDAO.selectNodePropertiesByTypes(qnames);
            }
        };
        List props = (List)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, true);
        if (props.size() == 0) {
            return;
        }
        NodePropertyEntity prop = (NodePropertyEntity)props.get(0);
        String value = prop.getValue().getStringValue();
        NodeDAOTest.assertNotNull((Object)value);
    }

    public void testSelectNodePropertiesByDataType() throws Exception {
        final AtomicLong min = new AtomicLong(0L);
        final AtomicLong max = new AtomicLong(0L);
        RetryingTransactionHelper.RetryingTransactionCallback<List<NodePropertyEntity>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<List<NodePropertyEntity>>(){

            public List<NodePropertyEntity> execute() throws Throwable {
                long minNodeId = min.get();
                long maxNodeId = max.get();
                return NodeDAOTest.this.nodeDAO.selectNodePropertiesByDataType(DataTypeDefinition.TEXT, minNodeId, maxNodeId);
            }
        };
        Long minNodeId = this.nodeDAO.getMinNodeId();
        if (minNodeId == null) {
            return;
        }
        Long maxNodeId = this.nodeDAO.getMaxNodeId();
        min.set(minNodeId);
        while (min.longValue() <= maxNodeId) {
            max.set(min.get() + 1000L);
            List props = (List)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, true);
            for (NodePropertyEntity prop : props) {
                Long nodeId = prop.getNodeId();
                NodeDAOTest.assertNotNull((Object)nodeId);
                NodeDAOTest.assertTrue((String)"the min should be inclusive.", (min.longValue() <= nodeId ? 1 : 0) != 0);
                NodeDAOTest.assertTrue((String)"the max should be exclusive.", (max.longValue() > nodeId ? 1 : 0) != 0);
                NodePropertyValue propVal = prop.getValue();
                NodeDAOTest.assertNotNull((Object)propVal);
                NodeDAOTest.assertEquals((String)"STRING", (String)propVal.getActualTypeString());
                String value = (String)((Object)propVal.getValue(DataTypeDefinition.TEXT));
                NodeDAOTest.assertNotNull((Object)value);
            }
            min.set(max.get());
        }
    }

    public void testGetNodeIdsIntervalForType() throws Exception {
        Pair<Long, Long> interval1 = this.getNodeIdsInterval(0L, System.currentTimeMillis());
        Pair<Long, Long> interval2 = this.getNodeIdsInterval(null, System.currentTimeMillis());
        Pair<Long, Long> interval3 = this.getNodeIdsInterval(null, null);
        NodeDAOTest.assertEquals((Object)interval1.getFirst(), (Object)interval2.getFirst());
        NodeDAOTest.assertEquals((Object)interval2.getFirst(), (Object)interval3.getFirst());
        NodeDAOTest.assertEquals((Object)interval1.getSecond(), (Object)interval2.getSecond());
        NodeDAOTest.assertEquals((Object)interval2.getSecond(), (Object)interval3.getSecond());
    }

    private Pair<Long, Long> getNodeIdsInterval(final Long minTxnTime, final Long maxTxnTime) {
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Long>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Long>>(){

            public Pair<Long, Long> execute() throws Throwable {
                return NodeDAOTest.this.nodeDAO.getNodeIdsIntervalForType(ContentModel.TYPE_FOLDER, minTxnTime, maxTxnTime);
            }
        };
        return (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, true);
    }

    public void testSelectChildAssocsWithoutNodeAssocsOfTypes() {
        StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
        final Long parentId = (Long)this.nodeDAO.getRootNode(storeRef).getFirst();
        final AtomicLong min = new AtomicLong(0L);
        final AtomicLong max = new AtomicLong(0L);
        final Set<QName> typeAssocsToExclude = Collections.singleton(QName.createQName((String)"noType"));
        RetryingTransactionHelper.RetryingTransactionCallback<List<Node>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<List<Node>>(){

            public List<Node> execute() throws Throwable {
                long minNodeId = min.get();
                long maxNodeId = max.get();
                return NodeDAOTest.this.nodeDAO.selectChildAssocsWithoutNodeAssocsOfTypes(parentId, Long.valueOf(minNodeId), Long.valueOf(maxNodeId), typeAssocsToExclude);
            }
        };
        Pair<Long, Long> nodeRange = this.getNodeIdsInterval(0L, System.currentTimeMillis());
        Long minNodeId = (Long)nodeRange.getFirst();
        Long maxNodeId = (Long)nodeRange.getSecond();
        min.set(minNodeId);
        while (min.longValue() <= maxNodeId) {
            max.set(min.get() + 100L);
            List nodes = (List)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, true);
            for (Node node : nodes) {
                Long nodeId = node.getId();
                NodeDAOTest.assertNotNull((Object)nodeId);
                NodeDAOTest.assertTrue((String)"the min should be inclusive.", (min.longValue() <= nodeId ? 1 : 0) != 0);
                NodeDAOTest.assertTrue((String)"the max should be exclusive.", (max.longValue() > nodeId ? 1 : 0) != 0);
            }
            min.set(max.get());
        }
    }

    public void testGetNodesWithAspects() throws Throwable {
        final NodeDAO.NodeRefQueryCallback callback = new NodeDAO.NodeRefQueryCallback(){

            public boolean handle(Pair<Long, NodeRef> nodePair) {
                return false;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeDAOTest.this.nodeDAO.getNodesWithAspects(Collections.singleton(ContentModel.ASPECT_AUDITABLE), Long.valueOf(1L), Long.valueOf(1000L), callback);
                return null;
            }
        }, true);
    }

    public void testGetMinMaxNodeId() throws Exception {
        Long minNodeId = this.nodeDAO.getMinNodeId();
        NodeDAOTest.assertNotNull((Object)minNodeId);
        NodeDAOTest.assertTrue((minNodeId > 0L ? 1 : 0) != 0);
        Long maxNodeId = this.nodeDAO.getMaxNodeId();
        NodeDAOTest.assertNotNull((Object)maxNodeId);
        NodeDAOTest.assertTrue((maxNodeId > minNodeId ? 1 : 0) != 0);
    }

    public void testGetPrimaryChildAcls() throws Throwable {
        List acls = this.nodeDAO.getPrimaryChildrenAcls(Long.valueOf(1L));
        NodeDAOTest.assertNotNull((String)"Null list", (Object)acls);
    }

    public void testGetStoreId() throws Throwable {
        List storePairs = this.nodeDAO.getStores();
        for (Pair storePair : storePairs) {
            StoreRef storeRef = (StoreRef)storePair.getSecond();
            Pair checkStorePair = this.nodeDAO.getStore(storeRef);
            NodeDAOTest.assertEquals((String)"Store pair did not match. ", (Object)storePair, (Object)checkStorePair);
        }
    }

    public void testCacheNodes() throws Throwable {
        Long minNodeId = this.nodeDAO.getMinNodeId();
        final ArrayList<Long> nodeIds = new ArrayList<Long>(10000);
        long i = 0L;
        while (i < 1000L) {
            nodeIds.add(minNodeId + i);
            ++i;
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeDAOTest.this.nodeDAO.cacheNodesById(nodeIds);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, true);
    }

    public void testRootNodeCacheEntries() throws Throwable {
        List storeRefPairs = this.nodeDAO.getStores();
        NodeDAOTest.assertTrue((String)"No stores in the system.", (storeRefPairs.size() > 0 ? 1 : 0) != 0);
        for (Pair storeRefPair : storeRefPairs) {
            StoreRef storeRef = (StoreRef)storeRefPair.getSecond();
            this.nodeDAO.getRootNode(storeRef);
        }
        Collection keys = this.rootNodesCache.getKeys();
        NodeDAOTest.assertTrue((String)"Cache entries were not populated. ", (keys.size() > 0 ? 1 : 0) != 0);
        for (Serializable key : keys) {
            NodeEntity node = (NodeEntity)TransactionalCache.getSharedCacheValue(this.rootNodesCache, (Serializable)key);
            NodeEntity clonedNode = (NodeEntity)node.clone();
            node.hashCode();
            Assert.assertEquals((Object)node, (Object)clonedNode);
        }
    }

    public void testGetMinTxInNodeIdRange() {
        Long fromNodeId = this.nodeDAO.getMinNodeId();
        Long toNodeId = this.nodeDAO.getMaxNodeId();
        Long minTxCommitTime = this.nodeDAO.getMinTxnCommitTime();
        Long minTxCommitTimeInRange = this.nodeDAO.getMinTxInNodeIdRange(fromNodeId, toNodeId);
        NodeDAOTest.assertEquals((Object)minTxCommitTime, (Object)minTxCommitTimeInRange);
    }

    public void testGetMaxTxInNodeIdRange() {
        Long fromNodeId = this.nodeDAO.getMinNodeId();
        Long toNodeId = this.nodeDAO.getMaxNodeId();
        Long maxTxCommitTime = this.nodeDAO.getMaxTxnCommitTime();
        Long maxTxCommitTimeInRange = this.nodeDAO.getMaxTxInNodeIdRange(fromNodeId, toNodeId);
        NodeDAOTest.assertEquals((Object)maxTxCommitTime, (Object)maxTxCommitTimeInRange);
    }

    public void testGetNextTxCommitTime() {
        Long fromCommitTime = this.nodeDAO.getMinTxnCommitTime();
        Long nextTxnCommitTime = this.nodeDAO.getNextTxCommitTime(fromCommitTime);
        NodeDAOTest.assertTrue((nextTxnCommitTime >= fromCommitTime ? 1 : 0) != 0);
    }
}

