/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db;

import java.util.Set;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.permissions.Authority;
import org.alfresco.repo.search.impl.querymodel.impl.db.NodePermissionAssessor;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class NodePermissionAssessorPermissionsTest {
    private PermissionService permissionService;

    @Before
    public void setup() {
        AuthenticationUtil.clearCurrentSecurityContext();
        this.permissionService = (PermissionService)Mockito.mock(PermissionService.class);
    }

    @Test
    public void shouldGrantPermissionWhenSystemIsReading() {
        AuthenticationUtil.setRunAsUserSystem();
        Node theNode = (Node)Mockito.mock(Node.class);
        NodePermissionAssessor assessor = this.createAssessor();
        Mockito.when((Object)assessor.isOwnerReading((Node)ArgumentMatchers.any(Node.class), (Authority)ArgumentMatchers.any(Authority.class))).thenReturn((Object)false);
        Mockito.when((Object)this.permissionService.getReaders(Long.valueOf(ArgumentMatchers.anyLong()))).thenReturn(Set.of());
        boolean included = assessor.isIncluded(theNode);
        Assert.assertTrue((boolean)included);
    }

    @Test
    public void shouldDenyPermissionWhenNullUserIsReading() {
        Node theNode = (Node)Mockito.mock(Node.class);
        NodePermissionAssessor assessor = this.createAssessor();
        Mockito.when((Object)assessor.isOwnerReading((Node)ArgumentMatchers.any(Node.class), (Authority)ArgumentMatchers.any(Authority.class))).thenReturn((Object)false);
        Mockito.when((Object)this.permissionService.getReaders(Long.valueOf(ArgumentMatchers.anyLong()))).thenReturn(Set.of());
        boolean included = assessor.isIncluded(theNode);
        Assert.assertFalse((boolean)included);
    }

    @Test
    public void shouldIsOwnerReadingReturnFalseWhenTheAuthorityIsNull() {
        Node theNode = (Node)Mockito.mock(Node.class);
        NodePermissionAssessor assessor = this.createAssessor();
        boolean result = assessor.isOwnerReading(theNode, null);
        Assert.assertFalse((boolean)result);
    }

    private NodePermissionAssessor createAssessor() {
        NodeService nodeService = (NodeService)Mockito.mock(NodeService.class);
        Authority authority = (Authority)Mockito.mock(Authority.class);
        EntityLookupCache nodeCache = (EntityLookupCache)Mockito.mock(EntityLookupCache.class);
        return (NodePermissionAssessor)Mockito.spy((Object)new NodePermissionAssessor(nodeService, this.permissionService, authority, nodeCache));
    }
}

