/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.validator;

import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.ValidationResult;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.Schema;
import org.alfresco.util.schemacomp.validator.AbstractDbValidator;
import org.springframework.extensions.surf.util.I18NUtil;

public class SchemaVersionValidator
extends AbstractDbValidator {
    public SchemaVersionValidator() {
        this.addFieldToValidate("version");
    }

    @Override
    public void validate(DbObject referenceObj, DbObject targetObj, DiffContext ctx) {
        Schema reference = (Schema)referenceObj;
        Schema target = (Schema)targetObj;
        if (target.getVersion() < reference.getVersion()) {
            DbProperty targetProperty = new DbProperty(target, "version");
            String message = I18NUtil.getMessage((String)"system.schema_comp.schema_version_validator", (Object[])new Object[]{reference.getVersion()});
            ctx.getComparisonResults().add(new ValidationResult(targetProperty, message));
        }
    }
}

