/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import org.alfresco.repo.cache.TransactionStats;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransactionStatsTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void canGetCacheOperationCountsWhenNoOpsTakenPlaceYet() {
        TransactionStats stats = new TransactionStats();
        Assert.assertTrue((TransactionStats.OpType.values().length > 0 ? 1 : 0) != 0);
        TransactionStats.OpType[] opTypeArray = TransactionStats.OpType.values();
        int n = opTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TransactionStats.OpType op = opTypeArray[n2];
            Assert.assertEquals((long)0L, (long)stats.getCount(op));
            ++n2;
        }
    }

    @Test
    public void canRecordSomeOpsAndGetTheirValues() {
        TransactionStats stats = new TransactionStats();
        stats.record(0L, 1000L, TransactionStats.OpType.GET_HIT);
        stats.record(2000L, 4000L, TransactionStats.OpType.GET_HIT);
        stats.record(3000L, 4000L, TransactionStats.OpType.GET_HIT);
        stats.record(0L, 1000L, TransactionStats.OpType.GET_MISS);
        stats.record(0L, 2000L, TransactionStats.OpType.GET_MISS);
        stats.record(0L, 3000L, TransactionStats.OpType.GET_MISS);
        stats.record(8000L, 9000L, TransactionStats.OpType.GET_MISS);
        stats.record(0L, 2000L, TransactionStats.OpType.GET_MISS);
        stats.record(0L, 3000L, TransactionStats.OpType.GET_MISS);
        stats.record(1500L, 2500L, TransactionStats.OpType.PUT);
        stats.record(100L, 2100L, TransactionStats.OpType.PUT);
        stats.record(0L, 1000L, TransactionStats.OpType.REMOVE);
        stats.record(0L, 1000L, TransactionStats.OpType.CLEAR);
        stats.record(0L, 2000L, TransactionStats.OpType.CLEAR);
        stats.record(0L, 2000L, TransactionStats.OpType.CLEAR);
        stats.record(0L, 2000L, TransactionStats.OpType.CLEAR);
        Assert.assertEquals((long)3L, (long)stats.getCount(TransactionStats.OpType.GET_HIT));
        Assert.assertEquals((long)6L, (long)stats.getCount(TransactionStats.OpType.GET_MISS));
        Assert.assertEquals((long)2L, (long)stats.getCount(TransactionStats.OpType.PUT));
        Assert.assertEquals((long)1L, (long)stats.getCount(TransactionStats.OpType.REMOVE));
        Assert.assertEquals((long)4L, (long)stats.getCount(TransactionStats.OpType.CLEAR));
        Assert.assertEquals((double)1333.33, (double)stats.getTimings(TransactionStats.OpType.GET_HIT).getMean(), (double)0.01);
        Assert.assertEquals((double)2000.0, (double)stats.getTimings(TransactionStats.OpType.GET_MISS).getMean(), (double)0.01);
        Assert.assertEquals((double)1500.0, (double)stats.getTimings(TransactionStats.OpType.PUT).getMean(), (double)0.01);
        Assert.assertEquals((double)1000.0, (double)stats.getTimings(TransactionStats.OpType.REMOVE).getMean(), (double)0.01);
        Assert.assertEquals((double)1750.0, (double)stats.getTimings(TransactionStats.OpType.CLEAR).getMean(), (double)0.01);
    }
}

