/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.ml.tools;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.ml.tools.AbstractMultilingualTestCases;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.GUID;
import org.junit.experimental.categories.Category;
import org.springframework.extensions.surf.util.I18NUtil;

@Category(value={OwnJVMTestsCategory.class})
public class MultilingualContentServiceImplTest
extends AbstractMultilingualTestCases {
    public void testMakeTranslation() throws Exception {
        NodeRef chineseContentNodeRef = this.createContent();
        this.multilingualContentService.makeTranslation(chineseContentNodeRef, Locale.CHINESE);
        NodeRef mlContainerNodeRef = this.multilingualContentService.getTranslationContainer(chineseContentNodeRef);
        MultilingualContentServiceImplTest.assertNotNull((String)"Container not created", (Object)mlContainerNodeRef);
        MultilingualContentServiceImplTest.assertEquals((String)"Incorrect number of child nodes", (int)1, (int)this.nodeService.getChildAssocs(mlContainerNodeRef).size());
    }

    public void testAddTranslationUsingContent() throws Exception {
        NodeRef chineseContentNodeRef = this.createContent();
        this.multilingualContentService.makeTranslation(chineseContentNodeRef, Locale.CHINESE);
        NodeRef mlContainerNodeRef = this.multilingualContentService.getTranslationContainer(chineseContentNodeRef);
        NodeRef frenchContentNodeRef = this.createContent();
        this.multilingualContentService.addTranslation(frenchContentNodeRef, chineseContentNodeRef, Locale.FRENCH);
        NodeRef newMLContainerNodeRef = this.multilingualContentService.getTranslationContainer(frenchContentNodeRef);
        MultilingualContentServiceImplTest.assertEquals((String)"Existing container should have been used", (Object)mlContainerNodeRef, (Object)newMLContainerNodeRef);
        MultilingualContentServiceImplTest.assertEquals((String)"Incorrect number of child nodes", (int)2, (int)this.nodeService.getChildAssocs(mlContainerNodeRef).size());
    }

    public void testGetMissingTranslation() throws Exception {
        List langList = this.contentFilterLanguagesService.getFilterLanguages();
        int langListSize = langList.size();
        MultilingualContentServiceImplTest.assertFalse((String)"The testGetMissingTranslation test case needs at least three language", (langListSize < 3 ? 1 : 0) != 0);
        Locale loc1 = I18NUtil.parseLocale((String)((String)langList.get(0)));
        Locale loc2 = I18NUtil.parseLocale((String)((String)langList.get(1)));
        Locale loc3 = I18NUtil.parseLocale((String)((String)langList.get(2)));
        NodeRef nodeRef1 = this.createContent();
        NodeRef nodeRef2 = this.createContent();
        NodeRef nodeRef3 = this.createContent();
        this.multilingualContentService.makeTranslation(nodeRef1, loc1);
        List missing = this.multilingualContentService.getMissingTranslations(nodeRef1, false);
        MultilingualContentServiceImplTest.assertFalse((String)("Missing Translation Size false. Real size : " + missing.size() + ". Normal Size " + (langListSize - 1)), (missing.size() != langListSize - 1 ? 1 : 0) != 0);
        MultilingualContentServiceImplTest.assertFalse((String)("Missing Translation List false. Locale " + loc1 + " found"), (boolean)missing.contains(loc1.toString()));
        this.multilingualContentService.addTranslation(nodeRef2, nodeRef1, loc2);
        this.multilingualContentService.addTranslation(nodeRef3, nodeRef1, loc3);
        missing = this.multilingualContentService.getMissingTranslations(nodeRef1, false);
        MultilingualContentServiceImplTest.assertFalse((String)("Missing Translation Size false. Real size : " + missing.size() + ". Normal Size " + (langListSize - 3)), (missing.size() != langListSize - 3 ? 1 : 0) != 0);
        MultilingualContentServiceImplTest.assertFalse((String)("Missing Translation List false. Locale " + loc2.toString() + " or " + loc3.toString() + " found"), (missing.contains(loc2) || missing.contains(loc3) ? 1 : 0) != 0);
    }

    public void testGetTranslationForLocale() throws Exception {
        NodeRef chineseContentNodeRef = this.createContent();
        this.multilingualContentService.makeTranslation(chineseContentNodeRef, Locale.CHINESE);
        NodeRef frenchContentNodeRef = this.createContent();
        this.multilingualContentService.addTranslation(frenchContentNodeRef, chineseContentNodeRef, Locale.FRENCH);
        MultilingualContentServiceImplTest.assertEquals((String)"Chinese translation should be present", (Object)chineseContentNodeRef, (Object)this.multilingualContentService.getTranslationForLocale(chineseContentNodeRef, Locale.CHINESE));
        MultilingualContentServiceImplTest.assertEquals((String)"French translation should be present", (Object)frenchContentNodeRef, (Object)this.multilingualContentService.getTranslationForLocale(chineseContentNodeRef, Locale.FRENCH));
        MultilingualContentServiceImplTest.assertEquals((String)"French translation should be present", (Object)chineseContentNodeRef, (Object)this.multilingualContentService.getTranslationForLocale(chineseContentNodeRef, Locale.ITALIAN));
    }

    public void testGetPivotTranslation() throws Exception {
        NodeRef chineseContentNodeRef = this.createContent();
        this.multilingualContentService.makeTranslation(chineseContentNodeRef, Locale.CHINESE);
        NodeRef mlContainerNodeRef = this.multilingualContentService.getTranslationContainer(chineseContentNodeRef);
        MultilingualContentServiceImplTest.assertNotNull((String)"Pivot language not set", (Object)this.nodeService.getProperty(mlContainerNodeRef, ContentModel.PROP_LOCALE));
        MultilingualContentServiceImplTest.assertEquals((String)"Pivot language not correctly set", (Object)Locale.CHINESE, (Object)this.nodeService.getProperty(mlContainerNodeRef, ContentModel.PROP_LOCALE));
        NodeRef frenchContentNodeRef = this.createContent();
        this.multilingualContentService.addTranslation(frenchContentNodeRef, chineseContentNodeRef, Locale.FRENCH);
        MultilingualContentServiceImplTest.assertEquals((String)"Unable to get pivot from container", (Object)chineseContentNodeRef, (Object)this.multilingualContentService.getPivotTranslation(mlContainerNodeRef));
        MultilingualContentServiceImplTest.assertEquals((String)"Unable to get pivot from translation", (Object)chineseContentNodeRef, (Object)this.multilingualContentService.getPivotTranslation(frenchContentNodeRef));
        this.nodeService.setProperty(mlContainerNodeRef, ContentModel.PROP_LOCALE, (Serializable)Locale.FRENCH);
        MultilingualContentServiceImplTest.assertEquals((String)"Pivot node ref not correct", (Object)frenchContentNodeRef, (Object)this.multilingualContentService.getPivotTranslation(mlContainerNodeRef));
    }

    public void testUnmakeTranslation() throws Exception {
        NodeRef frenchContentNodeRef = this.createContent();
        this.multilingualContentService.makeTranslation(frenchContentNodeRef, Locale.FRENCH);
        this.multilingualContentService.getTranslationContainer(frenchContentNodeRef);
        NodeRef englishContentNodeRef = this.createContent();
        this.multilingualContentService.addTranslation(englishContentNodeRef, frenchContentNodeRef, Locale.ENGLISH);
        NodeRef germanContentNodeRef = this.createContent();
        this.multilingualContentService.addTranslation(germanContentNodeRef, frenchContentNodeRef, Locale.GERMAN);
        this.multilingualContentService.unmakeTranslation(englishContentNodeRef);
        this.multilingualContentService.unmakeTranslation(germanContentNodeRef);
        MultilingualContentServiceImplTest.assertTrue((String)"The document should not be multilingual!", (!this.multilingualContentService.isTranslation(englishContentNodeRef) && !this.multilingualContentService.isTranslation(germanContentNodeRef) ? 1 : 0) != 0);
    }

    public void testUnmakeTranslationOnPivot() throws Exception {
        NodeRef frenchContentNodeRef = this.createContent();
        this.multilingualContentService.makeTranslation(frenchContentNodeRef, Locale.FRENCH);
        this.multilingualContentService.getTranslationContainer(frenchContentNodeRef);
        NodeRef englishContentNodeRef = this.createContent();
        this.multilingualContentService.addTranslation(englishContentNodeRef, frenchContentNodeRef, Locale.ENGLISH);
        NodeRef germanContentNodeRef = this.createContent();
        this.multilingualContentService.addTranslation(germanContentNodeRef, frenchContentNodeRef, Locale.GERMAN);
        this.multilingualContentService.unmakeTranslation(frenchContentNodeRef);
        MultilingualContentServiceImplTest.assertTrue((String)"The document should not be multilingual!", (!this.multilingualContentService.isTranslation(frenchContentNodeRef) && !this.multilingualContentService.isTranslation(englishContentNodeRef) && !this.multilingualContentService.isTranslation(germanContentNodeRef) ? 1 : 0) != 0);
    }

    public void testCreateEmptyTranslation() throws Exception {
        NodeRef chineseContentNodeRef = this.createContent("Document.txt");
        this.multilingualContentService.makeTranslation(chineseContentNodeRef, Locale.CHINESE);
        NodeRef emptyNodeRef = this.multilingualContentService.addEmptyTranslation(chineseContentNodeRef, "Document.txt", Locale.CANADA);
        MultilingualContentServiceImplTest.assertNotNull((String)"The creation of the empty document failed ", (Object)emptyNodeRef);
        MultilingualContentServiceImplTest.assertTrue((String)"The empty document must have the mlDocument aspect", (boolean)this.nodeService.hasAspect(emptyNodeRef, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT));
        MultilingualContentServiceImplTest.assertTrue((String)"The empty document must have the mlEmptyTranslation aspect", (boolean)this.nodeService.hasAspect(emptyNodeRef, ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION));
        String emptyName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(emptyNodeRef, ContentModel.PROP_NAME));
        MultilingualContentServiceImplTest.assertEquals((String)"Empty auto-rename didn't work for same-named document", (String)"Document_en_CA.txt", (String)emptyName);
        this.fileFolderService.getReader(chineseContentNodeRef).getContentData();
        this.fileFolderService.getReader(emptyNodeRef).getContentData();
    }

    public void testCreateEmptyTranslationNames() throws Exception {
        NodeRef chineseContentNodeRef = this.createContent("Document.txt");
        this.multilingualContentService.makeTranslation(chineseContentNodeRef, Locale.CHINESE);
        NodeRef koreanContentNodeRef = this.createContent("Document_ko.txt");
        this.multilingualContentService.addTranslation(koreanContentNodeRef, chineseContentNodeRef, Locale.KOREAN);
        MultilingualContentServiceImplTest.assertEquals((String)"The wrong language was set as the pivot translation", (Object)chineseContentNodeRef, (Object)this.multilingualContentService.getPivotTranslation(chineseContentNodeRef));
        MultilingualContentServiceImplTest.assertEquals((String)"The wrong language was set as the pivot translation", (Object)chineseContentNodeRef, (Object)this.multilingualContentService.getPivotTranslation(koreanContentNodeRef));
        NodeRef nullNameNodeRef = this.multilingualContentService.addEmptyTranslation(koreanContentNodeRef, null, Locale.CANADA);
        String nullName = this.fileFolderService.getFileInfo(nullNameNodeRef).getName();
        MultilingualContentServiceImplTest.assertEquals((String)"Empty translation name not generated correctly.", (String)"Document_en_CA.txt", (String)nullName);
        MultilingualContentServiceImplTest.assertEquals((String)"The wrong language was set as the pivot translation", (Object)chineseContentNodeRef, (Object)this.multilingualContentService.getPivotTranslation(nullNameNodeRef));
        NodeRef sameNameNodeRef = this.multilingualContentService.addEmptyTranslation(chineseContentNodeRef, "Document.txt", Locale.CANADA_FRENCH);
        String sameName = this.fileFolderService.getFileInfo(sameNameNodeRef).getName();
        MultilingualContentServiceImplTest.assertEquals((String)"Empty translation name not generated correctly.", (String)"Document_fr_CA.txt", (String)sameName);
        MultilingualContentServiceImplTest.assertEquals((String)"The wrong language was set as the pivot translation", (Object)chineseContentNodeRef, (Object)this.multilingualContentService.getPivotTranslation(sameNameNodeRef));
        NodeRef differentNameNodeRef = this.multilingualContentService.addEmptyTranslation(chineseContentNodeRef, "Document2.txt", Locale.JAPANESE);
        String differentName = this.fileFolderService.getFileInfo(differentNameNodeRef).getName();
        MultilingualContentServiceImplTest.assertEquals((String)"Empty translation name not generated correctly.", (String)"Document2.txt", (String)differentName);
        try {
            this.multilingualContentService.addEmptyTranslation(chineseContentNodeRef, "Document2.txt", Locale.FRENCH);
            MultilingualContentServiceImplTest.fail((String)"A duplicate translation filename was created");
        }
        catch (FileExistsException fileExistsException) {}
    }

    public void testGetTranslationContainerPermissions() throws Exception {
        PermissionService permissionService = this.serviceRegistry.getPermissionService();
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)AbstractMultilingualTestCases.ctx.getBean("authenticationComponent");
        permissionService.setPermission(this.folderNodeRef, AuthenticationUtil.getGuestUserName(), "All", true);
        AuthenticationUtil.pushAuthentication();
        try {
            authenticationComponent.setGuestUserAsCurrentUser();
            NodeRef chineseContentNodeRef = this.createContent();
            this.multilingualContentService.makeTranslation(chineseContentNodeRef, Locale.CHINESE);
            this.multilingualContentService.getTranslationContainer(chineseContentNodeRef);
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    public void testPermissions() throws Exception {
        PermissionService permissionService = this.serviceRegistry.getPermissionService();
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)AbstractMultilingualTestCases.ctx.getBean("authenticationComponent");
        permissionService.setPermission(this.folderNodeRef, AuthenticationUtil.getGuestUserName(), "All", true);
        AuthenticationUtil.pushAuthentication();
        try {
            authenticationComponent.setGuestUserAsCurrentUser();
            NodeRef chineseContentNodeRef = this.createContent();
            NodeRef frenchContentNodeRef = this.createContent();
            this.multilingualContentService.makeTranslation(chineseContentNodeRef, Locale.CHINESE);
            this.multilingualContentService.addTranslation(frenchContentNodeRef, chineseContentNodeRef, Locale.FRENCH);
            this.multilingualContentService.addEmptyTranslation(chineseContentNodeRef, null, Locale.JAPANESE);
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    public void testDeleteMultilingualContent() throws Exception {
        NodeRef chineseContentNodeRef = this.createContent();
        NodeRef frenchContentNodeRef = this.createContent();
        NodeRef japaneseContentNodeRef = this.createContent();
        NodeRef emptyGermanContentNodeRef = null;
        this.multilingualContentService.makeTranslation(chineseContentNodeRef, Locale.CHINESE);
        this.multilingualContentService.addTranslation(frenchContentNodeRef, chineseContentNodeRef, Locale.FRENCH);
        this.multilingualContentService.addTranslation(japaneseContentNodeRef, chineseContentNodeRef, Locale.JAPANESE);
        emptyGermanContentNodeRef = this.multilingualContentService.addEmptyTranslation(chineseContentNodeRef, null, Locale.GERMAN);
        NodeRef mlContainerNodeRef = this.multilingualContentService.getTranslationContainer(chineseContentNodeRef);
        MultilingualContentServiceImplTest.assertEquals((String)"Incorrect number of translations", (int)4, (int)this.multilingualContentService.getTranslations(mlContainerNodeRef).size());
        this.multilingualContentService.deleteTranslationContainer(mlContainerNodeRef);
        NodeRef archivedChineseContentNodeRef = this.nodeArchiveService.getArchivedNode(chineseContentNodeRef);
        NodeRef archivedFrenchContentNodeRef = this.nodeArchiveService.getArchivedNode(frenchContentNodeRef);
        NodeRef archivedJapaneseContentNodeRef = this.nodeArchiveService.getArchivedNode(japaneseContentNodeRef);
        NodeRef archivedEmptyGermanContentNodeRef = this.nodeArchiveService.getArchivedNode(emptyGermanContentNodeRef);
        NodeRef archivedMlContainerNodeRef = this.nodeArchiveService.getArchivedNode(mlContainerNodeRef);
        MultilingualContentServiceImplTest.assertFalse((String)"The multilingual container must be removed", (boolean)this.nodeService.exists(mlContainerNodeRef));
        MultilingualContentServiceImplTest.assertFalse((String)"The multilingual container can't be archived", (boolean)this.nodeService.exists(archivedMlContainerNodeRef));
        MultilingualContentServiceImplTest.assertFalse((String)("The translation must be removed: " + Locale.CHINESE), (boolean)this.nodeService.exists(chineseContentNodeRef));
        MultilingualContentServiceImplTest.assertFalse((String)("The translation must be removed: " + Locale.JAPANESE), (boolean)this.nodeService.exists(japaneseContentNodeRef));
        MultilingualContentServiceImplTest.assertFalse((String)("The translation must be removed: " + Locale.FRENCH), (boolean)this.nodeService.exists(frenchContentNodeRef));
        MultilingualContentServiceImplTest.assertFalse((String)("The empty translation must be removed: " + Locale.GERMAN), (boolean)this.nodeService.exists(emptyGermanContentNodeRef));
        MultilingualContentServiceImplTest.assertTrue((String)("The translation must be archived: " + Locale.CHINESE), (boolean)this.nodeService.exists(archivedChineseContentNodeRef));
        MultilingualContentServiceImplTest.assertTrue((String)("The translation must be archived: " + Locale.JAPANESE), (boolean)this.nodeService.exists(archivedJapaneseContentNodeRef));
        MultilingualContentServiceImplTest.assertTrue((String)("The translation must be archived: " + Locale.FRENCH), (boolean)this.nodeService.exists(archivedFrenchContentNodeRef));
        MultilingualContentServiceImplTest.assertFalse((String)("The empty document can't be archived: " + Locale.GERMAN), (boolean)this.nodeService.exists(archivedEmptyGermanContentNodeRef));
        MultilingualContentServiceImplTest.assertFalse((String)("The " + ContentModel.ASPECT_MULTILINGUAL_DOCUMENT + " aspect must be removed for " + Locale.CHINESE), (boolean)this.nodeService.hasAspect(archivedChineseContentNodeRef, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT));
        MultilingualContentServiceImplTest.assertFalse((String)("The " + ContentModel.ASPECT_MULTILINGUAL_DOCUMENT + " aspect must be removed for " + Locale.JAPANESE), (boolean)this.nodeService.hasAspect(archivedJapaneseContentNodeRef, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT));
        MultilingualContentServiceImplTest.assertFalse((String)("The " + ContentModel.ASPECT_MULTILINGUAL_DOCUMENT + " aspect must be removed for " + Locale.FRENCH), (boolean)this.nodeService.hasAspect(archivedFrenchContentNodeRef, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT));
    }

    public void testCopyMLContainerInNewSpace() throws Exception {
        NodeRef chineseContentNodeRef = this.createContent();
        NodeRef frenchContentNodeRef = this.createContent();
        NodeRef japaneseContentNodeRef = this.createContent();
        this.multilingualContentService.makeTranslation(chineseContentNodeRef, Locale.CHINESE);
        this.multilingualContentService.addTranslation(frenchContentNodeRef, chineseContentNodeRef, Locale.FRENCH);
        this.multilingualContentService.addTranslation(japaneseContentNodeRef, chineseContentNodeRef, Locale.JAPANESE);
        this.multilingualContentService.addEmptyTranslation(chineseContentNodeRef, null, Locale.GERMAN);
        NodeRef mlContainerNodeRef = this.multilingualContentService.getTranslationContainer(chineseContentNodeRef);
        MultilingualContentServiceImplTest.assertEquals((String)"Incorrect number of translations", (int)4, (int)this.multilingualContentService.getTranslations(mlContainerNodeRef).size());
        NodeRef actualSpace = this.folderNodeRef;
        NodeRef destinationSpace = this.fileFolderService.create(this.folderNodeRef, "testCopyMLContainerInNewSpace" + GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
        MultilingualContentServiceImplTest.assertTrue((String)("The destiation space is not created " + destinationSpace), (boolean)this.nodeService.exists(destinationSpace));
        NodeRef newMLContainer = this.multilingualContentService.copyTranslationContainer(mlContainerNodeRef, destinationSpace, "");
        MultilingualContentServiceImplTest.assertEquals((String)"Incorrect number of translations for the new mlContainer", (int)4, (int)this.multilingualContentService.getTranslations(newMLContainer).size());
        MultilingualContentServiceImplTest.assertTrue((String)"The new mlContainer is not created ", (boolean)this.nodeService.exists(newMLContainer));
        MultilingualContentServiceImplTest.assertFalse((String)("The newMLContainer is not a copy of the source mlContainer, the ref is the same " + newMLContainer), (boolean)newMLContainer.equals((Object)mlContainerNodeRef));
        MultilingualContentServiceImplTest.assertEquals((String)("The newMLContainer is not a copy of the source mlContainer, the locales are not the same " + newMLContainer), (Object)this.nodeService.getProperty(mlContainerNodeRef, ContentModel.PROP_LOCALE), (Object)this.nodeService.getProperty(newMLContainer, ContentModel.PROP_LOCALE));
        MultilingualContentServiceImplTest.assertEquals((String)("The newMLContainer is not a copy of the source mlContainer, the authors are not the same " + newMLContainer), (Object)this.nodeService.getProperty(mlContainerNodeRef, ContentModel.PROP_AUTHOR), (Object)this.nodeService.getProperty(newMLContainer, ContentModel.PROP_AUTHOR));
        Map sourceTranslations = this.multilingualContentService.getTranslations(mlContainerNodeRef);
        Map copyTranslations = this.multilingualContentService.getTranslations(newMLContainer);
        MultilingualContentServiceImplTest.assertEquals((String)"They are not the same number of translation in the source mlContainer and in its copy", (int)sourceTranslations.size(), (int)copyTranslations.size());
        for (Map.Entry entry : sourceTranslations.entrySet()) {
            Locale locale = (Locale)entry.getKey();
            NodeRef sourceNodeRef = (NodeRef)entry.getValue();
            NodeRef sourceParent = this.nodeService.getPrimaryParent(sourceNodeRef).getParentRef();
            NodeRef copyTranslation = this.multilingualContentService.getTranslationForLocale(newMLContainer, locale);
            NodeRef copyParent = this.nodeService.getPrimaryParent(copyTranslation).getParentRef();
            MultilingualContentServiceImplTest.assertNotNull((String)("No copy found for the locale " + locale), (Object)copyTranslation);
            MultilingualContentServiceImplTest.assertTrue((String)("No copy exists for the locale " + locale), (boolean)this.nodeService.exists(copyTranslation));
            MultilingualContentServiceImplTest.assertTrue((String)"The copy must have the mlDocument aspect", (boolean)this.nodeService.hasAspect(copyTranslation, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT));
            MultilingualContentServiceImplTest.assertEquals((String)"The call of nodeService.hasAspect(nodeRef, ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION) must return the same result for the source and the copy", (boolean)this.nodeService.hasAspect(sourceNodeRef, ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION), (boolean)this.nodeService.hasAspect(copyTranslation, ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION));
            MultilingualContentServiceImplTest.assertNotSame((String)"The copy has the same ref as the source", (Object)sourceNodeRef, (Object)copyTranslation);
            MultilingualContentServiceImplTest.assertEquals((String)"The source would not be moved", (Object)sourceParent, (Object)actualSpace);
            MultilingualContentServiceImplTest.assertEquals((String)"The copy is not in the right space", (Object)copyParent, (Object)destinationSpace);
        }
    }

    public void testCopyMLContainerInSameSpace() throws Exception {
        NodeRef chineseContentNodeRef = this.createContent();
        NodeRef frenchContentNodeRef = this.createContent();
        NodeRef japaneseContentNodeRef = this.createContent();
        this.multilingualContentService.makeTranslation(chineseContentNodeRef, Locale.CHINESE);
        this.multilingualContentService.addTranslation(frenchContentNodeRef, chineseContentNodeRef, Locale.FRENCH);
        this.multilingualContentService.addTranslation(japaneseContentNodeRef, chineseContentNodeRef, Locale.JAPANESE);
        this.multilingualContentService.addEmptyTranslation(chineseContentNodeRef, null, Locale.GERMAN);
        NodeRef mlContainerNodeRef = this.multilingualContentService.getTranslationContainer(chineseContentNodeRef);
        MultilingualContentServiceImplTest.assertEquals((String)"Incorrect number of translations", (int)4, (int)this.multilingualContentService.getTranslations(mlContainerNodeRef).size());
        NodeRef actualSpace = this.folderNodeRef;
        try {
            this.multilingualContentService.copyTranslationContainer(mlContainerNodeRef, actualSpace, "");
            MultilingualContentServiceImplTest.fail((String)"The copy of the mlContainer in the same space would faile");
        }
        catch (Exception exception) {}
    }

    public void testCopyAndRenameMLContainer() throws Exception {
        NodeRef chineseContentNodeRef = this.createContent();
        NodeRef frenchContentNodeRef = this.createContent();
        NodeRef japaneseContentNodeRef = this.createContent();
        this.multilingualContentService.makeTranslation(chineseContentNodeRef, Locale.CHINESE);
        this.multilingualContentService.addTranslation(frenchContentNodeRef, chineseContentNodeRef, Locale.FRENCH);
        this.multilingualContentService.addTranslation(japaneseContentNodeRef, chineseContentNodeRef, Locale.JAPANESE);
        this.multilingualContentService.addEmptyTranslation(chineseContentNodeRef, null, Locale.GERMAN);
        NodeRef mlContainerNodeRef = this.multilingualContentService.getTranslationContainer(chineseContentNodeRef);
        MultilingualContentServiceImplTest.assertEquals((String)"Incorrect number of translations", (int)4, (int)this.multilingualContentService.getTranslations(mlContainerNodeRef).size());
        NodeRef destinationSpace = this.fileFolderService.create(this.folderNodeRef, "testCopyMLContainerInNewSpace" + GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
        MultilingualContentServiceImplTest.assertTrue((String)("The destiation space is not created " + destinationSpace), (boolean)this.nodeService.exists(destinationSpace));
        String PREFIX = "COPY OF ";
        NodeRef newMLContainer = this.multilingualContentService.copyTranslationContainer(mlContainerNodeRef, destinationSpace, PREFIX);
        MultilingualContentServiceImplTest.assertTrue((String)"The new mlContainer is not created ", (boolean)this.nodeService.exists(newMLContainer));
        MultilingualContentServiceImplTest.assertFalse((String)("The newMLContainer is not a copy of the source mlContainer, the ref is the same " + newMLContainer), (boolean)newMLContainer.equals((Object)mlContainerNodeRef));
        Map sourceTranslations = this.multilingualContentService.getTranslations(mlContainerNodeRef);
        Map copyTranslations = this.multilingualContentService.getTranslations(newMLContainer);
        MultilingualContentServiceImplTest.assertEquals((String)"They are not the same number of translation in the source mlContainer and in its copy", (int)sourceTranslations.size(), (int)copyTranslations.size());
        for (Map.Entry entry : sourceTranslations.entrySet()) {
            Locale locale = (Locale)entry.getKey();
            NodeRef sourceNodeRef = (NodeRef)entry.getValue();
            NodeRef copyNodeRef = this.multilingualContentService.getTranslationForLocale(newMLContainer, locale);
            String sourceName = (String)((Object)this.nodeService.getProperty(sourceNodeRef, ContentModel.PROP_NAME));
            String copyName = (String)((Object)this.nodeService.getProperty(copyNodeRef, ContentModel.PROP_NAME));
            String theoricalCopyName = String.valueOf(PREFIX) + sourceName;
            MultilingualContentServiceImplTest.assertTrue((String)("The name of the copied translation is incorect: " + copyName + " and should be " + theoricalCopyName), (boolean)theoricalCopyName.equals(copyName));
        }
    }

    public void testMoveMLContainer() throws Exception {
        NodeRef chineseContentNodeRef = this.createContent();
        NodeRef frenchContentNodeRef = this.createContent();
        NodeRef japaneseContentNodeRef = this.createContent();
        NodeRef emptyGermanContentNodeRef = null;
        this.multilingualContentService.makeTranslation(chineseContentNodeRef, Locale.CHINESE);
        this.multilingualContentService.addTranslation(frenchContentNodeRef, chineseContentNodeRef, Locale.FRENCH);
        this.multilingualContentService.addTranslation(japaneseContentNodeRef, chineseContentNodeRef, Locale.JAPANESE);
        emptyGermanContentNodeRef = this.multilingualContentService.addEmptyTranslation(chineseContentNodeRef, null, Locale.GERMAN);
        NodeRef mlContainerNodeRef = this.multilingualContentService.getTranslationContainer(chineseContentNodeRef);
        MultilingualContentServiceImplTest.assertEquals((String)"Incorrect number of translations", (int)4, (int)this.multilingualContentService.getTranslations(mlContainerNodeRef).size());
        NodeRef destinationSpace = this.fileFolderService.create(this.folderNodeRef, "testCopyMLContainerInNewSpace", ContentModel.TYPE_FOLDER).getNodeRef();
        MultilingualContentServiceImplTest.assertTrue((String)("The destiation space is not created " + destinationSpace), (boolean)this.nodeService.exists(destinationSpace));
        this.multilingualContentService.moveTranslationContainer(mlContainerNodeRef, destinationSpace);
        MultilingualContentServiceImplTest.assertEquals((String)"The node should be moved", (Object)destinationSpace, (Object)this.nodeService.getPrimaryParent(chineseContentNodeRef).getParentRef());
        MultilingualContentServiceImplTest.assertEquals((String)"The node should be moved", (Object)destinationSpace, (Object)this.nodeService.getPrimaryParent(frenchContentNodeRef).getParentRef());
        MultilingualContentServiceImplTest.assertEquals((String)"The node should be moved", (Object)destinationSpace, (Object)this.nodeService.getPrimaryParent(japaneseContentNodeRef).getParentRef());
        MultilingualContentServiceImplTest.assertEquals((String)"The node should be moved", (Object)destinationSpace, (Object)this.nodeService.getPrimaryParent(emptyGermanContentNodeRef).getParentRef());
        MultilingualContentServiceImplTest.assertEquals((String)"The mlContainer should not be changed", (Object)mlContainerNodeRef, (Object)this.multilingualContentService.getTranslationContainer(chineseContentNodeRef));
        MultilingualContentServiceImplTest.assertEquals((String)"The mlContainer should not be changed", (Object)mlContainerNodeRef, (Object)this.multilingualContentService.getTranslationContainer(frenchContentNodeRef));
        MultilingualContentServiceImplTest.assertEquals((String)"The mlContainer should not be changed", (Object)mlContainerNodeRef, (Object)this.multilingualContentService.getTranslationContainer(japaneseContentNodeRef));
        MultilingualContentServiceImplTest.assertEquals((String)"The mlContainer should not be changed", (Object)mlContainerNodeRef, (Object)this.multilingualContentService.getTranslationContainer(emptyGermanContentNodeRef));
    }
}

