/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.util.Locale;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.Result;
import org.springframework.extensions.surf.util.I18NUtil;

public final class Difference
extends Result {
    private final Where where;
    private final DbProperty left;
    private final DbProperty right;

    public Difference(Where where, DbProperty left, DbProperty right) {
        if (left == null && right == null) {
            throw new IllegalArgumentException("DbProperty parameters cannot BOTH be null.");
        }
        this.where = where;
        this.left = left;
        this.right = right;
    }

    public Where getWhere() {
        return this.where;
    }

    public DbProperty getLeft() {
        return this.left;
    }

    public DbProperty getRight() {
        return this.right;
    }

    @Override
    public String describe() {
        return this.doDescribe(I18NUtil.getLocale());
    }

    @Override
    public String describe(Locale locale) {
        return this.doDescribe(locale);
    }

    private String doDescribe(Locale locale) {
        if (this.getLeft() == null) {
            return I18NUtil.getMessage((String)"system.schema_comp.diff.target_only", (Locale)locale, (Object[])new Object[]{this.getRight().getDbObject().getTypeName(), this.getRight().getPath(), this.getRight().getPropertyValue()});
        }
        if (this.getRight() == null) {
            return I18NUtil.getMessage((String)"system.schema_comp.diff.ref_only", (Locale)locale, (Object[])new Object[]{this.getLeft().getDbObject().getTypeName(), this.getLeft().getPath(), this.getLeft().getPropertyValue()});
        }
        return I18NUtil.getMessage((String)"system.schema_comp.diff", (Locale)locale, (Object[])new Object[]{this.getLeft().getDbObject().getTypeName(), this.getLeft().getPath(), this.getLeft().getPropertyValue(), this.getRight().getPath(), this.getRight().getPropertyValue()});
    }

    public String toString() {
        return "Difference [where=" + (Object)((Object)this.where) + ", left=" + this.left + ", right=" + this.right + "]";
    }

    public static enum Where {
        ONLY_IN_REFERENCE,
        ONLY_IN_TARGET,
        IN_BOTH_NO_DIFFERENCE,
        IN_BOTH_BUT_DIFFERENCE;

    }
}

