/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.query;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.error.ExceptionStackUtil;
import org.alfresco.repo.domain.mimetype.MimetypeDAO;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.GUID;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.testing.category.DBTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@Category(value={OwnJVMTestsCategory.class, DBTests.class})
public class CannedQueryDAOTest {
    private static final String QUERY_NS = "alfresco.query.test";
    private static final String QUERY_SELECT_MIMETYPE_COUNT = "select_CountMimetypes";
    private static final String QUERY_SELECT_MIMETYPES = "select_Mimetypes";
    public static final String IBATIS_TEST_CONTEXT = "classpath*:alfresco/ibatis/ibatis-test-context.xml";
    public static ApplicationContextInit APP_CONTEXT_INIT = ApplicationContextInit.createStandardContextWithOverrides("classpath*:alfresco/ibatis/ibatis-test-context.xml");
    @ClassRule
    public static RuleChain staticRuleChain = RuleChain.outerRule((TestRule)APP_CONTEXT_INIT);
    private static TransactionService transactionService;
    private static RetryingTransactionHelper txnHelper;
    private static CannedQueryDAO cannedQueryDAO;
    private static CannedQueryDAO cannedQueryDAOForTesting;
    private static MimetypeDAO mimetypeDAO;
    private static String mimetypePrefix;

    @BeforeClass
    public static void setup() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)APP_CONTEXT_INIT.getApplicationContext().getBean("ServiceRegistry");
        transactionService = serviceRegistry.getTransactionService();
        txnHelper = transactionService.getRetryingTransactionHelper();
        cannedQueryDAO = (CannedQueryDAO)APP_CONTEXT_INIT.getApplicationContext().getBean("cannedQueryDAO");
        cannedQueryDAOForTesting = (CannedQueryDAO)APP_CONTEXT_INIT.getApplicationContext().getBean("cannedQueryDAOForTesting");
        mimetypeDAO = (MimetypeDAO)APP_CONTEXT_INIT.getApplicationContext().getBean("mimetypeDAO");
        RetryingTransactionHelper.RetryingTransactionCallback<String> createMimetypeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            public String execute() throws Throwable {
                String mimetypePrefix = GUID.generate();
                mimetypeDAO.getOrCreateMimetype(String.valueOf(mimetypePrefix) + "-aaa");
                mimetypeDAO.getOrCreateMimetype(String.valueOf(mimetypePrefix) + "-bbb");
                return mimetypePrefix;
            }
        };
        mimetypePrefix = (String)txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createMimetypeCallback);
    }

    @Test
    public void testExecute_FailureRecovery() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> failCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TestOneParams params = new TestOneParams(null, true);
                params.setForceFail(true);
                try {
                    cannedQueryDAOForTesting.executeCountQuery(CannedQueryDAOTest.QUERY_NS, CannedQueryDAOTest.QUERY_SELECT_MIMETYPE_COUNT, (Object)params);
                    Assert.fail((String)"Expected bad SQL");
                }
                catch (Throwable throwable) {}
                mimetypeDAO.getOrCreateMimetype(String.valueOf(mimetypePrefix) + "_postfail");
                return null;
            }
        };
        txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)failCallback, false);
    }

    @Test
    public void testExecute_CountAllMimetypes() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> selectCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                TestOneParams params = new TestOneParams(null, true);
                return cannedQueryDAOForTesting.executeCountQuery(CannedQueryDAOTest.QUERY_NS, CannedQueryDAOTest.QUERY_SELECT_MIMETYPE_COUNT, (Object)params);
            }
        };
        Long count = (Long)txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)selectCallback, true);
        Assert.assertNotNull((Object)count);
        Assert.assertTrue((count > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testExecute_CountNoResults() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> selectCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                TestOneParams params = new TestOneParams(GUID.generate(), true);
                return cannedQueryDAOForTesting.executeCountQuery(CannedQueryDAOTest.QUERY_NS, CannedQueryDAOTest.QUERY_SELECT_MIMETYPE_COUNT, (Object)params);
            }
        };
        Long count = (Long)txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)selectCallback, true);
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((String)"Incorrect result count.", (long)0L, (long)count);
    }

    @Test
    public void testExecute_CountMimetypeExact() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> selectCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                TestOneParams params = new TestOneParams(String.valueOf(mimetypePrefix) + "-aaa", true);
                return cannedQueryDAOForTesting.executeCountQuery(CannedQueryDAOTest.QUERY_NS, CannedQueryDAOTest.QUERY_SELECT_MIMETYPE_COUNT, (Object)params);
            }
        };
        Long count = (Long)txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)selectCallback, true);
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((String)"Incorrect result count.", (long)1L, (long)count);
    }

    @Test
    public void testExecute_CountMimetypeWildcard() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> selectCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                TestOneParams params = new TestOneParams(String.valueOf(mimetypePrefix) + "-%", false);
                return cannedQueryDAOForTesting.executeCountQuery(CannedQueryDAOTest.QUERY_NS, CannedQueryDAOTest.QUERY_SELECT_MIMETYPE_COUNT, (Object)params);
            }
        };
        Long count = (Long)txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)selectCallback, true);
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((String)"Incorrect result count.", (long)2L, (long)count);
    }

    @Test
    public void testExecute_BadBounds() throws Throwable {
        try {
            cannedQueryDAOForTesting.executeQuery(QUERY_NS, QUERY_SELECT_MIMETYPES, null, -1, 10);
            Assert.fail((String)"Illegal parameter not detected");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            cannedQueryDAOForTesting.executeQuery(QUERY_NS, QUERY_SELECT_MIMETYPES, null, 0, -1);
            Assert.fail((String)"Illegal parameter not detected");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testExecute_ListMimetypes() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<List<String>> selectCallback = new RetryingTransactionHelper.RetryingTransactionCallback<List<String>>(){

            public List<String> execute() throws Throwable {
                TestOneParams params = new TestOneParams(null, false);
                return cannedQueryDAOForTesting.executeQuery(CannedQueryDAOTest.QUERY_NS, CannedQueryDAOTest.QUERY_SELECT_MIMETYPES, (Object)params, 0, 2);
            }
        };
        List mimetypes = (List)txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)selectCallback, true);
        Assert.assertNotNull((Object)mimetypes);
        Assert.assertTrue((String)"Too many results", (mimetypes.size() <= 2 ? 1 : 0) != 0);
    }

    @Test
    public void testExecute_ResultHandlerWithError() throws Throwable {
        CannedQueryDAO.ResultHandler<String> resultHandler = new CannedQueryDAO.ResultHandler<String>(){

            public boolean handleResult(String result) {
                throw new UnsupportedOperationException();
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<List<String>> selectCallback = new RetryingTransactionHelper.RetryingTransactionCallback<List<String>>((CannedQueryDAO.ResultHandler)resultHandler){
            private final /* synthetic */ CannedQueryDAO.ResultHandler val$resultHandler;
            {
                this.val$resultHandler = resultHandler;
            }

            public List<String> execute() throws Throwable {
                TestOneParams params;
                block2: {
                    params = new TestOneParams(null, false);
                    try {
                        cannedQueryDAOForTesting.executeQuery(CannedQueryDAOTest.QUERY_NS, CannedQueryDAOTest.QUERY_SELECT_MIMETYPES, (Object)params, 0, 2, this.val$resultHandler);
                        Assert.fail((String)"Expected UnsupportedOperationException");
                    }
                    catch (Exception e) {
                        Throwable ee = ExceptionStackUtil.getCause((Throwable)e, (Class[])new Class[]{UnsupportedOperationException.class});
                        if (ee != null) break block2;
                        throw e;
                    }
                }
                return cannedQueryDAOForTesting.executeQuery(CannedQueryDAOTest.QUERY_NS, CannedQueryDAOTest.QUERY_SELECT_MIMETYPES, (Object)params, 0, 2);
            }
        };
        List mimetypes = (List)txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)selectCallback, true);
        Assert.assertNotNull((Object)mimetypes);
        Assert.assertTrue((String)"Too many results", (mimetypes.size() <= 2 ? 1 : 0) != 0);
    }

    @Test
    public void testExecute_ResultHandlerWithEarlyTermination() throws Throwable {
        final ArrayList results = new ArrayList();
        CannedQueryDAO.ResultHandler<String> resultHandler = new CannedQueryDAO.ResultHandler<String>(){

            public boolean handleResult(String result) {
                results.add(result);
                return false;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> selectCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>((CannedQueryDAO.ResultHandler)resultHandler){
            private final /* synthetic */ CannedQueryDAO.ResultHandler val$resultHandler;
            {
                this.val$resultHandler = resultHandler;
            }

            public Void execute() throws Throwable {
                TestOneParams params = new TestOneParams(null, false);
                cannedQueryDAOForTesting.executeQuery(CannedQueryDAOTest.QUERY_NS, CannedQueryDAOTest.QUERY_SELECT_MIMETYPES, (Object)params, 0, 2, this.val$resultHandler);
                return null;
            }
        };
        txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)selectCallback, true);
        Assert.assertEquals((String)"ResultHandler did not terminate early", (long)1L, (long)results.size());
    }

    public static class TestOneParams {
        private final String mimetypeMatch;
        private final boolean exact;
        private boolean forceFail;

        public TestOneParams(String mimetypeMatch, boolean exact) {
            this.mimetypeMatch = mimetypeMatch;
            this.exact = exact;
            this.forceFail = false;
        }

        public String toString() {
            return "TestOneParams [mimetypeMatch=" + this.mimetypeMatch + ", exact=" + this.exact + "]";
        }

        public String getMimetypeMatch() {
            return this.mimetypeMatch;
        }

        public boolean isExact() {
            return this.exact;
        }

        public boolean isForceFail() {
            return this.forceFail;
        }

        public void setForceFail(boolean forceFail) {
            this.forceFail = forceFail;
        }
    }
}

