/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.schema.script;

import java.io.File;
import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.schema.script.DeleteNotExistsV3Executor;
import org.alfresco.repo.domain.schema.script.ScriptExecutor;
import org.alfresco.repo.domain.schema.script.ScriptExecutorImpl;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.DBTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;

@Category(value={DBTests.class})
public class DeleteNotExistsV3ExecutorTest {
    private static ApplicationContext ctx;
    private ScriptExecutor scriptExecutor;
    private DataSource dataSource;
    private Dialect dialect;
    private JdbcTemplate jdbcTmpl;

    @BeforeClass
    public static void setUpBeforeClass() {
        String[] config = new String[]{"classpath:alfresco/application-context.xml", "classpath:scriptexec/script-exec-test.xml"};
        ctx = ApplicationContextHelper.getApplicationContext((String[])config);
    }

    @Before
    public void setUp() throws Exception {
        this.scriptExecutor = (ScriptExecutor)ctx.getBean("simpleScriptExecutor", ScriptExecutorImpl.class);
        this.dataSource = (DataSource)ctx.getBean("dataSource", DataSource.class);
        this.dialect = (Dialect)ctx.getBean("dialect", Dialect.class);
        this.jdbcTmpl = new JdbcTemplate(this.dataSource);
    }

    private DeleteNotExistsV3Executor createDeleteNotExistsV3Executor(Dialect dialect, Connection connection, String sql, int line, File scriptFile, Properties properties) {
        return new DeleteNotExistsV3Executor(dialect, connection, sql, line, scriptFile, properties, this.dataSource);
    }

    @Test
    public void testDefaultBehaviour() throws Exception {
        List res;
        DeleteNotExistsV3Executor deleteNotExistsV3Executor;
        Connection connection;
        this.scriptExecutor.executeScriptUrl("scriptexec/${db.script.dialect}/delete-not-exists/test-data1.sql");
        String sql = "--DELETE_NOT_EXISTS_V3 temp_tst_tbl_1.id,temp_tst_tbl_2.tbl_2_id,temp_tst_tbl_3.tbl_3_id,temp_tst_tbl_4.tbl_4_id system.delete_not_exists.batchsize system.delete_not_exists.temp_tst_tbl_1.skipToId";
        int line = 1;
        File scriptFile = (File)Mockito.mock(File.class);
        Properties properties = (Properties)Mockito.mock(Properties.class);
        String select = "select id from temp_tst_tbl_1 order by id ASC";
        Throwable throwable = null;
        Object var7_9 = null;
        try {
            connection = this.dataSource.getConnection();
            try {
                connection.setAutoCommit(true);
                Mockito.when((Object)properties.getProperty("system.delete_not_exists.read_only")).thenReturn((Object)"true");
                Mockito.when((Object)properties.getProperty("system.delete_not_exists.timeout_seconds")).thenReturn((Object)"-1");
                deleteNotExistsV3Executor = this.createDeleteNotExistsV3Executor(this.dialect, connection, sql, line, scriptFile, properties);
                deleteNotExistsV3Executor.execute();
                res = this.jdbcTmpl.queryForList(select, String.class);
                Assert.assertEquals((long)7L, (long)res.size());
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var7_9 = null;
        try {
            connection = this.dataSource.getConnection();
            try {
                connection.setAutoCommit(true);
                Mockito.when((Object)properties.getProperty("system.delete_not_exists.read_only")).thenReturn((Object)"false");
                Mockito.when((Object)properties.getProperty("system.delete_not_exists.timeout_seconds")).thenReturn((Object)"-1");
                deleteNotExistsV3Executor = this.createDeleteNotExistsV3Executor(this.dialect, connection, sql, line, scriptFile, properties);
                deleteNotExistsV3Executor.execute();
                res = this.jdbcTmpl.queryForList(select, String.class);
                Assert.assertEquals((long)5L, (long)res.size());
                Assert.assertEquals((Object)"1", res.get(0));
                Assert.assertEquals((Object)"2", res.get(1));
                Assert.assertEquals((Object)"4", res.get(2));
                Assert.assertEquals((Object)"10", res.get(3));
                Assert.assertEquals((Object)"11", res.get(4));
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void testDeleteBatch() throws Exception {
        this.scriptExecutor.executeScriptUrl("scriptexec/${db.script.dialect}/delete-not-exists/test-data1.sql");
        String sql = "--DELETE_NOT_EXISTS_V3 temp_tst_tbl_1.id,temp_tst_tbl_2.tbl_2_id,temp_tst_tbl_3.tbl_3_id,temp_tst_tbl_4.tbl_4_id system.delete_not_exists.batchsize system.delete_not_exists.temp_tst_tbl_1.skipToId";
        int line = 1;
        File scriptFile = (File)Mockito.mock(File.class);
        Properties properties = (Properties)Mockito.mock(Properties.class);
        String select = "select id from temp_tst_tbl_1 order by id ASC";
        Throwable throwable = null;
        Object var7_8 = null;
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(true);
            Mockito.when((Object)properties.getProperty("system.delete_not_exists.delete_batchsize")).thenReturn((Object)"1");
            Mockito.when((Object)properties.getProperty("system.delete_not_exists.read_only")).thenReturn((Object)"false");
            DeleteNotExistsV3Executor deleteNotExistsV3Executor = this.createDeleteNotExistsV3Executor(this.dialect, connection, sql, line, scriptFile, properties);
            deleteNotExistsV3Executor.execute();
            List res = this.jdbcTmpl.queryForList(select, String.class);
            Assert.assertEquals((long)5L, (long)res.size());
            Assert.assertEquals((Object)"1", res.get(0));
            Assert.assertEquals((Object)"2", res.get(1));
            Assert.assertEquals((Object)"4", res.get(2));
            Assert.assertEquals((Object)"10", res.get(3));
            Assert.assertEquals((Object)"11", res.get(4));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testBatchExecute() throws Exception {
        this.scriptExecutor.executeScriptUrl("scriptexec/${db.script.dialect}/delete-not-exists/test-data1.sql");
        String sql = "--DELETE_NOT_EXISTS_V3 temp_tst_tbl_1.id,temp_tst_tbl_2.tbl_2_id,temp_tst_tbl_3.tbl_3_id,temp_tst_tbl_4.tbl_4_id system.delete_not_exists.batchsize system.delete_not_exists.temp_tst_tbl_1.skipToId";
        int line = 1;
        File scriptFile = (File)Mockito.mock(File.class);
        Properties properties = (Properties)Mockito.mock(Properties.class);
        String select = "select id from temp_tst_tbl_1 order by id ASC";
        Throwable throwable = null;
        Object var7_8 = null;
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(true);
            Mockito.when((Object)properties.getProperty("system.delete_not_exists.batchsize")).thenReturn((Object)"2");
            Mockito.when((Object)properties.getProperty("system.delete_not_exists.read_only")).thenReturn((Object)"false");
            Mockito.when((Object)properties.getProperty("system.delete_not_exists.timeout_seconds")).thenReturn((Object)"-1");
            DeleteNotExistsV3Executor DeleteNotExistsV3Executor2 = this.createDeleteNotExistsV3Executor(this.dialect, connection, sql, line, scriptFile, properties);
            DeleteNotExistsV3Executor2.execute();
            List res = this.jdbcTmpl.queryForList(select, String.class);
            Assert.assertEquals((long)5L, (long)res.size());
            Assert.assertEquals((Object)"1", res.get(0));
            Assert.assertEquals((Object)"2", res.get(1));
            Assert.assertEquals((Object)"4", res.get(2));
            Assert.assertEquals((Object)"10", res.get(3));
            Assert.assertEquals((Object)"11", res.get(4));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testSkip() throws Exception {
        this.scriptExecutor.executeScriptUrl("scriptexec/${db.script.dialect}/delete-not-exists/test-data1.sql");
        String sql = "--DELETE_NOT_EXISTS_V3 temp_tst_tbl_1.id,temp_tst_tbl_2.tbl_2_id,temp_tst_tbl_3.tbl_3_id,temp_tst_tbl_4.tbl_4_id system.delete_not_exists.batchsize system.delete_not_exists.temp_tst_tbl_1.skipToId";
        int line = 1;
        File scriptFile = (File)Mockito.mock(File.class);
        Properties properties = (Properties)Mockito.mock(Properties.class);
        String select = "select id from temp_tst_tbl_1 order by id ASC";
        Throwable throwable = null;
        Object var7_8 = null;
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(true);
            Mockito.when((Object)properties.getProperty("system.delete_not_exists.batchsize")).thenReturn((Object)"2");
            Mockito.when((Object)properties.getProperty("system.delete_not_exists.read_only")).thenReturn((Object)"false");
            Mockito.when((Object)properties.getProperty("system.delete_not_exists.timeout_seconds")).thenReturn((Object)"-1");
            Mockito.when((Object)properties.getProperty("system.delete_not_exists.temp_tst_tbl_1.skipToId")).thenReturn((Object)"6");
            DeleteNotExistsV3Executor deleteNotExistsV3Executor = this.createDeleteNotExistsV3Executor(this.dialect, connection, sql, line, scriptFile, properties);
            deleteNotExistsV3Executor.execute();
            List res = this.jdbcTmpl.queryForList(select, String.class);
            Assert.assertEquals((long)7L, (long)res.size());
            Assert.assertEquals((Object)"1", res.get(0));
            Assert.assertEquals((Object)"2", res.get(1));
            Assert.assertEquals((Object)"3", res.get(2));
            Assert.assertEquals((Object)"4", res.get(3));
            Assert.assertEquals((Object)"5", res.get(4));
            Assert.assertEquals((Object)"10", res.get(5));
            Assert.assertEquals((Object)"11", res.get(6));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

